/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forge.net.mca.Config;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.item.BabyItem;
import forge.net.mca.server.SpawnQueue;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.server.world.data.VillageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.UUIDArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AdminCommand {
    private static final List<CompoundNBT> storedVillagers = new ArrayList<CompoundNBT>();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mca-admin").then(AdminCommand.register("help", (Command<CommandSource>)((Command)AdminCommand::displayHelp)))).then(AdminCommand.register("clearLoadedVillagers", (Command<CommandSource>)((Command)AdminCommand::clearLoadedVillagers)))).then(AdminCommand.register("restoreClearedVillagers", (Command<CommandSource>)((Command)AdminCommand::restoreClearedVillagers)))).then(AdminCommand.register("forceBuildingType").then(Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.string()).executes(AdminCommand::forceBuildingType)).executes(AdminCommand::clearForcedBuildingType))).then(AdminCommand.register("forceFullHearts", (Command<CommandSource>)((Command)AdminCommand::forceFullHearts)))).then(AdminCommand.register("forceBabyGrowth", (Command<CommandSource>)((Command)AdminCommand::forceBabyGrowth)))).then(AdminCommand.register("forceChildGrowth", (Command<CommandSource>)((Command)AdminCommand::forceChildGrowth)))).then(AdminCommand.register("incrementHearts", (Command<CommandSource>)((Command)AdminCommand::incrementHearts)))).then(AdminCommand.register("decrementHearts", (Command<CommandSource>)((Command)AdminCommand::decrementHearts)))).then(AdminCommand.register("resetPlayerData", (Command<CommandSource>)((Command)AdminCommand::resetPlayerData)))).then(AdminCommand.register("resetMarriage", (Command<CommandSource>)((Command)AdminCommand::resetMarriage)))).then(AdminCommand.register("listVillages", (Command<CommandSource>)((Command)AdminCommand::listVillages)))).then(AdminCommand.register("assumeNameDead").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(AdminCommand::assumeNameDead)))).then(AdminCommand.register("assumeUuidDead").then(Commands.func_197056_a((String)"uuid", (ArgumentType)UUIDArgument.func_239194_a_()).executes(AdminCommand::assumeUuidDead)))).then(AdminCommand.register("removeVillageWithId").then(Commands.func_197056_a((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(AdminCommand::removeVillageWithId)))).then(AdminCommand.register("convertVanillaVillagers").then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(AdminCommand::convertVanillaVillagers)))).then(AdminCommand.register("removeVillage").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(AdminCommand::removeVillage)))).then(AdminCommand.register("buildingProcessingRate").then(Commands.func_197056_a((String)"cooldown", (ArgumentType)IntegerArgumentType.integer()).executes(AdminCommand::buildingProcessingRate)))).requires(serverCommandSource -> serverCommandSource.func_197034_c(2)));
    }

    private static int listVillages(CommandContext<CommandSource> ctx) {
        for (Village village : VillageManager.get(((CommandSource)ctx.getSource()).func_197023_e())) {
            BlockPos pos = new BlockPos(village.getBox().func_215126_f());
            AdminCommand.success(String.format("%d: %s with %d buildings and %d/%d villager(s)", village.getId(), village.getName(), village.getBuildings().size(), village.getPopulation(), village.getMaxPopulation()), ctx, new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.coordinates.tooltip")), new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.func_177958_n() + " ~ " + pos.func_177952_p()));
        }
        return 0;
    }

    private static int assumeNameDead(CommandContext<CommandSource> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        FamilyTree tree = FamilyTree.get(((CommandSource)ctx.getSource()).func_197023_e());
        List collect = tree.getAllWithName(name).filter(n -> !n.isDeceased()).collect(Collectors.toList());
        if (collect.isEmpty()) {
            AdminCommand.fail("Villager does not exist.", ctx, new Object[0]);
        } else if (collect.size() == 1) {
            ((FamilyTreeNode)collect.get(0)).setDeceased(true);
            AdminCommand.assumeDead(ctx, ((FamilyTreeNode)collect.get(0)).id());
            AdminCommand.success("Villager has been marked as deceased", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Villager not unique, use uuid!", ctx, new Object[0]);
        }
        return 0;
    }

    private static int assumeUuidDead(CommandContext<CommandSource> ctx) {
        UUID uuid = UUIDArgument.func_239195_a_(ctx, (String)"uuid");
        FamilyTree tree = FamilyTree.get(((CommandSource)ctx.getSource()).func_197023_e());
        Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
        if (node.isPresent()) {
            node.get().setDeceased(true);
            AdminCommand.assumeDead(ctx, uuid);
            AdminCommand.success("Villager has been marked as deceased", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Villager does not exist.", ctx, new Object[0]);
        }
        return 0;
    }

    private static void assumeDead(CommandContext<CommandSource> ctx, UUID uuid) {
        for (Village village : VillageManager.get(((CommandSource)ctx.getSource()).func_197023_e())) {
            village.removeResident(uuid);
        }
        FamilyTree tree = FamilyTree.get(((CommandSource)ctx.getSource()).func_197023_e());
        Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
        node.filter(n -> n.partner() != null).ifPresent(n -> n.updatePartner(null, RelationshipState.WIDOW));
        ((CommandSource)ctx.getSource()).func_197023_e().func_217369_A().forEach(player -> {
            PlayerSaveData playerData = PlayerSaveData.get(player);
            if (playerData.getPartnerUUID().orElse(Util.field_240973_b_).equals(uuid)) {
                playerData.endRelationShip(RelationshipState.SINGLE);
            }
        });
    }

    private static int removeVillageWithId(CommandContext<CommandSource> ctx) {
        int id = IntegerArgumentType.getInteger(ctx, (String)"id");
        if (VillageManager.get(((CommandSource)ctx.getSource()).func_197023_e()).removeVillage(id)) {
            AdminCommand.success("Village deleted.", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Village with this ID does not exist.", ctx, new Object[0]);
        }
        return 0;
    }

    private static int convertVanillaVillagers(CommandContext<CommandSource> ctx) {
        int radius = IntegerArgumentType.getInteger(ctx, (String)"radius");
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        world.func_217482_a(EntityType.field_200756_av, x -> true).stream().map(VillagerEntity.class::cast).forEach(v -> {
            if (v.func_70032_d(((CommandSource)ctx.getSource()).func_197022_f()) < (float)radius) {
                SpawnQueue.getInstance().convert((VillagerEntity)v);
            }
        });
        return 0;
    }

    private static int setBuildingType(CommandContext<CommandSource> ctx, String type) throws CommandSyntaxException {
        ServerPlayerEntity e = ((CommandSource)ctx.getSource()).func_197035_h();
        VillageManager villages = VillageManager.get(((CommandSource)ctx.getSource()).func_197023_e());
        Optional<Village> village = villages.findNearestVillage((Entity)e);
        Optional building = village.flatMap(arg_0 -> AdminCommand.lambda$setBuildingType$8((PlayerEntity)e, arg_0));
        if (building.isPresent()) {
            if (((Building)building.get()).getType().equals(type)) {
                ((Building)building.get()).determineType();
            } else {
                ((Building)building.get()).setForcedType(type);
            }
        } else {
            AdminCommand.fail(new TranslationTextComponent("blueprint.noBuilding").getString(), ctx, new Object[0]);
        }
        return 0;
    }

    private static int forceBuildingType(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return AdminCommand.setBuildingType(ctx, StringArgumentType.getString(ctx, (String)"type"));
    }

    private static int clearForcedBuildingType(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return AdminCommand.setBuildingType(ctx, null);
    }

    private static int removeVillage(CommandContext<CommandSource> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        List collect = VillageManager.get(((CommandSource)ctx.getSource()).func_197023_e()).findVillages(v -> v.getName().equals(name)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            AdminCommand.fail("No village with this name exists.", ctx, new Object[0]);
        } else if (collect.size() > 1) {
            AdminCommand.success("Village deleted.", ctx, new Object[0]);
            AdminCommand.fail("No village with this name exists.", ctx, new Object[0]);
        } else if (VillageManager.get(((CommandSource)ctx.getSource()).func_197023_e()).removeVillage(((Village)collect.get(0)).getId())) {
            AdminCommand.success("Village deleted.", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Unknown error.", ctx, new Object[0]);
        }
        return 0;
    }

    private static int buildingProcessingRate(CommandContext<CommandSource> ctx) {
        int cooldown = IntegerArgumentType.getInteger(ctx, (String)"cooldown");
        VillageManager.get(((CommandSource)ctx.getSource()).func_197023_e()).setBuildingCooldown(cooldown);
        return 0;
    }

    private static int resetPlayerData(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        PlayerSaveData playerData = PlayerSaveData.get(player);
        playerData.reset();
        AdminCommand.success("Player data reset.", ctx, new Object[0]);
        return 0;
    }

    private static int resetMarriage(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        PlayerSaveData playerData = PlayerSaveData.get(player);
        playerData.endRelationShip(RelationshipState.SINGLE);
        AdminCommand.success("Marriage reset.", ctx, new Object[0]);
        return 0;
    }

    private static int decrementHearts(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        AdminCommand.getLoadedVillagers(ctx).forEach(arg_0 -> AdminCommand.lambda$decrementHearts$10((PlayerEntity)player, arg_0));
        return 0;
    }

    private static int incrementHearts(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        AdminCommand.getLoadedVillagers(ctx).forEach(arg_0 -> AdminCommand.lambda$incrementHearts$11((PlayerEntity)player, arg_0));
        return 0;
    }

    private static int forceChildGrowth(CommandContext<CommandSource> ctx) {
        AdminCommand.getLoadedVillagers(ctx).forEach(v -> v.func_70873_a(0));
        return 0;
    }

    private static int forceBabyGrowth(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        ItemStack heldStack = player.func_184614_ca();
        if (heldStack.func_77973_b() instanceof BabyItem) {
            heldStack.func_196082_o().func_74768_a("age", Config.getInstance().babyItemGrowUpTime);
            AdminCommand.success("Baby is old enough to place now.", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Hold a baby first.", ctx, new Object[0]);
        }
        return 0;
    }

    private static int forceFullHearts(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        AdminCommand.getLoadedVillagers(ctx).forEach(arg_0 -> AdminCommand.lambda$forceFullHearts$13((PlayerEntity)player, arg_0));
        return 0;
    }

    private static int restoreClearedVillagers(CommandContext<CommandSource> ctx) {
        storedVillagers.forEach(tag -> EntityType.func_220330_a((CompoundNBT)tag, (World)((CommandSource)ctx.getSource()).func_197023_e()).ifPresent(v -> ((CommandSource)ctx.getSource()).func_197023_e().func_217376_c(v)));
        storedVillagers.clear();
        AdminCommand.success("Restored cleared villagers.", ctx, new Object[0]);
        return 0;
    }

    private static ArgumentBuilder<CommandSource, ?> register(String name, Command<CommandSource> cmd) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> cs.func_197034_c(2))).executes(cmd);
    }

    private static ArgumentBuilder<CommandSource, ?> register(String name) {
        return Commands.func_197057_a((String)name).requires(cs -> cs.func_197034_c(2));
    }

    private static int clearLoadedVillagers(CommandContext<CommandSource> ctx) {
        storedVillagers.clear();
        AdminCommand.getLoadedVillagers(ctx).forEach(v -> {
            CompoundNBT tag = new CompoundNBT();
            if (v.func_184198_c(tag)) {
                storedVillagers.add(tag);
                v.func_70106_y();
            }
        });
        AdminCommand.success("Removed loaded villagers.", ctx, new Object[0]);
        return 0;
    }

    private static Stream<VillagerEntityMCA> getLoadedVillagers(CommandContext<CommandSource> ctx) {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        return Stream.concat(world.func_217482_a((EntityType)EntitiesMCA.FEMALE_VILLAGER.get(), x -> true).stream(), world.func_217482_a((EntityType)EntitiesMCA.MALE_VILLAGER.get(), x -> true).stream()).map(VillagerEntityMCA.class::cast);
    }

    private static void success(String message, CommandContext<CommandSource> ctx, Object ... events) {
        ((CommandSource)ctx.getSource()).func_197030_a(AdminCommand.message(message, TextFormatting.GREEN, events), true);
    }

    private static void fail(String message, CommandContext<CommandSource> ctx, Object ... events) {
        ((CommandSource)ctx.getSource()).func_197021_a(AdminCommand.message(message, TextFormatting.RED, events));
    }

    private static ITextComponent message(String message, TextFormatting red, Object[] events) {
        IFormattableTextComponent data = new StringTextComponent(message).func_240699_a_(red);
        for (Object evt : events) {
            if (evt instanceof ClickEvent) {
                ClickEvent clickEvent = (ClickEvent)evt;
                data.func_240700_a_(style -> style.func_240715_a_(clickEvent));
            }
            if (!(evt instanceof HoverEvent)) continue;
            HoverEvent hoverEvent = (HoverEvent)evt;
            data.func_240700_a_(style -> style.func_240716_a_(hoverEvent));
        }
        return data;
    }

    private static int displayHelp(CommandContext<CommandSource> ctx) {
        Entity player = ((CommandSource)ctx.getSource()).func_197022_f();
        if (player == null) {
            return 0;
        }
        AdminCommand.sendMessage(player, TextFormatting.DARK_RED + "--- " + TextFormatting.GOLD + "OP COMMANDS" + TextFormatting.DARK_RED + " ---");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin forceBuildingType id " + TextFormatting.GOLD + " - Force a building's type. " + TextFormatting.RED + "(Must be a valid building type)");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin forceFullHearts " + TextFormatting.GOLD + " - Force all hearts on all villagers.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin forceBabyGrowth " + TextFormatting.GOLD + " - Force your baby to grow up.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin forceChildGrowth " + TextFormatting.GOLD + " - Force nearby children to grow.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin clearLoadedVillagers " + TextFormatting.GOLD + " - Clear all loaded villagers. " + TextFormatting.RED + "(IRREVERSIBLE)");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin restoreClearedVillagers " + TextFormatting.GOLD + " - Restores cleared villagers. ");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin listVillages " + TextFormatting.GOLD + " - Prints a list of all villages.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin removeVillage id" + TextFormatting.GOLD + " - Removed a village with given id.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin convertVanillaVillagers radius" + TextFormatting.GOLD + " - Convert vanilla villagers in the given radius");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin incrementHearts " + TextFormatting.GOLD + " - Increase hearts by 10.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin decrementHearts " + TextFormatting.GOLD + " - Decrease hearts by 10.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin cve" + TextFormatting.GOLD + " - Remove all villager editors from the game.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin resetPlayerData " + TextFormatting.GOLD + " - Resets hearts, marriage status etc.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin resetMarriage " + TextFormatting.GOLD + " - Resets your marriage.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin listVillages " + TextFormatting.GOLD + " - List all known villages.");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin removeVillage " + TextFormatting.GOLD + " - Remove a given village.");
        AdminCommand.sendMessage(player, TextFormatting.DARK_RED + "--- " + TextFormatting.GOLD + "GLOBAL COMMANDS" + TextFormatting.DARK_RED + " ---");
        AdminCommand.sendMessage(player, TextFormatting.WHITE + " /mca-admin help " + TextFormatting.GOLD + " - Shows this list of commands.");
        return 0;
    }

    private static void sendMessage(Entity commandSender, String message) {
        commandSender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "[MCA] " + TextFormatting.RESET + message), Util.field_240973_b_);
    }

    private static /* synthetic */ void lambda$forceFullHearts$13(PlayerEntity player, VillagerEntityMCA v) {
        v.getVillagerBrain().getMemoriesForPlayer(player).setHearts(1000);
    }

    private static /* synthetic */ void lambda$incrementHearts$11(PlayerEntity player, VillagerEntityMCA v) {
        v.getVillagerBrain().getMemoriesForPlayer(player).modHearts(10);
    }

    private static /* synthetic */ void lambda$decrementHearts$10(PlayerEntity player, VillagerEntityMCA v) {
        v.getVillagerBrain().getMemoriesForPlayer(player).modHearts(-10);
    }

    private static /* synthetic */ Optional lambda$setBuildingType$8(PlayerEntity e, Village v) {
        return v.getBuildings().values().stream().filter(b -> b.containsPos((Vector3i)e.func_233580_cy_())).findAny();
    }
}

