/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forge.net.mca.Config;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.s2c.OpenGuiRequest;
import forge.net.mca.server.ServerInteractionManager;
import forge.net.mca.server.world.data.PlayerSaveData;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class Command {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mca").then(Command.register("help", (com.mojang.brigadier.Command<CommandSource>)((com.mojang.brigadier.Command)Command::displayHelp)))).then(Command.register("propose").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(Command::propose)))).then(Command.register("accept").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(Command::accept)))).then(Command.register("proposals", (com.mojang.brigadier.Command<CommandSource>)((com.mojang.brigadier.Command)Command::displayProposal)))).then(Command.register("procreate", (com.mojang.brigadier.Command<CommandSource>)((com.mojang.brigadier.Command)Command::procreate)))).then(Command.register("separate", (com.mojang.brigadier.Command<CommandSource>)((com.mojang.brigadier.Command)Command::separate)))).then(Command.register("reject").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(Command::reject)))).then(Command.register("editor", (com.mojang.brigadier.Command<CommandSource>)((com.mojang.brigadier.Command)Command::editor)))).then(Command.register("destiny", (com.mojang.brigadier.Command<CommandSource>)((com.mojang.brigadier.Command)Command::destiny)))).then(Command.register("mail", (com.mojang.brigadier.Command<CommandSource>)((com.mojang.brigadier.Command)Command::mail))));
    }

    private static int editor(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if (((CommandSource)ctx.getSource()).func_197034_c(2) || Config.getInstance().allowFullPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.VILLAGER_EDITOR, (Entity)((CommandSource)ctx.getSource()).func_197035_h()), ((CommandSource)ctx.getSource()).func_197035_h());
            return 0;
        }
        if (Config.getInstance().allowLimitedPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.LIMITED_VILLAGER_EDITOR, (Entity)((CommandSource)ctx.getSource()).func_197035_h()), ((CommandSource)ctx.getSource()).func_197035_h());
            return 0;
        }
        ((CommandSource)ctx.getSource()).func_197035_h().func_145747_a((ITextComponent)new TranslationTextComponent("command.no_permission").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        return 1;
    }

    private static int destiny(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        if (((CommandSource)ctx.getSource()).func_197034_c(2) || Config.getInstance().allowDestinyCommandOnce) {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            if (!PlayerSaveData.get(player).isEntityDataSet() || Config.getInstance().allowDestinyCommandMoreThanOnce) {
                ServerInteractionManager.launchDestiny(player);
                return 0;
            }
            ((CommandSource)ctx.getSource()).func_197035_h().func_145747_a((ITextComponent)new TranslationTextComponent("command.only_one_destiny").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return 1;
        }
        ((CommandSource)ctx.getSource()).func_197035_h().func_145747_a((ITextComponent)new TranslationTextComponent("command.no_permission").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        return 1;
    }

    private static int mail(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        PlayerSaveData data = PlayerSaveData.get(player);
        if (data.hasMail()) {
            while (data.hasMail()) {
                player.field_71071_by.func_191975_a(player.field_70170_p, data.getMail());
            }
        } else {
            ((CommandSource)ctx.getSource()).func_197035_h().func_145747_a((ITextComponent)new TranslationTextComponent("command.no_mail"), Util.field_240973_b_);
        }
        return 0;
    }

    private static int displayHelp(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.DARK_RED + "--- " + TextFormatting.GOLD + "PLAYER COMMANDS" + TextFormatting.DARK_RED + " ---");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca editor" + TextFormatting.GOLD + " - Choose your genetics and stuff.");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca propose <PlayerName>" + TextFormatting.GOLD + " - Proposes marriage to the given player.");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca proposals " + TextFormatting.GOLD + " - Shows all active proposals.");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca accept <PlayerName>" + TextFormatting.GOLD + " - Accepts the player's marriage request.");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca reject <PlayerName>" + TextFormatting.GOLD + " - Rejects the player's marriage request.");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca procreate " + TextFormatting.GOLD + " - Starts procreation.");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca separate " + TextFormatting.GOLD + " - Ends your marriage.");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.DARK_RED + "--- " + TextFormatting.GOLD + "GLOBAL COMMANDS" + TextFormatting.DARK_RED + " ---");
        Command.sendMessage((Entity)((CommandSource)ctx.getSource()).func_197035_h(), TextFormatting.WHITE + " /mca help " + TextFormatting.GOLD + " - Shows this list of commands.");
        return 0;
    }

    private static int propose(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"target");
        ServerInteractionManager.getInstance().sendProposal(((CommandSource)ctx.getSource()).func_197035_h(), target);
        return 0;
    }

    private static int accept(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"target");
        ServerInteractionManager.getInstance().acceptProposal(((CommandSource)ctx.getSource()).func_197035_h(), target);
        return 0;
    }

    private static int displayProposal(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().listProposals(((CommandSource)ctx.getSource()).func_197035_h());
        return 0;
    }

    private static int procreate(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().procreate(((CommandSource)ctx.getSource()).func_197035_h());
        return 0;
    }

    private static int separate(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().endMarriage(((CommandSource)ctx.getSource()).func_197035_h());
        return 0;
    }

    private static int reject(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity target = EntityArgument.func_197089_d(ctx, (String)"target");
        ServerInteractionManager.getInstance().rejectProposal(((CommandSource)ctx.getSource()).func_197035_h(), target);
        return 0;
    }

    private static ArgumentBuilder<CommandSource, ?> register(String name, com.mojang.brigadier.Command<CommandSource> cmd) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)name).requires(cs -> cs.func_197034_c(0))).executes(cmd);
    }

    private static ArgumentBuilder<CommandSource, ?> register(String name) {
        return Commands.func_197057_a((String)name).requires(cs -> cs.func_197034_c(0));
    }

    private static void sendMessage(Entity commandSender, String message) {
        commandSender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "[MCA] " + TextFormatting.RESET + message), Util.field_240973_b_);
    }
}

