/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.item.BabyItem;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.NbtHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class BabyBunker {
    private final Map<UUID, List<ItemStack>> limbo;
    private final VillageManager manager;

    BabyBunker(VillageManager manager) {
        this.manager = manager;
        this.limbo = new HashMap<UUID, List<ItemStack>>();
    }

    BabyBunker(VillageManager manager, CompoundNBT nbt) {
        this.manager = manager;
        this.limbo = NbtHelper.toMap(nbt, UUID::fromString, element -> NbtHelper.toList(element, i -> ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)i))));
    }

    public CompoundNBT writeNbt(CompoundNBT nbt) {
        return NbtHelper.fromMap(nbt, this.limbo, UUID::toString, stacks -> NbtHelper.fromList(stacks, stack -> stack.func_77955_b(new CompoundNBT())));
    }

    public void pop(PlayerEntity player) {
        List<ItemStack> baby = this.limbo.remove(player.func_110124_au());
        if (baby != null) {
            baby.forEach(bab -> {
                if (!player.func_191521_c(bab)) {
                    player.func_70099_a(bab, 0.0f);
                }
            });
            this.manager.markDirty();
        }
    }

    public void push(PlayerEntity player) {
        List babies = player.field_71071_by.field_70462_a.stream().filter(s -> s.func_77973_b() instanceof BabyItem).collect(Collectors.toList());
        if (!babies.isEmpty()) {
            this.limbo.put(player.func_110124_au(), babies);
            this.manager.markDirty();
        }
    }
}

