/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.item.ItemsMCA;
import forge.net.mca.util.InventoryUtils;
import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.PersistentStateCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class BabyTracker
extends PersistentStateCompat {
    private final Map<Key, Pairing> pairings = new HashMap<Key, Pairing>();

    public static BabyTracker get(ServerWorld world) {
        return WorldUtils.loadData(world.func_73046_m().func_241755_D_(), nbt -> new BabyTracker(world, (CompoundNBT)nbt), BabyTracker::new, "mca_baby_tracker");
    }

    BabyTracker(ServerWorld world) {
    }

    BabyTracker(ServerWorld world, CompoundNBT nbt) {
        nbt.func_150295_c("pairings", 10).forEach(element -> {
            Pairing pairing = new Pairing((CompoundNBT)element);
            this.pairings.put(pairing.key, pairing);
        });
    }

    public Optional<MutableChildSaveState> getSaveState(UUID id) {
        return this.pairings.values().stream().flatMap(pairing -> ((Pairing)pairing).children.stream().filter(s -> s.id.equals(id))).findFirst();
    }

    public boolean hasActiveBaby(UUID mother, UUID father) {
        return false;
    }

    public Pairing getPairing(UUID mother, UUID father) {
        return this.getPairing(new Key(mother, father));
    }

    public Optional<Pairing> getPairingOrEmpty(UUID mother, UUID father) {
        return Optional.ofNullable(this.pairings.get(new Key(mother, father)));
    }

    public Pairing getPairing(ChildSaveState state) {
        return this.getPairing(state.key);
    }

    private Pairing getPairing(Key key) {
        return this.pairings.computeIfAbsent(key, x$0 -> new Pairing((Key)x$0));
    }

    @Override
    public CompoundNBT writeNbt(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        this.pairings.values().forEach(pairing -> list.add((Object)pairing.toNbt()));
        nbt.func_218657_a("pairings", (INBT)list);
        return nbt;
    }

    public static Optional<MutableChildSaveState> getState(ItemStack stack, ServerWorld world) {
        if (!BabyTracker.hasState(stack)) {
            return Optional.empty();
        }
        ChildSaveState state = new ChildSaveState(stack.func_179543_a("childData"));
        return BabyTracker.get(world).getPairing(state).children.stream().filter(s -> s.id.equals(state.id)).findAny();
    }

    public static Optional<ChildSaveState> getState(ItemStack stack) {
        return BabyTracker.hasState(stack) ? Optional.of(new ChildSaveState(stack.func_179543_a("childData"))) : Optional.empty();
    }

    public static Optional<UUID> getStateId(ItemStack stack) {
        return BabyTracker.hasState(stack) ? Optional.of(stack.func_179543_a("childData").func_186857_a("id")) : Optional.empty();
    }

    public static boolean hasState(ItemStack stack) {
        return stack.func_77942_o() && !stack.func_77978_p().func_74767_n("invalidated") && stack.func_77978_p().func_150297_b("childData", 10) && stack.func_179543_a("childData").func_186855_b("id");
    }

    public static void invalidate(ItemStack stack) {
        stack.func_196083_e("childData");
        stack.func_196082_o().func_74757_a("invalidated", true);
    }

    private static class Key
    implements Comparable<Key> {
        private final Set<UUID> parents = new HashSet<UUID>();

        public Key(UUID mother, UUID father) {
            this.parents.add(mother);
            this.parents.add(father);
        }

        public Key(ListNBT nbt) {
            nbt.forEach(i -> this.parents.add(UUID.fromString(i.func_150285_a_())));
        }

        public ListNBT toNbt() {
            ListNBT nbt = new ListNBT();
            this.parents.forEach(parent -> nbt.add((Object)StringNBT.func_229705_a_((String)parent.toString())));
            return nbt;
        }

        @Override
        public int compareTo(Key o) {
            return this.equals(o) ? 0 : 1;
        }

        private boolean equals(Key o) {
            return o != null && o.parents.equals(this.parents);
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.equals((Key)o);
        }

        public int hashCode() {
            return this.parents.hashCode();
        }
    }

    public final class Pairing {
        private final Key key;
        private final List<MutableChildSaveState> children;

        public Pairing(Key key) {
            this.key = key;
            this.children = new ArrayList<MutableChildSaveState>();
            BabyTracker.this.markDirty();
        }

        public Pairing(CompoundNBT tag) {
            this.key = new Key(tag.func_150295_c("key", 8));
            this.children = NbtHelper.toList((INBT)tag.func_150295_c("children", 10), c -> new MutableChildSaveState((CompoundNBT)c));
        }

        public int getChildCount() {
            return this.children.size();
        }

        public void addChild(Consumer<MutableChildSaveState> factory) {
            MutableChildSaveState state = new MutableChildSaveState(this.key);
            factory.accept(state);
            this.children.add(state);
            BabyTracker.this.markDirty();
        }

        public void removeChild(ChildSaveState state) {
            this.children.removeIf(o -> o.id.equals(state.id));
        }

        public List<ChildSaveState> getChildren() {
            return new ArrayList<ChildSaveState>(this.children);
        }

        public Pair<ItemStack, Placement> locateBaby(PlayerEntity player) {
            int slot = InventoryUtils.getFirstSlotContainingItem((IInventory)player.field_71071_by, stack -> BabyTracker.getState(stack).filter(state -> ((ChildSaveState)state).key.equals(this.key)).isPresent());
            if (slot >= 0) {
                return Pair.of((Object)player.field_71071_by.func_70301_a(slot), (Object)((Object)Placement.INVENTORY));
            }
            slot = InventoryUtils.getFirstSlotContainingItem((IInventory)player.func_71005_bN(), stack -> BabyTracker.getState(stack).filter(state -> ((ChildSaveState)state).key.equals(this.key)).isPresent());
            if (slot >= 0) {
                return Pair.of((Object)player.func_71005_bN().func_70301_a(slot), (Object)((Object)Placement.ENDER_CHEST));
            }
            return Pair.of((Object)ItemStack.field_190927_a, (Object)((Object)Placement.MISSING));
        }

        public CompoundNBT toNbt() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("key", (INBT)this.key.toNbt());
            tag.func_218657_a("children", (INBT)NbtHelper.fromList(this.children, child -> child.writeToNbt(new CompoundNBT())));
            return tag;
        }

        public void reconstructBaby(ServerPlayerEntity player) {
            this.getChildren().forEach(c -> {
                ItemStack stack = new ItemStack(c.getGender() == Gender.MALE ? (IItemProvider)ItemsMCA.BABY_BOY.get() : (IItemProvider)ItemsMCA.BABY_GIRL.get());
                c.writeToNbt(stack.func_190925_c("childData"));
                player.field_71071_by.func_70441_a(stack);
            });
        }
    }

    public static class ChildSaveState {
        final UUID id;
        protected Gender gender;
        protected boolean infected;
        protected long seed;
        protected Optional<String> name = Optional.empty();
        private final Key key;
        protected Optional<Pair<UUID, String>> owner = Optional.empty();

        ChildSaveState(Key key) {
            this.id = UUID.randomUUID();
            this.key = key;
        }

        public ChildSaveState(CompoundNBT tag) {
            this.id = tag.func_186857_a("id");
            this.gender = Gender.byName(tag.func_74779_i("gender"));
            this.infected = tag.func_74767_n("infected");
            this.name = tag.func_74764_b("name") ? Optional.of(tag.func_74779_i("name")) : Optional.empty();
            this.seed = tag.func_74763_f("seed");
            this.key = new Key(tag.func_150295_c("key", 8));
        }

        public UUID getId() {
            return this.id;
        }

        public Stream<UUID> getParents() {
            return this.key.parents.stream();
        }

        public boolean isInfected() {
            return this.infected;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<Pair<UUID, String>> getOwner() {
            return this.owner;
        }

        public long getSeed() {
            return this.seed;
        }

        public Gender getGender() {
            return this.gender;
        }

        public CompoundNBT writeToNbt(CompoundNBT tag) {
            tag.func_186854_a("id", this.id);
            tag.func_74778_a("gender", this.gender.getStrName());
            tag.func_74757_a("infected", this.infected);
            tag.func_218657_a("key", (INBT)this.key.toNbt());
            tag.func_74772_a("seed", this.seed);
            this.name.ifPresent(n -> tag.func_74778_a("name", n));
            return tag;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        private boolean equals(ChildSaveState o) {
            return o == this || o != null && o.id.equals(this.id);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ChildSaveState && this.equals((ChildSaveState)o);
        }
    }

    public class MutableChildSaveState
    extends ChildSaveState {
        MutableChildSaveState(Key key) {
            super(key);
        }

        public MutableChildSaveState(CompoundNBT tag) {
            super(tag);
        }

        public MutableChildSaveState setGender(Gender gender) {
            this.gender = gender;
            BabyTracker.this.markDirty();
            return this;
        }

        public MutableChildSaveState setInfected(boolean infected) {
            this.infected = infected;
            BabyTracker.this.markDirty();
            return this;
        }

        public MutableChildSaveState setName(String name) {
            this.name = Optional.ofNullable(name);
            BabyTracker.this.markDirty();
            return this;
        }

        public MutableChildSaveState setOwner(Entity entity) {
            this.owner = Optional.of(Pair.of((Object)entity.func_110124_au(), (Object)entity.func_200200_C_().getString()));
            BabyTracker.this.markDirty();
            return this;
        }

        public MutableChildSaveState setSeed(long seed) {
            this.seed = seed;
            BabyTracker.this.markDirty();
            return this;
        }

        public ItemStack createItem() {
            return this.writeToItem(((Item)(this.gender.binary() == Gender.MALE ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL).get()).func_190903_i());
        }

        public ItemStack writeToItem(ItemStack stack) {
            this.writeToNbt(stack.func_190925_c("childData"));
            return stack;
        }
    }

    public static enum Placement {
        INVENTORY,
        ENDER_CHEST,
        MISSING;


        public boolean wasFound() {
            return this != MISSING;
        }
    }
}

