/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.Config;
import forge.net.mca.resources.API;
import forge.net.mca.resources.data.BuildingType;
import forge.net.mca.util.NbtHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Building
implements Serializable,
Iterable<UUID> {
    private static final long serialVersionUID = -1106627083469687307L;
    public static final long SCAN_COOLDOWN = 4800L;
    private static final Direction[] directions = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final Map<UUID, String> residents = new HashMap<UUID, String>();
    private final Map<ResourceLocation, List<BlockPos>> blocks = new HashMap<ResourceLocation, List<BlockPos>>();
    private String type = "building";
    private String forcedType = null;
    private int size;
    private int pos0X;
    private int pos0Y;
    private int pos0Z;
    private int pos1X;
    private int pos1Y;
    private int pos1Z;
    private int posX;
    private int posY;
    private int posZ;
    private int id;
    private boolean strictScan;
    private long lastScan;

    public Building() {
    }

    public Building(BlockPos pos) {
        this(pos, false);
    }

    public Building(BlockPos pos, boolean strictScan) {
        this();
        this.pos0X = pos.func_177958_n();
        this.pos0Y = pos.func_177956_o();
        this.pos0Z = pos.func_177952_p();
        this.pos1X = this.pos0X;
        this.pos1Y = this.pos0Y;
        this.pos1Z = this.pos0Z;
        this.posX = this.pos0X;
        this.posY = this.pos0Y;
        this.posZ = this.pos0Z;
        this.strictScan = strictScan;
    }

    public Building(CompoundNBT v) {
        this.id = v.func_74762_e("id");
        this.size = v.func_74762_e("size");
        this.pos0X = v.func_74762_e("pos0X");
        this.pos0Y = v.func_74762_e("pos0Y");
        this.pos0Z = v.func_74762_e("pos0Z");
        this.pos1X = v.func_74762_e("pos1X");
        this.pos1Y = v.func_74762_e("pos1Y");
        this.pos1Z = v.func_74762_e("pos1Z");
        if (v.func_74764_b("posX")) {
            this.posX = v.func_74762_e("posX");
            this.posY = v.func_74762_e("posY");
            this.posZ = v.func_74762_e("posZ");
        } else {
            BlockPos center = this.getCenter();
            this.posX = center.func_177958_n();
            this.posY = center.func_177956_o();
            this.posZ = center.func_177952_p();
        }
        this.forcedType = v.func_74764_b("forced_type") ? v.func_74779_i("forced_type") : null;
        this.type = this.forcedType != null ? this.forcedType : v.func_74779_i("type");
        this.strictScan = v.func_74767_n("strictScan");
        ListNBT res = v.func_150295_c("residents", 10);
        for (int i = 0; i < res.size(); ++i) {
            CompoundNBT c = res.func_150305_b(i);
            this.residents.put(c.func_186857_a("uuid"), c.func_74779_i("name"));
        }
        this.blocks.putAll(NbtHelper.toMap(v.func_74775_l("blocks2"), ResourceLocation::new, l -> NbtHelper.toList(l, e -> {
            CompoundNBT c = (CompoundNBT)e;
            return new BlockPos(c.func_74762_e("x"), c.func_74762_e("y"), c.func_74762_e("z"));
        })));
    }

    public CompoundNBT save() {
        CompoundNBT v = new CompoundNBT();
        v.func_74768_a("id", this.id);
        v.func_74768_a("size", this.size);
        v.func_74768_a("pos0X", this.pos0X);
        v.func_74768_a("pos0Y", this.pos0Y);
        v.func_74768_a("pos0Z", this.pos0Z);
        v.func_74768_a("pos1X", this.pos1X);
        v.func_74768_a("pos1Y", this.pos1Y);
        v.func_74768_a("pos1Z", this.pos1Z);
        v.func_74768_a("posX", this.posX);
        v.func_74768_a("posY", this.posY);
        v.func_74768_a("posZ", this.posZ);
        if (this.forcedType != null) {
            v.func_74778_a("forced_type", this.forcedType);
        }
        v.func_74778_a("type", this.type);
        v.func_74757_a("strictScan", this.strictScan);
        v.func_218657_a("residents", (INBT)NbtHelper.fromList(this.residents.entrySet(), resident -> {
            CompoundNBT entry = new CompoundNBT();
            entry.func_186854_a("uuid", (UUID)resident.getKey());
            entry.func_74778_a("name", (String)resident.getValue());
            return entry;
        }));
        CompoundNBT b = new CompoundNBT();
        NbtHelper.fromMap(b, this.blocks, ResourceLocation::toString, e -> NbtHelper.fromList(e, p -> {
            CompoundNBT entry = new CompoundNBT();
            entry.func_74768_a("x", p.func_177958_n());
            entry.func_74768_a("y", p.func_177956_o());
            entry.func_74768_a("z", p.func_177952_p());
            return entry;
        }));
        v.func_218657_a("blocks2", (INBT)b);
        return v;
    }

    public boolean hasFreeSpace() {
        return this.getBedCount() > this.getResidents().size();
    }

    public boolean isCrowded() {
        return this.getBedCount() < this.getResidents().size();
    }

    public Stream<BlockPos> findEmptyBed(ServerWorld world) {
        return world.func_217443_B().func_226353_b_(PointOfInterestType.field_221069_q.func_221045_c(), this.getCenter(), this.getPos0().func_218139_n((Vector3i)this.getPos1()), PointOfInterestManager.Status.ANY).filter(p -> {
            BlockState blockState = world.func_180495_p(p.func_218261_f());
            return blockState.func_235714_a_((ITag)BlockTags.field_219747_F) && (Boolean)blockState.func_177229_b((Property)BedBlock.field_176471_b) == false;
        }).map(PointOfInterest::func_218261_f).filter(this::containsPos);
    }

    public Optional<BlockPos> findClosestEmptyBed(ServerWorld world, BlockPos pos) {
        return this.findEmptyBed(world).min(Comparator.comparingInt(a -> a.func_218139_n((Vector3i)pos)));
    }

    public void addResident(Entity e) {
        if (!this.residents.containsKey(e.func_110124_au())) {
            this.residents.put(e.func_110124_au(), e.func_200200_C_().getString());
        }
    }

    public void updateResident(Entity e) {
        if (this.residents.containsKey(e.func_110124_au())) {
            this.residents.put(e.func_110124_au(), e.func_200200_C_().getString());
        }
    }

    public BlockPos getPos0() {
        return new BlockPos(this.pos0X, this.pos0Y, this.pos0Z);
    }

    public BlockPos getPos1() {
        return new BlockPos(this.pos1X, this.pos1Y, this.pos1Z);
    }

    public BlockPos getCenter() {
        return new BlockPos((this.pos0X + this.pos1X) / 2, (this.pos0Y + this.pos1Y) / 2, (this.pos0Z + this.pos1Z) / 2);
    }

    public BlockPos getSourceBlock() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public void validateBlocks(World world) {
        this.setLastScan(world.func_82737_E());
        for (Map.Entry<ResourceLocation, List<BlockPos>> positions : this.blocks.entrySet()) {
            List mask = positions.getValue().stream().filter(p -> !Registry.field_212618_g.func_177774_c((Object)world.func_180495_p(p).func_177230_c()).equals(positions.getKey())).collect(Collectors.toList());
            positions.getValue().removeAll(mask);
        }
    }

    public Stream<BlockPos> getBlockPosStream() {
        return this.blocks.values().stream().flatMap(Collection::stream);
    }

    public void addPOI(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        this.removeBlock(block, pos);
        this.addBlock(block, pos);
        this.validateBlocks(world);
        int n = (int)this.getBlockPosStream().count();
        if (n > 0) {
            BlockPos center = this.getBlockPosStream().reduce(BlockPos.field_177992_a, BlockPos::func_177971_a);
            this.pos0X = center.func_177958_n() / n;
            this.pos0Y = center.func_177956_o() / n;
            this.pos0Z = center.func_177952_p() / n;
            this.pos1X = this.pos0X;
            this.pos1Y = this.pos0Y;
            this.pos1Z = this.pos0Z;
        }
    }

    public validationResult validateBuilding(World world, Set<BlockPos> blocked) {
        BlockState block;
        this.blocks.clear();
        this.size = 0;
        this.setLastScan(world.func_82737_E());
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        BlockPos center = this.getSourceBlock();
        queue.add(center);
        done.add(center);
        int minSize = Config.getInstance().minBuildingSize;
        int maxSize = Config.getInstance().maxBuildingSize;
        int maxRadius = Config.getInstance().maxBuildingRadius;
        int interiorSize = 0;
        boolean hasDoor = false;
        HashMap<BlockPos, Boolean> roofCache = new HashMap<BlockPos, Boolean>();
        for (int scanSize = 0; !queue.isEmpty() && scanSize < maxSize; ++scanSize) {
            BlockPos p = (BlockPos)queue.removeLast();
            if (blocked.contains(p) && scanSize > 0) {
                return validationResult.OVERLAP;
            }
            if (p.func_218139_n((Vector3i)center) < maxRadius) {
                for (Direction d : directions) {
                    BlockPos n = p.func_177972_a(d);
                    if (done.contains(n)) continue;
                    BlockState state = world.func_180495_p(n);
                    done.add(n);
                    if (state.func_196958_f()) {
                        if (!roofCache.containsKey(n)) {
                            BlockPos n2 = n;
                            int maxScanHeight = 16;
                            for (int i = 0; i < maxScanHeight; ++i) {
                                roofCache.put(n2, false);
                                n2 = n2.func_177984_a();
                                block = world.func_180495_p(n2);
                                if (block.func_196958_f() && !roofCache.containsKey(n2)) continue;
                                if (roofCache.containsKey(n2) && !((Boolean)roofCache.get(n2)).booleanValue() || block.func_235714_a_((ITag)BlockTags.field_206952_E)) break;
                                for (int i2 = i; i2 >= 0; --i2) {
                                    n2 = n2.func_177977_b();
                                    roofCache.put(n2, true);
                                }
                                break;
                            }
                        }
                        if (!((Boolean)roofCache.get(n)).booleanValue()) continue;
                        ++interiorSize;
                        queue.add(n);
                        continue;
                    }
                    if (!(state.func_177230_c() instanceof DoorBlock)) continue;
                    if (!this.strictScan) {
                        queue.add(n);
                    }
                    hasDoor = true;
                }
                continue;
            }
            return validationResult.SIZE_LIMIT;
        }
        if (!queue.isEmpty()) {
            return validationResult.BLOCK_LIMIT;
        }
        if (done.size() <= minSize) {
            return validationResult.TOO_SMALL;
        }
        if (!hasDoor) {
            return validationResult.NO_DOOR;
        }
        HashSet<ResourceLocation> blockTypes = new HashSet<ResourceLocation>();
        for (BuildingType bt : API.getVillagePool()) {
            blockTypes.addAll(bt.getBlockToGroup().keySet());
        }
        int sx = center.func_177958_n();
        int sy = center.func_177956_o();
        int sz = center.func_177952_p();
        int ex = sx;
        int ey = sy;
        int ez = sz;
        for (BlockPos p : done) {
            sx = Math.min(sx, p.func_177958_n());
            sy = Math.min(sy, p.func_177956_o());
            sz = Math.min(sz, p.func_177952_p());
            ex = Math.max(ex, p.func_177958_n());
            ey = Math.max(ey, p.func_177956_o());
            ez = Math.max(ez, p.func_177952_p());
            BlockState blockState = world.func_180495_p(p);
            block = blockState.func_177230_c();
            if (!blockTypes.contains(Registry.field_212618_g.func_177774_c((Object)block))) continue;
            if (block instanceof BedBlock) {
                if (blockState.func_177229_b((Property)BedBlock.field_176472_a) != BedPart.HEAD) continue;
                this.addBlock((Block)block, p);
                continue;
            }
            this.addBlock((Block)block, p);
        }
        this.pos0X = sx;
        this.pos0Y = sy;
        this.pos0Z = sz;
        this.pos1X = ex;
        this.pos1Y = ey;
        this.pos1Z = ez;
        this.size = interiorSize;
        boolean assignedType = false;
        if (!this.type.equals("blocked")) {
            assignedType = this.determineType();
        }
        return assignedType ? validationResult.SUCCESS : validationResult.INVALID_TYPE;
    }

    public boolean determineType() {
        int bestPriority = -1;
        boolean assignedType = false;
        for (BuildingType bt : API.getVillagePool()) {
            boolean checkingForcedType;
            boolean bl = checkingForcedType = this.forcedType != null && this.forcedType.equalsIgnoreCase(bt.name());
            if (!checkingForcedType && bt.priority() <= bestPriority || this.size < bt.size()) continue;
            Map<ResourceLocation, List<BlockPos>> available = bt.getGroups(this.blocks);
            boolean valid = bt.getGroups().entrySet().stream().noneMatch(e -> !available.containsKey(e.getKey()) || ((List)available.get(e.getKey())).size() < (Integer)e.getValue());
            if (valid) {
                bestPriority = bt.priority();
                this.type = bt.name();
                assignedType = true;
                if (!checkingForcedType) continue;
                break;
            }
            if (!checkingForcedType) continue;
            assignedType = false;
        }
        return assignedType;
    }

    public String getType() {
        return this.type;
    }

    public String getForcedType() {
        return this.forcedType;
    }

    public BuildingType getBuildingType() {
        return API.getVillagePool().getBuildingType(this.type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setForcedType(String type) {
        this.forcedType = type;
    }

    public Map<UUID, String> getResidents() {
        return this.residents;
    }

    @Override
    public Iterator<UUID> iterator() {
        return this.residents.keySet().iterator();
    }

    public boolean hasResident(UUID id) {
        return this.residents.containsKey(id);
    }

    public Map<ResourceLocation, List<BlockPos>> getBlocks() {
        return this.blocks;
    }

    public void addBlock(Block block, BlockPos p) {
        ResourceLocation key = Registry.field_212618_g.func_177774_c((Object)block);
        if (!this.blocks.containsKey(key)) {
            this.blocks.put(key, new ArrayList());
        }
        this.blocks.get(key).add(p);
    }

    public void removeBlock(Block block, BlockPos p) {
        ResourceLocation key = Registry.field_212618_g.func_177774_c((Object)block);
        if (this.blocks.containsKey(key)) {
            this.blocks.get(key).remove(p);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean overlaps(Building b) {
        return this.pos1X > b.pos0X && this.pos0X < b.pos1X && this.pos1Y > b.pos0Y && this.pos0Y < b.pos1Y && this.pos1Z > b.pos0Z && this.pos0Z < b.pos1Z;
    }

    public boolean containsPos(Vector3i pos) {
        return pos.func_177958_n() >= this.pos0X && pos.func_177958_n() <= this.pos1X && pos.func_177956_o() >= this.pos0Y && pos.func_177956_o() <= this.pos1Y && pos.func_177952_p() >= this.pos0Z && pos.func_177952_p() <= this.pos1Z;
    }

    public boolean isIdentical(Building b) {
        return this.pos0X == b.pos0X && this.pos1X == b.pos1X && this.pos0Y == b.pos0Y && this.pos1Y == b.pos1Y && this.pos0Z == b.pos0Z && this.pos1Z == b.pos1Z;
    }

    public int getBedCount() {
        return this.getBlocksOfGroup(new ResourceLocation("minecraft:beds")).size();
    }

    @Deprecated
    public List<BlockPos> getBlocksOfGroup(ResourceLocation i) {
        Map<ResourceLocation, List<BlockPos>> groups = API.getVillagePool().getBuildingType("?").getGroups(this.blocks);
        return groups.getOrDefault(i, new ArrayList());
    }

    public int getSize() {
        return this.size;
    }

    public long getLastScan() {
        return this.lastScan;
    }

    public void setLastScan(long lastScan) {
        this.lastScan = lastScan;
    }

    public static enum validationResult {
        OVERLAP,
        BLOCK_LIMIT,
        SIZE_LIMIT,
        NO_DOOR,
        TOO_SMALL,
        IDENTICAL,
        SUCCESS,
        INVALID_TYPE;

    }
}

