/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.OptionalCompat;
import forge.net.mca.util.compat.PersistentStateCompat;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongFunction;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public class GraveyardManager
extends PersistentStateCompat {
    private final Map<TombstoneState, Long2ObjectMap<ChunkBase>> tombstones = new EnumMap<TombstoneState, Long2ObjectMap<ChunkBase>>(TombstoneState.class);

    public static GraveyardManager get(ServerWorld world) {
        return WorldUtils.loadData(world, GraveyardManager::new, GraveyardManager::new, "mca_graveyard");
    }

    public GraveyardManager(ServerWorld world) {
    }

    public GraveyardManager(CompoundNBT nbt) {
        this.tombstones.putAll(NbtHelper.toMap(nbt, TombstoneState::valueOf, v -> {
            CompoundNBT vv = (CompoundNBT)v;
            Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
            vv.func_150296_c().forEach(arg_0 -> GraveyardManager.lambda$new$0((Long2ObjectMap)map, vv, arg_0));
            return map;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundNBT writeNbt(CompoundNBT nbt) {
        CompoundNBT tag = new CompoundNBT();
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            this.tombstones.forEach((state, chunks) -> {
                CompoundNBT chunkList = new CompoundNBT();
                chunks.long2ObjectEntrySet().forEach(entry -> {
                    if (!((ChunkBase)entry.getValue()).isEmpty()) {
                        chunkList.func_218657_a(String.valueOf(entry.getLongKey()), (INBT)((ChunkBase)entry.getValue()).toNbt());
                    }
                });
                if (!chunkList.isEmpty()) {
                    tag.func_218657_a(state.name(), (INBT)chunkList);
                }
            });
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTombstoneState(BlockPos pos, TombstoneState state) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(state.opposite(), l, ChunkBase::empty).removePos(pos);
            this.getChunk(state, l, Chunk::new).addPos(pos);
            this.markDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTombstoneState(BlockPos pos) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).removePos(pos);
            this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).removePos(pos);
            this.markDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockPos> findAll(AxisAlignedBB box, boolean includeEmpty, boolean includeFilled) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (includeEmpty || includeFilled) {
            int minX = MathHelper.func_76128_c((double)((box.field_72340_a - 2.0) / 16.0));
            int maxX = MathHelper.func_76143_f((double)((box.field_72336_d + 2.0) / 16.0));
            int minZ = MathHelper.func_76128_c((double)((box.field_72339_c - 2.0) / 16.0));
            int maxZ = MathHelper.func_76143_f((double)((box.field_72334_f + 2.0) / 16.0));
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
            synchronized (map) {
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        long l = ChunkPos.func_77272_a((int)x, (int)z);
                        if (includeEmpty) {
                            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).appendAll(box, mutable, positions);
                        }
                        if (!includeFilled) continue;
                        this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).appendAll(box, mutable, positions);
                    }
                }
            }
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BlockPos> findNearest(BlockPos pos, TombstoneState state, int maxChunkRange) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            return OptionalCompat.or(this.getChunk(state, GraveyardManager.getChunkPos(pos), ChunkBase::empty).findNearest(pos, mutable), () -> {
                BlockPos center = new BlockPos(SectionPos.func_218159_a((int)pos.func_177958_n()), 0, SectionPos.func_218159_a((int)pos.func_177952_p()));
                return BlockPos.func_239588_b_((BlockPos)center, (int)maxChunkRange, (int)0, (int)maxChunkRange).map(p -> ChunkPos.func_77272_a((int)p.func_177958_n(), (int)p.func_177952_p())).map(l -> this.getChunk(state, (long)l, ChunkBase::empty).findNearest(pos, mutable)).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(a -> a.func_177951_i((Vector3i)pos)));
            });
        }
    }

    private static long getChunkPos(BlockPos pos) {
        return ChunkPos.func_77272_a((int)SectionPos.func_218159_a((int)pos.func_177958_n()), (int)SectionPos.func_218159_a((int)pos.func_177952_p()));
    }

    private ChunkBase getChunk(TombstoneState state, long pos, LongFunction<ChunkBase> fallback) {
        Long2ObjectMap chunks = this.tombstones.computeIfAbsent(state, n -> new Long2ObjectOpenHashMap());
        ChunkBase chunk = (ChunkBase)chunks.get(pos);
        if (chunk == null && (chunk = fallback.apply(pos)) != ChunkBase.EMPTY) {
            chunks.put(pos, (Object)chunk);
        }
        return chunk;
    }

    public void reportToVillageManager(Entity entity) {
        VillageManager manager = VillageManager.get((ServerWorld)entity.field_70170_p);
        GraveyardManager.get((ServerWorld)entity.field_70170_p).findAll(entity.func_174813_aQ().func_186662_g(24.0), true, true).stream().filter(p -> !manager.cache.contains(p)).forEach(manager::processBuilding);
    }

    private static /* synthetic */ void lambda$new$0(Long2ObjectMap map, CompoundNBT vv, String key) {
        map.put(Long.parseLong(key), (Object)new Chunk((ListNBT)vv.func_74781_a(key)));
    }

    public static enum TombstoneState {
        EMPTY,
        FILLED;


        TombstoneState opposite() {
            return this == EMPTY ? FILLED : EMPTY;
        }
    }

    private static class ChunkBase {
        static final ChunkBase EMPTY = new ChunkBase();

        private ChunkBase() {
        }

        static ChunkBase empty(long l) {
            return EMPTY;
        }

        public boolean isEmpty() {
            return true;
        }

        public ListNBT toNbt() {
            return new ListNBT();
        }

        public void removePos(BlockPos pos) {
        }

        public void addPos(BlockPos pos) {
        }

        public Optional<BlockPos> findNearest(BlockPos pos, BlockPos.Mutable mutable) {
            return Optional.empty();
        }

        public void appendAll(AxisAlignedBB box, BlockPos.Mutable mutable, List<BlockPos> positions) {
        }
    }

    private static class Chunk
    extends ChunkBase {
        private final LongSet tombstones = new LongArraySet();

        Chunk(long l) {
        }

        Chunk(ListNBT list) {
            list.forEach(l -> this.tombstones.add(((NumberNBT)l).func_150291_c()));
        }

        @Override
        public boolean isEmpty() {
            return this.tombstones.isEmpty();
        }

        @Override
        public ListNBT toNbt() {
            ListNBT list = new ListNBT();
            this.tombstones.forEach(l -> list.add((Object)LongNBT.func_229698_a_((long)l)));
            return list;
        }

        @Override
        public void removePos(BlockPos pos) {
            this.tombstones.remove(pos.func_218275_a());
        }

        @Override
        public void addPos(BlockPos pos) {
            this.tombstones.add(pos.func_218275_a());
        }

        @Override
        public Optional<BlockPos> findNearest(BlockPos pos, BlockPos.Mutable mutable) {
            double distance = Double.MAX_VALUE;
            long nearest = -1L;
            boolean found = false;
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.func_218294_g(l);
                double d = pos.func_177951_i((Vector3i)mutable);
                if (!(d < distance)) continue;
                distance = d;
                nearest = l;
                found = true;
            }
            return found ? Optional.of(BlockPos.func_218283_e((long)nearest)) : Optional.empty();
        }

        @Override
        public void appendAll(AxisAlignedBB box, BlockPos.Mutable mutable, List<BlockPos> positions) {
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.func_218294_g(l);
                if (!box.func_197744_e((double)mutable.func_177958_n(), (double)mutable.func_177956_o(), (double)mutable.func_177952_p())) continue;
                positions.add(mutable.func_185334_h());
            }
        }
    }
}

