/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.PersistentStateCompat;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class Nationality
extends PersistentStateCompat {
    private static final int CHUNK_SIZE = 128;
    private Map<Long, Integer> map = new HashMap<Long, Integer>();
    static Random random = new Random();
    private static final int[][] neighbours = new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, 1}, {1, 1}, {-1, -1}, {-1, 1}};

    public static Nationality get(ServerWorld world) {
        return WorldUtils.loadData(world.func_73046_m().func_241755_D_(), Nationality::new, w -> new Nationality(), "mca_nationality");
    }

    Nationality() {
    }

    Nationality(CompoundNBT nbt) {
        this.map = NbtHelper.toMap(nbt, Long::valueOf, e -> ((IntNBT)e).func_150287_d());
    }

    @Override
    public CompoundNBT writeNbt(CompoundNBT nbt) {
        NbtHelper.fromMap(nbt, this.map, String::valueOf, IntNBT::func_229692_a_);
        return nbt;
    }

    private static long toId(long x, long z) {
        return x / 128L * Integer.MAX_VALUE + z / 128L;
    }

    public int getRegionId(BlockPos pos) {
        long rid;
        int id = -1;
        for (int[] neighbour : neighbours) {
            int z;
            int x = pos.func_177958_n() + neighbour[0] * 128;
            long rid2 = Nationality.toId(x, z = pos.func_177952_p() + neighbour[1] * 128);
            if (!this.map.containsKey(rid2)) continue;
            id = this.map.get(rid2);
            break;
        }
        if (id == -1) {
            id = random.nextInt();
        }
        if (!this.map.containsKey(rid = Nationality.toId(pos.func_177958_n(), pos.func_177952_p()))) {
            this.map.put(rid, id);
            this.markDirty();
        }
        return id;
    }
}

