/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import com.google.common.collect.Lists;
import forge.net.mca.Config;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.EntityRelationship;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.RelationshipType;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.item.ItemsMCA;
import forge.net.mca.network.s2c.ShowToastRequest;
import forge.net.mca.resources.API;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.OptionalCompat;
import forge.net.mca.util.compat.PersistentStateCompat;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSaveData
extends PersistentStateCompat
implements EntityRelationship {
    private final ServerWorld world;
    private final UUID uuid;
    private Optional<Integer> lastSeenVillage = Optional.empty();
    private boolean entityDataSet;
    private CompoundNBT entityData;
    private final List<CompoundNBT> inbox = new LinkedList<CompoundNBT>();

    public static PlayerSaveData get(ServerPlayerEntity player) {
        return PlayerSaveData.get(player.func_71121_q(), player.func_110124_au());
    }

    public static PlayerSaveData get(ServerWorld world, UUID uuid) {
        return WorldUtils.loadData(world.func_73046_m().func_241755_D_(), nbt -> new PlayerSaveData(world, uuid, (CompoundNBT)nbt), w -> new PlayerSaveData(world, uuid), "mca_player_" + uuid);
    }

    PlayerSaveData(ServerWorld world, UUID uuid) {
        this.world = world;
        this.uuid = uuid;
        this.resetEntityData();
    }

    PlayerSaveData(ServerWorld world, UUID uuid, CompoundNBT nbt) {
        this.world = world;
        this.uuid = uuid;
        this.lastSeenVillage = nbt.func_150297_b("lastSeenVillage", 3) ? Optional.of(nbt.func_74762_e("lastSeenVillage")) : Optional.empty();
        boolean bl = this.entityDataSet = nbt.func_74764_b("entityDataSet") && nbt.func_74767_n("entityDataSet");
        if (nbt.func_74764_b("entityData")) {
            this.entityData = nbt.func_74775_l("entityData");
        } else {
            this.resetEntityData();
        }
        ListNBT inbox = nbt.func_150295_c("inbox", 10);
        if (inbox != null) {
            this.inbox.clear();
            for (int i = 0; i < inbox.size(); ++i) {
                this.inbox.add(inbox.func_150305_b(i));
            }
        }
    }

    private void resetEntityData() {
        this.entityData = new CompoundNBT();
        VillagerEntityMCA villager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).func_200721_a((World)this.world);
        assert (villager != null);
        villager.initializeSkin(true);
        villager.getGenetics().randomize();
        villager.getTraits().randomize();
        villager.getVillagerBrain().randomize();
        villager.func_213281_b(this.entityData);
    }

    public boolean isEntityDataSet() {
        return this.entityDataSet;
    }

    public CompoundNBT getEntityData() {
        return this.entityData;
    }

    public void setEntityDataSet(boolean entityDataSet) {
        this.entityDataSet = entityDataSet;
    }

    public void setEntityData(CompoundNBT entityData) {
        this.entityData = entityData;
    }

    @Override
    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity victim) {
        EntityRelationship.super.onTragedy(cause, burialSite, type, victim);
        if (victim instanceof VillagerEntityMCA) {
            VillagerEntityMCA victimVillager = (VillagerEntityMCA)victim;
            this.sendLetterOfCondolence(victimVillager.func_200200_C_().getString(), victimVillager.getResidency().getHomeVillage().map(Village::getName).orElse(API.getVillagePool().pickVillageName("village")));
        }
    }

    public void updateLastSeenVillage(VillageManager manager, ServerPlayerEntity self) {
        Optional<Village> prevVillage = this.getLastSeenVillage(manager);
        Optional<Village> nextVillage = OptionalCompat.or(prevVillage.filter(v -> v.isWithinBorder((Entity)self)), () -> manager.findNearestVillage((Entity)self));
        this.setLastSeenVillage(self, prevVillage.orElse(null), nextVillage.orElse(null));
        if (nextVillage.isPresent()) {
            Rank rank = Tasks.getRank(nextVillage.get(), self);
            CriterionMCA.RANK.trigger(self, rank);
        }
    }

    public void setLastSeenVillage(ServerPlayerEntity self, Village oldVillage, @Nullable Village newVillage) {
        this.lastSeenVillage = Optional.ofNullable(newVillage).map(Village::getId);
        this.markDirty();
        if (oldVillage != newVillage) {
            if (oldVillage != null) {
                this.onLeave((PlayerEntity)self, oldVillage);
            }
            if (newVillage != null) {
                this.onEnter((PlayerEntity)self, newVillage);
            }
        }
    }

    public Optional<Village> getLastSeenVillage(VillageManager manager) {
        return this.lastSeenVillage.flatMap(manager::getOrEmpty);
    }

    public Optional<Integer> getLastSeenVillageId() {
        return this.lastSeenVillage;
    }

    protected void onLeave(PlayerEntity self, Village village) {
        if (Config.getInstance().enterVillageNotification && village.isVillage()) {
            self.func_146105_b((ITextComponent)new TranslationTextComponent("gui.village.left", new Object[]{village.getName()}).func_240699_a_(TextFormatting.GOLD), true);
        }
    }

    protected void onEnter(PlayerEntity self, Village village) {
        if (Config.getInstance().enterVillageNotification && village.isVillage()) {
            self.func_146105_b((ITextComponent)new TranslationTextComponent("gui.village.welcome", new Object[]{village.getName()}).func_240699_a_(TextFormatting.GOLD), true);
        }
        village.deliverTaxes(this.world);
    }

    @Override
    public void marry(Entity spouse) {
        EntityRelationship.super.marry(spouse);
        this.markDirty();
    }

    @Override
    public void endRelationShip(RelationshipState newState) {
        EntityRelationship.super.endRelationShip(newState);
        this.markDirty();
    }

    @Override
    public ServerWorld getWorld() {
        return this.world;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Gender getGender() {
        return Gender.byId(this.getEntityData().func_74762_e("gender"));
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrEmpty(this.uuid).orElseGet(() -> {
            String name = Optional.ofNullable(this.world.func_217371_b(this.uuid)).map(p -> p.func_200200_C_().getString()).orElse("Unnamed Adventurer");
            return this.getFamilyTree().getOrCreate(this.uuid, name, this.getGender(), true);
        });
    }

    public void reset() {
        this.endRelationShip(RelationshipState.SINGLE);
        this.markDirty();
    }

    @Override
    public CompoundNBT writeNbt(CompoundNBT nbt) {
        this.lastSeenVillage.ifPresent(id -> nbt.func_74768_a("lastSeenVillage", id.intValue()));
        nbt.func_218657_a("entityData", (INBT)this.entityData);
        nbt.func_74757_a("entityDataSet", this.entityDataSet);
        nbt.func_218657_a("inbox", (INBT)NbtHelper.fromList(this.inbox, v -> v));
        return nbt;
    }

    public void sendMail(CompoundNBT nbt) {
        this.inbox.add(nbt);
        this.markDirty();
    }

    public boolean hasMail() {
        return this.inbox.size() > 0;
    }

    public ItemStack getMail() {
        if (this.hasMail()) {
            CompoundNBT nbt = this.inbox.remove(0);
            ItemStack stack = new ItemStack((IItemProvider)ItemsMCA.LETTER.get(), 1);
            stack.func_77982_d(nbt);
            return stack;
        }
        return null;
    }

    public void sendEngagementLetter(String name) {
        this.sendLetter(Lists.newArrayList((Object[])new String[]{String.format("{ \"translate\": \"mca.letter.engagement\", \"with\": [\"%s\", \"%s\"] }", this.getFamilyEntry().getName(), name)}));
    }

    public void sendLetterOfCondolence(String name, String village) {
        this.sendLetter(Lists.newArrayList((Object[])new String[]{String.format("{ \"translate\": \"mca.letter.condolence\", \"with\": [\"%s\", \"%s\", \"%s\"] }", this.getFamilyEntry().getName(), name, village)}));
    }

    public void sendLetter(List<String> lines) {
        ListNBT l = new ListNBT();
        for (String line : lines) {
            l.add(0, (INBT)StringNBT.func_229705_a_((String)line));
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("pages", (INBT)l);
        this.sendMail(nbt);
        Optional.ofNullable(this.world.func_217371_b(this.uuid)).ifPresent(p -> PlayerSaveData.showMailNotification((ServerPlayerEntity)p));
    }

    public static void showMailNotification(ServerPlayerEntity player) {
        NetworkHandler.sendToPlayer(new ShowToastRequest("server.mail.title", "server.mail.description"), player);
    }
}

