/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.Config;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.EquipmentSet;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.resources.API;
import forge.net.mca.resources.PoolUtil;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.BlockBoxExtended;
import forge.net.mca.util.NbtHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Village
implements Iterable<Building> {
    private static final int MOVE_IN_COOLDOWN = 1200;
    private static final int MAX_STORAGE_SIZE = 1024;
    public static final int BORDER_MARGIN = 32;
    public static final int MERGE_MARGIN = 64;
    private String name = API.getVillagePool().pickVillageName("village");
    public final List<ItemStack> storageBuffer = new LinkedList<ItemStack>();
    private final Map<Integer, Building> buildings = new HashMap<Integer, Building>();
    private Map<UUID, Integer> unspentHearts = new HashMap<UUID, Integer>();
    private Map<UUID, Map<UUID, Integer>> reputation = new HashMap<UUID, Map<UUID, Integer>>();
    private int unspentMood = 0;
    public long lastMoveIn;
    private int id;
    private int taxes = 0;
    private int populationThreshold = 75;
    private int marriageThreshold = 50;
    private boolean autoScan = true;
    private BlockBoxExtended box = new BlockBoxExtended(0, 0, 0, 0, 0, 0);

    public Village() {
    }

    public Village(int id) {
        this.id = id;
    }

    public static Optional<Village> findNearest(Entity entity) {
        return VillageManager.get((ServerWorld)entity.field_70170_p).findNearestVillage(entity);
    }

    public boolean isWithinBorder(Entity entity) {
        return this.isWithinBorder(entity.func_233580_cy_());
    }

    public boolean isWithinBorder(BlockPos pos) {
        return this.isWithinBorder(pos, 32);
    }

    public boolean isWithinBorder(BlockPos pos, int margin) {
        return this.box.expand(margin).func_175898_b((Vector3i)pos);
    }

    @Override
    public Iterator<Building> iterator() {
        return this.buildings.values().iterator();
    }

    public void removeBuilding(int id) {
        this.buildings.remove(id);
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
    }

    public Stream<Building> getBuildingsOfType(String type) {
        return this.getBuildings().values().stream().filter(b -> b.getType().equals(type));
    }

    public Optional<Building> getBuildingAt(Vector3i pos) {
        return this.getBuildings().values().stream().filter(b -> b.containsPos(pos)).findAny();
    }

    public void calculateDimensions() {
        int sx = Integer.MAX_VALUE;
        int sy = Integer.MAX_VALUE;
        int sz = Integer.MAX_VALUE;
        int ex = Integer.MIN_VALUE;
        int ey = Integer.MIN_VALUE;
        int ez = Integer.MIN_VALUE;
        for (Building building : this.buildings.values()) {
            ex = Math.max(building.getPos1().func_177958_n(), ex);
            sx = Math.min(building.getPos0().func_177958_n(), sx);
            ey = Math.max(building.getPos1().func_177956_o(), ey);
            sy = Math.min(building.getPos0().func_177956_o(), sy);
            ez = Math.max(building.getPos1().func_177952_p(), ez);
            sz = Math.min(building.getPos0().func_177952_p(), sz);
        }
        this.box = new BlockBoxExtended(sx, sy, sz, ex, ey, ez);
    }

    public Vector3i getCenter() {
        return this.box.func_215126_f();
    }

    public BlockBoxExtended getBox() {
        return this.box;
    }

    public int getTaxes() {
        return this.taxes;
    }

    public void setTaxes(int taxes) {
        this.taxes = taxes;
    }

    public int getPopulationThreshold() {
        return this.populationThreshold;
    }

    public void setPopulationThreshold(int populationThreshold) {
        this.populationThreshold = populationThreshold;
    }

    public int getMarriageThreshold() {
        return this.marriageThreshold;
    }

    public void setMarriageThreshold(int marriageThreshold) {
        this.marriageThreshold = marriageThreshold;
    }

    public boolean isAutoScan() {
        return this.autoScan;
    }

    public void setAutoScan(boolean autoScan) {
        this.autoScan = autoScan;
    }

    public void toggleAutoScan() {
        this.setAutoScan(!this.isAutoScan());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Integer, Building> getBuildings() {
        return this.buildings;
    }

    public Optional<Building> getBuilding(int id) {
        return Optional.ofNullable(this.buildings.get(id));
    }

    public int getId() {
        return this.id;
    }

    public boolean hasSpace() {
        return this.getPopulation() < this.getMaxPopulation();
    }

    public int getPopulation() {
        int residents = 0;
        for (Building b : this) {
            residents += b.getResidents().size();
        }
        return residents;
    }

    public Stream<UUID> getResidentsUUIDs() {
        return this.getBuildings().values().stream().flatMap(building -> building.getResidents().keySet().stream());
    }

    public List<VillagerEntityMCA> getResidents(ServerWorld world) {
        return this.getResidentsUUIDs().map(arg_0 -> ((ServerWorld)world).func_217461_a(arg_0)).filter(v -> v instanceof VillagerEntityMCA).map(VillagerEntityMCA.class::cast).collect(Collectors.toList());
    }

    public int getMaxPopulation() {
        int residents = 0;
        for (Building b : this) {
            residents += b.getBedCount();
        }
        return residents;
    }

    public boolean hasStoredResource() {
        return this.storageBuffer.size() > 0;
    }

    public boolean hasBuilding(String building) {
        return this.buildings.values().stream().anyMatch(b -> b.getType().equals(building));
    }

    public void tick(ServerWorld world, long time) {
        boolean isVillageUpdateTime;
        boolean isTaxSeason = time % (long)Config.getInstance().taxSeason == 0L;
        boolean bl = isVillageUpdateTime = time % 1200L == 0L;
        if (isTaxSeason && this.hasBuilding("storage")) {
            IFormattableTextComponent msg;
            int emeraldValue = 100;
            int taxes = (int)(Config.getInstance().taxesFactor * (float)this.getPopulation() * (float)this.getTaxes() + (float)world.field_73012_v.nextInt(emeraldValue));
            int moodImpact = 0;
            float r = MathHelper.func_219799_g((float)0.5f, (float)((float)this.getTaxes() / 100.0f), (float)world.field_73012_v.nextFloat());
            if ((float)this.getTaxes() == 0.0f) {
                msg = new TranslationTextComponent("gui.village.taxes.no", new Object[]{this.getName()}).func_240699_a_(TextFormatting.GREEN);
                moodImpact = 5;
            } else if ((double)r < 0.1) {
                msg = new TranslationTextComponent("gui.village.taxes.more", new Object[]{this.getName()}).func_240699_a_(TextFormatting.GREEN);
                taxes = (int)((double)taxes + (double)this.getPopulation() * 0.25);
            } else if ((double)r < 0.3) {
                msg = new TranslationTextComponent("gui.village.taxes.happy", new Object[]{this.getName()}).func_240699_a_(TextFormatting.DARK_GREEN);
                moodImpact = 5;
            } else if ((double)r < 0.7) {
                msg = new TranslationTextComponent("gui.village.taxes", new Object[]{this.getName()});
            } else if ((double)r < 0.8) {
                msg = new TranslationTextComponent("gui.village.taxes.sad", new Object[]{this.getName()}).func_240699_a_(TextFormatting.GOLD);
                moodImpact = -5;
            } else if ((double)r < 0.9) {
                msg = new TranslationTextComponent("gui.village.taxes.angry", new Object[]{this.getName()}).func_240699_a_(TextFormatting.RED);
                moodImpact = -10;
            } else {
                msg = new TranslationTextComponent("gui.village.taxes.riot", new Object[]{this.getName()}).func_240699_a_(TextFormatting.DARK_RED);
                taxes = 0;
            }
            world.func_217369_A().stream().filter(v -> Tasks.getRank(this, v).isAtLeast(Rank.MERCHANT)).forEach(arg_0 -> Village.lambda$tick$6((ITextComponent)msg, arg_0));
            if (this.hasBuilding("library")) {
                taxes = (int)((double)taxes * 1.5);
            }
            for (int emeraldCount = taxes / emeraldValue; emeraldCount > 0 && this.storageBuffer.size() < 1024; emeraldCount -= Items.field_151166_bC.func_77639_j()) {
                this.storageBuffer.add(new ItemStack((IItemProvider)Items.field_151166_bC, Math.min(emeraldCount, Items.field_151166_bC.func_77639_j())));
            }
            if (moodImpact != 0) {
                this.pushMood(world, moodImpact * this.getPopulation());
            }
            this.deliverTaxes(world);
        }
        if (time % 24000L == 0L) {
            this.cleanReputation();
        }
        if (isVillageUpdateTime && this.lastMoveIn + 1200L < time) {
            this.spawnGuards(world);
            this.procreate(world);
            this.marry(world);
            this.inn(world);
        }
    }

    public void deliverTaxes(ServerWorld world) {
        if (this.hasStoredResource()) {
            this.getBuildingsOfType("storage").forEach(building -> building.getBlocks().values().stream().flatMap(Collection::stream).forEach(p -> {
                if (this.hasStoredResource()) {
                    this.tryToPutIntoInventory(world, (BlockPos)p);
                }
            }));
        }
    }

    private void tryToPutIntoInventory(ServerWorld world, BlockPos p) {
        IInventory inventory;
        TileEntity blockEntity;
        BlockState state = world.func_180495_p(p);
        Block block = state.func_177230_c();
        if (block.func_235695_q_() && (blockEntity = world.func_175625_s(p)) instanceof IInventory && (inventory = (IInventory)blockEntity) instanceof ChestTileEntity && block instanceof ChestBlock && (inventory = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)block), (BlockState)state, (World)world, (BlockPos)p, (boolean)true)) != null) {
            this.putIntoInventory(inventory);
        }
    }

    private void putIntoInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            boolean changes = true;
            while (changes) {
                changes = false;
                ItemStack stack = inventory.func_70301_a(i);
                ItemStack tax = this.storageBuffer.get(0);
                if (stack.func_77973_b() == tax.func_77973_b()) {
                    int diff = Math.min(tax.func_190916_E(), stack.func_77976_d() - stack.func_190916_E());
                    if (diff > 0) {
                        stack.func_190917_f(diff);
                        tax.func_190918_g(diff);
                        if (tax.func_190926_b()) {
                            this.storageBuffer.remove(0);
                            changes = true;
                        }
                        inventory.func_70296_d();
                    }
                } else if (stack.func_190926_b()) {
                    inventory.func_70299_a(i, tax);
                    inventory.func_70296_d();
                    this.storageBuffer.remove(0);
                    changes = true;
                }
                if (this.hasStoredResource()) continue;
                return;
            }
        }
    }

    private void spawnGuards(ServerWorld world) {
        int guardCapacity = this.getPopulation() / Config.getInstance().guardSpawnRate;
        int guards = 0;
        int citizen = 0;
        List<VillagerEntityMCA> villagers = this.getResidents(world);
        LinkedList<VillagerEntityMCA> nonGuards = new LinkedList<VillagerEntityMCA>();
        for (VillagerEntityMCA villager : villagers) {
            if (villager.isGuard()) {
                ++guards;
                continue;
            }
            if (!villager.func_70631_g_() && !villager.isProfessionImportant() && villager.func_213708_dV() == 0 && villager.func_213700_eh().func_221132_c() <= 1) {
                nonGuards.add(villager);
            }
            ++citizen;
        }
        guards = (int)((double)guards + Math.ceil((float)(this.getPopulation() - guards - citizen) / (float)Config.getInstance().guardSpawnRate));
        if (nonGuards.size() > 0 && guards < guardCapacity) {
            VillagerEntityMCA villager = (VillagerEntityMCA)nonGuards.get(world.field_73012_v.nextInt(nonGuards.size()));
            villager.setProfession(guards % 2 == 0 ? (VillagerProfession)ProfessionsMCA.GUARD.get() : (VillagerProfession)ProfessionsMCA.ARCHER.get());
        }
    }

    public void procreate(ServerWorld world) {
        int maxPopulation;
        if (world.field_73012_v.nextFloat() >= (float)Config.getInstance().childrenChance / 100.0f) {
            return;
        }
        int population = this.getPopulation();
        if ((float)population >= (float)((maxPopulation = this.getMaxPopulation()) * this.getPopulationThreshold()) / 100.0f) {
            return;
        }
        PoolUtil.pick(this.getResidents(world), world.field_73012_v).filter(villager -> villager.getGenetics().getGender() == Gender.FEMALE).filter(villager -> (double)world.field_73012_v.nextFloat() < 1.0 / ((double)FamilyTree.get(world).getOrCreate((Entity)villager).getChildren().count() + 0.1)).filter(villager -> villager.getRelationships().getPregnancy().tryStartGestation()).ifPresent(villager -> villager.getRelationships().getPartner().ifPresent(spouse -> {
            if (Config.getInstance().villagerBirthNotification && spouse instanceof VillagerEntityMCA) {
                this.broadCastMessage(world, "events.baby", (VillagerEntityMCA)villager, (VillagerEntityMCA)spouse);
            }
        }));
    }

    public void marry(ServerWorld world) {
        if (world.field_73012_v.nextFloat() >= (float)Config.getInstance().marriageChance / 100.0f) {
            return;
        }
        List<VillagerEntityMCA> allVillagers = this.getResidents(world);
        List availableVillagers = allVillagers.stream().filter(v -> !v.func_70631_g_()).filter(v -> !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().isEngaged()).filter(v -> !v.getRelationships().isPromised()).collect(Collectors.toList());
        if (availableVillagers.size() <= 1 || (float)availableVillagers.size() < (float)(allVillagers.size() * this.getMarriageThreshold()) / 100.0f) {
            return;
        }
        availableVillagers.sort(Comparator.comparingInt(a -> a.getVillagerBrain().getMemories().values().stream().map(Memories::getHearts).max(Integer::compare).orElse(0)));
        VillagerEntityMCA suitor = (VillagerEntityMCA)availableVillagers.remove(0);
        availableVillagers.stream().filter(suitor::canBeAttractedTo).filter(i -> !suitor.getRelationships().getFamilyEntry().isRelative(i.func_110124_au())).findFirst().ifPresent(mate -> {
            suitor.getRelationships().marry((Entity)mate);
            mate.getRelationships().marry((Entity)suitor);
            if (Config.getInstance().villagerMarriageNotification) {
                this.broadCastMessage(world, "events.marry", suitor, (VillagerEntityMCA)mate);
            }
        });
    }

    private void inn(ServerWorld world) {
        this.getBuildingsOfType("inn").forEach(b -> {
            block1: {
                BlockPos p;
                if (!(world.field_73012_v.nextFloat() < (float)Config.getInstance().adventurerAtInnChance / 100.0f)) break block1;
                List values = b.getBlocks().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                Collections.shuffle(values);
                Iterator iterator = values.iterator();
                while (iterator.hasNext() && !this.trySpawnAdventurer(world, (p = (BlockPos)iterator.next()).func_177984_a())) {
                }
            }
        });
    }

    private boolean doesNotSuffocateAt(IBlockReader world, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos, (BlockPos)pos.func_177984_a())) {
            if (world.func_180495_p(blockPos).func_196952_d(world, blockPos).func_197766_b()) continue;
            return false;
        }
        return true;
    }

    private boolean trySpawnAdventurer(ServerWorld world, BlockPos blockPos) {
        if (!world.func_217354_b(SectionPos.func_218159_a((int)blockPos.func_177958_n()), SectionPos.func_218159_a((int)blockPos.func_177952_p()))) {
            return true;
        }
        String name = null;
        if (this.doesNotSuffocateAt((IBlockReader)world, blockPos)) {
            VillagerEntityMCA adventurer;
            int i = world.field_73012_v.nextInt(10);
            if (i == 0 && Config.getInstance().innSpawnsWanderingTraders) {
                WanderingTraderEntity trader = (WanderingTraderEntity)EntityType.field_220351_aK.func_220342_a(world, null, null, null, blockPos, SpawnReason.EVENT, false, false);
                if (trader != null) {
                    name = trader.func_200200_C_().getString();
                    trader.func_213728_s(48000);
                }
            } else if (i == 1 && Config.getInstance().innSpawnsCultists) {
                VillagerEntityMCA adventurer2 = (VillagerEntityMCA)Gender.getRandom().getVillagerType().func_220342_a(world, null, null, null, blockPos, SpawnReason.EVENT, false, false);
                if (adventurer2 != null) {
                    name = adventurer2.func_200200_C_().getString();
                    adventurer2.setProfession((VillagerProfession)ProfessionsMCA.CULTIST.get());
                    adventurer2.setDespawnDelay(48000);
                }
            } else if (Config.getInstance().innSpawnsAdventurers && (adventurer = (VillagerEntityMCA)Gender.getRandom().getVillagerType().func_220342_a(world, null, null, null, blockPos, SpawnReason.EVENT, false, false)) != null) {
                name = adventurer.func_200200_C_().getString();
                adventurer.setProfession((VillagerProfession)ProfessionsMCA.ADVENTURER.get());
                adventurer.setDespawnDelay(48000);
            }
            if (name != null) {
                if (Config.getInstance().innArrivalNotification) {
                    this.broadCastMessage(world, "events.arrival.inn", name);
                }
                return true;
            }
        }
        return false;
    }

    public void broadCastMessage(ServerWorld world, String event, VillagerEntityMCA suitor, VillagerEntityMCA mate) {
        world.func_217369_A().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId() || suitor.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend || mate.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend).forEach(player -> player.func_146105_b((ITextComponent)new TranslationTextComponent(event, new Object[]{suitor.func_200200_C_(), mate.func_200200_C_()}), !Config.getInstance().showNotificationsAsChat));
    }

    public void broadCastMessage(ServerWorld world, String event, VillagerEntityMCA target) {
        world.func_217369_A().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId() || target.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend).forEach(player -> player.func_146105_b((ITextComponent)new TranslationTextComponent(event, new Object[]{target.func_200200_C_()}), !Config.getInstance().showNotificationsAsChat));
    }

    public void broadCastMessage(ServerWorld world, String event, String targetName) {
        world.func_217369_A().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId()).forEach(player -> player.func_146105_b((ITextComponent)new TranslationTextComponent(event, new Object[]{targetName}), !Config.getInstance().showNotificationsAsChat));
    }

    public void markDirty(ServerWorld world) {
        VillageManager.get(world).markDirty();
    }

    public void addResident(VillagerEntityMCA villager, int buildingId) {
        this.removeResident(villager);
        this.lastMoveIn = villager.field_70170_p.func_82737_E();
        this.buildings.get(buildingId).addResident((Entity)villager);
        this.markDirty((ServerWorld)villager.field_70170_p);
    }

    public void removeResident(VillagerEntityMCA villager) {
        this.removeResident(villager.func_110124_au());
    }

    public void removeResident(UUID uuid) {
        this.buildings.values().forEach(b -> b.getResidents().remove(uuid));
    }

    public EquipmentSet getGuardEquipment(VillagerProfession profession, Hand dominantHand) {
        if (profession == ProfessionsMCA.ARCHER.get()) {
            if (this.hasBuilding("armory")) {
                if (this.hasBuilding("blacksmith")) {
                    return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_2, EquipmentSet.ARCHER_2_LEFT);
                }
                return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_1, EquipmentSet.ARCHER_1_LEFT);
            }
            return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_0, EquipmentSet.ARCHER_0_LEFT);
        }
        if (this.hasBuilding("armory")) {
            if (this.hasBuilding("blacksmith")) {
                return EquipmentSet.GUARD_2;
            }
            return EquipmentSet.GUARD_1;
        }
        return Village.getEquipmentFor(dominantHand, EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT);
    }

    public static EquipmentSet getEquipmentFor(Hand dominantHand, EquipmentSet rightSet, EquipmentSet leftSet) {
        return dominantHand == Hand.OFF_HAND && leftSet != null ? leftSet : rightSet;
    }

    public void cleanReputation() {
        Set residents = this.getResidentsUUIDs().collect(Collectors.toSet());
        for (Map<UUID, Integer> map : this.reputation.values()) {
            Set toRemove = map.keySet().stream().filter(v -> !residents.contains(v)).collect(Collectors.toSet());
            for (UUID uuid : toRemove) {
                map.remove(uuid);
            }
        }
    }

    public void setReputation(PlayerEntity player, VillagerEntityMCA villager, int rep) {
        this.reputation.computeIfAbsent(player.func_110124_au(), i -> new HashMap()).put(villager.func_110124_au(), rep);
        this.markDirty((ServerWorld)player.field_70170_p);
    }

    public int getReputation(PlayerEntity player) {
        return this.reputation.getOrDefault(player.func_110124_au(), Collections.emptyMap()).values().stream().mapToInt(i -> i).sum() + this.unspentHearts.getOrDefault(player.func_110124_au(), 0);
    }

    public void resetHearts(PlayerEntity player) {
        this.unspentHearts.remove(player.func_110124_au());
        this.markDirty((ServerWorld)player.field_70170_p);
    }

    public void pushHearts(PlayerEntity player, int rep) {
        this.pushHearts(player.func_110124_au(), rep);
        this.markDirty((ServerWorld)player.field_70170_p);
    }

    public void pushHearts(UUID player, int rep) {
        this.unspentHearts.put(player, this.unspentHearts.getOrDefault(player, 0) + rep);
    }

    public int popHearts(PlayerEntity player) {
        int v = this.unspentHearts.getOrDefault(player.func_110124_au(), 0);
        int step = (int)Math.ceil(Math.abs((double)v / (double)this.getPopulation()));
        if (v > 0) {
            if ((v -= step) == 0) {
                this.unspentHearts.remove(player.func_110124_au());
            } else {
                this.unspentHearts.put(player.func_110124_au(), v);
            }
            this.markDirty((ServerWorld)player.field_70170_p);
            return step;
        }
        if (v < 0) {
            if ((v += step) == 0) {
                this.unspentHearts.remove(player.func_110124_au());
            } else {
                this.unspentHearts.put(player.func_110124_au(), v);
            }
            this.markDirty((ServerWorld)player.field_70170_p);
            return -step;
        }
        return 0;
    }

    public void pushMood(ServerWorld world, int m) {
        this.unspentMood += m;
        this.markDirty(world);
    }

    public int popMood(ServerWorld world) {
        int step = (int)Math.ceil(Math.abs((double)this.unspentMood / (double)this.getPopulation()));
        if (this.unspentMood > 0) {
            this.unspentMood -= step;
            this.markDirty(world);
            return step;
        }
        if (this.unspentMood < 0) {
            this.unspentMood += step;
            this.markDirty(world);
            return -step;
        }
        return 0;
    }

    public CompoundNBT save() {
        CompoundNBT v = new CompoundNBT();
        v.func_74768_a("id", this.id);
        v.func_74778_a("name", this.name);
        v.func_74768_a("taxes", this.taxes);
        v.func_218657_a("unspentHearts", (INBT)NbtHelper.fromMap(new CompoundNBT(), this.unspentHearts, UUID::toString, IntNBT::func_229692_a_));
        v.func_218657_a("reputation", (INBT)NbtHelper.fromMap(new CompoundNBT(), this.reputation, UUID::toString, i -> NbtHelper.fromMap(new CompoundNBT(), i, UUID::toString, IntNBT::func_229692_a_)));
        v.func_74768_a("unspentMood", this.unspentMood);
        v.func_74768_a("populationThreshold", this.populationThreshold);
        v.func_74768_a("marriageThreshold", this.marriageThreshold);
        v.func_218657_a("buildings", (INBT)NbtHelper.fromList(this.buildings.values(), Building::save));
        v.func_74757_a("autoScan", this.autoScan);
        return v;
    }

    public void load(CompoundNBT v) {
        this.id = v.func_74762_e("id");
        this.name = v.func_74779_i("name");
        this.taxes = v.func_74762_e("taxes");
        this.unspentHearts = NbtHelper.toMap(v.func_74775_l("unspentHearts"), UUID::fromString, i -> ((IntNBT)i).func_150287_d());
        this.reputation = NbtHelper.toMap(v.func_74775_l("reputation"), UUID::fromString, i -> NbtHelper.toMap((CompoundNBT)i, UUID::fromString, i2 -> ((IntNBT)i2).func_150287_d()));
        this.unspentMood = v.func_74762_e("unspentMood");
        this.populationThreshold = v.func_74762_e("populationThreshold");
        this.marriageThreshold = v.func_74762_e("marriageThreshold");
        this.autoScan = v.func_74764_b("autoScan") ? v.func_74767_n("autoScan") : true;
        ListNBT b = v.func_150295_c("buildings", 10);
        for (int i2 = 0; i2 < b.size(); ++i2) {
            Building building = new Building(b.func_150305_b(i2));
            this.buildings.put(building.getId(), building);
        }
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
    }

    public void merge(Village village) {
        this.buildings.putAll(village.buildings);
        this.unspentMood += village.unspentMood;
        this.calculateDimensions();
    }

    public boolean isVillage() {
        return this.getBuildings().size() >= Config.getInstance().minimumBuildingsToBeConsideredAVillage;
    }

    private static /* synthetic */ void lambda$tick$6(ITextComponent msg, ServerPlayerEntity player) {
        player.func_146105_b(msg, true);
    }
}

