/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.resources.API;
import forge.net.mca.resources.data.BuildingType;
import forge.net.mca.server.ReaperSpawner;
import forge.net.mca.server.SpawnQueue;
import forge.net.mca.server.world.data.BabyBunker;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.compat.PersistentStateCompat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class VillageManager
extends PersistentStateCompat
implements Iterable<Village> {
    private final Map<Integer, Village> villages = new HashMap<Integer, Village>();
    public final Set<BlockPos> cache = ConcurrentHashMap.newKeySet();
    public final Map<Integer, Integer> buildingToVillages = new HashMap<Integer, Integer>();
    private final List<BlockPos> buildingQueue = new LinkedList<BlockPos>();
    private int lastBuildingId;
    private int lastVillageId;
    private final ServerWorld world;
    private final ReaperSpawner reapers;
    private final BabyBunker babies;
    private int buildingCooldown = 21;

    public static VillageManager get(ServerWorld world) {
        return WorldUtils.loadData(world, nbt -> new VillageManager(world, (CompoundNBT)nbt), VillageManager::new, "mca_villages");
    }

    VillageManager(ServerWorld world) {
        this.world = world;
        this.reapers = new ReaperSpawner(this);
        this.babies = new BabyBunker(this);
    }

    VillageManager(ServerWorld world, CompoundNBT nbt) {
        this.world = world;
        this.lastBuildingId = nbt.func_74762_e("lastBuildingId");
        this.lastVillageId = nbt.func_74762_e("lastVillageId");
        this.reapers = nbt.func_150297_b("reapers", 10) ? new ReaperSpawner(this, nbt.func_74775_l("reapers")) : new ReaperSpawner(this);
        this.babies = nbt.func_150297_b("babies", 10) ? new BabyBunker(this, nbt.func_74775_l("babies")) : new BabyBunker(this);
        ListNBT villageList = nbt.func_150295_c("villages", 10);
        for (int i = 0; i < villageList.size(); ++i) {
            Village village = new Village();
            village.load(villageList.func_150305_b(i));
            if (village.getBuildings().isEmpty()) {
                MCA.LOGGER.warn("Empty village detected (" + village.getName() + "), removing...");
                this.markDirty();
                continue;
            }
            this.villages.put(village.getId(), village);
        }
        for (Village v : this.villages.values()) {
            for (Building b : v.getBuildings().values()) {
                this.buildingToVillages.put(b.getId(), v.getId());
            }
        }
    }

    public ReaperSpawner getReaperSpawner() {
        return this.reapers;
    }

    public BabyBunker getBabies() {
        return this.babies;
    }

    public Optional<Village> getOrEmpty(int id) {
        return Optional.ofNullable(this.villages.get(id));
    }

    public boolean removeVillage(int id) {
        if (this.villages.remove(id) != null) {
            this.cache.clear();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Village> iterator() {
        return this.villages.values().iterator();
    }

    public Stream<Village> findVillages(Predicate<Village> predicate) {
        return this.villages.values().stream().filter(predicate);
    }

    public Optional<Village> findNearestVillage(Entity entity) {
        BlockPos p = entity.func_233580_cy_();
        return this.findVillages(v -> v.isWithinBorder(entity)).min((a, b) -> (int)(a.getCenter().func_177951_i((Vector3i)p) - b.getCenter().func_177951_i((Vector3i)p)));
    }

    public Optional<Village> findNearestVillage(BlockPos p, int margin) {
        return this.findVillages(v -> v.isWithinBorder(p, margin)).min((a, b) -> (int)(a.getCenter().func_177951_i((Vector3i)p) - b.getCenter().func_177951_i((Vector3i)p)));
    }

    public boolean isWithinHorizontalBoundaries(BlockPos p) {
        return this.villages.values().stream().anyMatch(v -> v.getBox().expand(0, 1000, 0).func_175898_b((Vector3i)p));
    }

    @Override
    public CompoundNBT writeNbt(CompoundNBT nbt) {
        nbt.func_74768_a("lastBuildingId", this.lastBuildingId);
        nbt.func_74768_a("lastVillageId", this.lastVillageId);
        nbt.func_218657_a("villages", (INBT)NbtHelper.fromList(this.villages.values(), Village::save));
        nbt.func_218657_a("reapers", (INBT)this.reapers.writeNbt());
        return nbt;
    }

    public void tick() {
        if (this.world.func_72820_D() % 100L == 0L) {
            this.world.func_217369_A().forEach(player -> PlayerSaveData.get(player).updateLastSeenVillage(this, (ServerPlayerEntity)player));
        }
        if (this.world.func_72820_D() % (long)(Config.getInstance().bountyHunterInterval / 10) == 0L && this.world.func_175659_aa() != Difficulty.PEACEFUL) {
            this.world.func_217369_A().forEach(player -> {
                if (this.world.field_73012_v.nextInt(10) == 0 && !this.isWithinHorizontalBoundaries(player.func_233580_cy_()) && !player.func_184812_l_()) {
                    this.villages.values().stream().filter(v -> v.getPopulation() >= 3).filter(v -> v.getReputation((PlayerEntity)player) < Config.getInstance().bountyHunterHeartsInterval).min(Comparator.comparingInt(v -> v.getReputation((PlayerEntity)player))).ifPresent(buildings -> this.startBountyHunterWave((ServerPlayerEntity)player, (Village)buildings));
                }
            });
        }
        long time = this.world.func_82737_E();
        for (Village v : this) {
            v.tick(this.world, time);
        }
        if (time % (long)this.buildingCooldown == 0L && !this.buildingQueue.isEmpty()) {
            this.processBuilding(this.buildingQueue.remove(0));
        }
        this.reapers.tick(this.world);
        SpawnQueue.getInstance().tick();
    }

    private void startBountyHunterWave(ServerPlayerEntity player, Village sender) {
        int count = Math.min(30, -sender.getReputation((PlayerEntity)player) / 100 + 2);
        if (sender.getPopulation() == 0) {
            sender.cleanReputation();
            sender.resetHearts((PlayerEntity)player);
            count *= 2;
        } else {
            sender.pushHearts((PlayerEntity)player, count * 50);
        }
        CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "bounty_hunter");
        for (int c = 0; c < count; ++c) {
            if (this.world.field_73012_v.nextBoolean()) {
                this.spawnBountyHunter(EntityType.field_220350_aJ, player);
                continue;
            }
            this.spawnBountyHunter(EntityType.field_200758_ax, player);
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent(sender.getPopulation() == 0 ? "events.bountyHuntersFinal" : "events.bountyHunters", new Object[]{sender.getName()}).func_240699_a_(TextFormatting.RED), false);
    }

    private <T extends AbstractIllagerEntity> void spawnBountyHunter(EntityType<T> t, ServerPlayerEntity player) {
        AbstractIllagerEntity pillager = (AbstractIllagerEntity)t.func_200721_a((World)this.world);
        if (pillager != null) {
            for (int attempt = 0; attempt < 32; ++attempt) {
                int z;
                int y;
                float f = this.world.field_73012_v.nextFloat() * ((float)Math.PI * 2);
                int x = (int)(player.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)f) * 32.0f));
                BlockPos pos = new BlockPos(x, y = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = (int)(player.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)f) * 32.0f))), z);
                if (!WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)this.world, (BlockPos)pos, t)) continue;
                pillager.func_70107_b((double)x, (double)y, (double)z);
                pillager.func_70624_b((LivingEntity)player);
                WorldUtils.spawnEntity((World)this.world, (MobEntity)pillager, SpawnReason.EVENT);
                break;
            }
        }
    }

    public void reportBuilding(BlockPos pos) {
        this.cache.add(pos);
        this.buildingQueue.add(pos);
    }

    public Building.validationResult processBuilding(BlockPos pos) {
        return this.processBuilding(pos, false, false);
    }

    private BuildingType getGroupedBuildingType(BlockPos pos) {
        Block block = this.world.func_180495_p(pos).func_177230_c();
        for (BuildingType bt : API.getVillagePool()) {
            if (!bt.grouped() || !bt.getBlockToGroup().containsKey(Registry.field_212618_g.func_177774_c((Object)block))) continue;
            return bt;
        }
        return null;
    }

    private Set<BlockPos> getBlockedSet(Village village) {
        return village.getBuildings().values().stream().filter(b -> !b.getBuildingType().grouped()).map(Building::getSourceBlock).collect(Collectors.toSet());
    }

    public Building.validationResult processBuilding(BlockPos pos, boolean enforce, boolean strictScan) {
        Village village;
        Optional<Village> optionalVillage = this.findNearestVillage(pos, 64);
        BuildingType groupedBuildingType = this.getGroupedBuildingType(pos);
        HashSet<BlockPos> blocked = new HashSet();
        boolean found = false;
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        if (optionalVillage.isPresent()) {
            Iterator name;
            village = optionalVillage.get();
            blocked = this.getBlockedSet(village);
            if (groupedBuildingType != null) {
                name = groupedBuildingType.name();
                double range = groupedBuildingType.mergeRange() * groupedBuildingType.mergeRange();
                Optional<Building> building = village.getBuildings().values().stream().filter(arg_0 -> VillageManager.lambda$processBuilding$13((String)((Object)name), arg_0)).min((a, b) -> (int)(a.getCenter().func_177951_i((Vector3i)pos) - b.getCenter().func_177951_i((Vector3i)pos))).filter(b -> b.getCenter().func_177951_i((Vector3i)pos) < range);
                if (building.isPresent()) {
                    found = true;
                    building.get().addPOI((World)this.world, pos);
                    this.markDirty();
                }
            } else {
                for (Building b2 : village.getBuildings().values()) {
                    if (!b2.containsPos((Vector3i)pos)) continue;
                    if (!enforce) {
                        found = true;
                    }
                    if (!enforce && this.world.func_82737_E() - b2.getLastScan() <= 4800L || b2.validateBuilding((World)this.world, blocked) == Building.validationResult.SUCCESS) continue;
                    toRemove.add(b2.getId());
                }
            }
            village.getBuildings().values().stream().filter(b -> enforce || this.world.func_82737_E() - b.getLastScan() > 4800L).filter(b -> b.getBuildingType().grouped()).filter(b -> b.getCenter().func_177951_i((Vector3i)pos) < 1024.0).forEach(b -> {
                b.validateBlocks((World)this.world);
                if (!b.getBlockPosStream().findAny().isPresent()) {
                    toRemove.add(b.getId());
                }
            });
            name = toRemove.iterator();
            while (name.hasNext()) {
                int id = (Integer)name.next();
                village.removeBuilding(id);
                this.markDirty();
            }
            if (village.getBuildings().isEmpty()) {
                this.villages.remove(village.getId());
                optionalVillage = Optional.empty();
                this.markDirty();
            }
        }
        if (!found && !blocked.contains(pos)) {
            village = optionalVillage.orElse(new Village(this.lastVillageId++));
            Building building = new Building(pos, strictScan);
            if (groupedBuildingType != null) {
                building.setType(groupedBuildingType.name());
                building.addPOI((World)this.world, pos);
            } else {
                Building.validationResult result = building.validateBuilding((World)this.world, blocked);
                if (result == Building.validationResult.SUCCESS) {
                    if (village.getBuildings().values().stream().anyMatch(b -> b.isIdentical(building))) {
                        return Building.validationResult.IDENTICAL;
                    }
                } else {
                    return result;
                }
            }
            this.villages.put(village.getId(), village);
            building.setId(this.lastBuildingId++);
            village.getBuildings().put(building.getId(), building);
            village.calculateDimensions();
            this.buildingToVillages.put(building.getId(), village.getId());
            this.villages.values().stream().filter(v -> v != village).filter(v -> v.getBox().expand(64).func_78884_a((MutableBoundingBox)village.getBox())).findAny().ifPresent(v -> {
                if (v.getPopulation() > village.getPopulation()) {
                    this.merge((Village)v, village);
                    this.villages.remove(village.getId());
                } else {
                    this.merge(village, (Village)v);
                    this.villages.remove(v.getId());
                }
            });
            this.markDirty();
        }
        return Building.validationResult.SUCCESS;
    }

    public void setBuildingCooldown(int buildingCooldown) {
        this.buildingCooldown = buildingCooldown;
    }

    public int mapBuildingToVillage(Integer buildingId) {
        return this.buildingToVillages.getOrDefault(buildingId, -1);
    }

    public void merge(Village into, Village from) {
        into.merge(from);
        for (Building b : from.getBuildings().values()) {
            this.buildingToVillages.put(b.getId(), into.getId());
        }
    }

    private static /* synthetic */ boolean lambda$processBuilding$13(String name, Building b) {
        return b.getType().equals(name);
    }
}

