/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.jetbrains.annotations.Nullable;

public interface InventoryUtils {
    public static Stream<ItemStack> stream(IInventory inventory) {
        return IntStream.range(0, inventory.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0));
    }

    public static int getFirstSlotContainingItem(IInventory inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!predicate.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(IInventory inv, Class<?> clazz) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (item.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getBestItemOfType(IInventory inv, @Nullable Class<?> type) {
        return type == null ? ItemStack.field_190927_a : inv.func_70301_a(InventoryUtils.getBestItemOfTypeSlot(inv, type));
    }

    public static int getBestItemOfTypeSlot(IInventory inv, Class<?> type) {
        int highestMaxDamage = 0;
        int best = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInInventory = inv.func_70301_a(i);
            String itemClassName = stackInInventory.func_77973_b().getClass().getName();
            if (!itemClassName.equals(type.getName()) || highestMaxDamage >= stackInInventory.func_77958_k()) continue;
            highestMaxDamage = stackInInventory.func_77958_k();
            best = i;
        }
        return best;
    }

    public static Optional<ItemStack> getBestArmor(IInventory inv, EquipmentSlotType slot) {
        return InventoryUtils.stream(inv).filter(s -> s.func_77973_b() instanceof ArmorItem).filter(s -> ((ArmorItem)s.func_77973_b()).func_185083_B_() == slot).max(Comparator.comparingDouble(s -> ((ArmorItem)s.func_77973_b()).func_200881_e()));
    }

    public static Optional<ItemStack> getBestSword(IInventory inv) {
        return InventoryUtils.stream(inv).filter(s -> s.func_77973_b() instanceof SwordItem).max(Comparator.comparingDouble(s -> ((SwordItem)s.func_77973_b()).func_200894_d()));
    }

    public static void dropAllItems(Entity entity, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            entity.func_70099_a(stack, 1.0f);
        }
        inv.func_174888_l();
    }

    public static void load(IInventory inv, ListNBT tagList) {
        int i;
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            int slot = nbt.func_74771_c("Slot") & 0xFF;
            if (slot >= inv.func_70302_i_()) continue;
            inv.func_70299_a(slot, ItemStack.func_199557_a((CompoundNBT)nbt));
        }
    }

    public static ListNBT save(IInventory inv) {
        ListNBT tagList = new ListNBT();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack == ItemStack.field_190927_a) continue;
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77982_d(nbt);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    public static void saveToNBT(Inventory inv, CompoundNBT nbt) {
        nbt.func_218657_a("Inventory", (INBT)inv.func_70487_g());
    }

    public static void readFromNBT(Inventory inv, CompoundNBT nbt) {
        inv.func_70486_a(nbt.func_150295_c("Inventory", 10));
    }
}

