/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public interface NbtHelper {
    public static <T extends INBT> T computeIfAbsent(CompoundNBT nbt, String key, int type, Supplier<T> factory) {
        if (!nbt.func_150297_b(key, type)) {
            nbt.func_218657_a(key, (INBT)factory.get());
        }
        return (T)nbt.func_74781_a(key);
    }

    public static CompoundNBT copyTo(CompoundNBT from, CompoundNBT to) {
        from.func_150296_c().forEach(key -> to.func_218657_a(key, from.func_74781_a(key)));
        return to;
    }

    public static <V> List<V> toList(INBT nbt, Function<INBT, V> valueMapper) {
        return NbtHelper.toStream(nbt, valueMapper).collect(Collectors.toList());
    }

    public static <V> Stream<V> toStream(INBT nbt, Function<INBT, V> valueMapper) {
        return ((ListNBT)nbt).stream().map(valueMapper);
    }

    public static <K, V> Map<K, V> toMap(CompoundNBT nbt, Function<String, K> keyMapper, Function<INBT, V> valueMapper) {
        return NbtHelper.toMap(nbt, keyMapper, (K k, INBT e) -> valueMapper.apply((INBT)e));
    }

    public static <K, V> Map<K, V> toMap(CompoundNBT nbt, Function<String, K> keyMapper, BiFunction<K, INBT, V> valueMapper) {
        return nbt.func_150296_c().stream().map(e -> {
            Object k = keyMapper.apply((String)e);
            if (k == null) {
                return null;
            }
            Object v = valueMapper.apply(k, nbt.func_74781_a(e));
            if (v == null) {
                return null;
            }
            return k == null ? null : new Pair(k, v);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static <V> ListNBT fromList(Iterable<V> list, Function<V, INBT> valueMapper) {
        ListNBT output = new ListNBT();
        list.forEach(item -> output.add((Object)((INBT)valueMapper.apply(item))));
        return output;
    }

    public static <K, V> CompoundNBT fromMap(CompoundNBT output, Map<K, V> map, Function<K, String> keyMapper, Function<V, INBT> valueMapper) {
        map.forEach((key, value) -> output.func_218657_a((String)keyMapper.apply(key), (INBT)valueMapper.apply(value)));
        return output;
    }
}

