/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util;

import forge.net.mca.util.compat.PersistentStateCompat;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public interface WorldUtils {
    public static List<Entity> getCloseEntities(World world, Entity e) {
        return WorldUtils.getCloseEntities(world, e, 256.0);
    }

    public static List<Entity> getCloseEntities(World world, Entity e, double range) {
        Vector3d pos = e.func_213303_ch();
        return world.func_72839_b(e, new AxisAlignedBB(pos, pos).func_186662_g(range));
    }

    public static <T extends Entity> List<T> getCloseEntities(World world, Entity e, Class<T> c) {
        return WorldUtils.getCloseEntities(world, e, 256.0, c);
    }

    public static <T extends Entity> List<T> getCloseEntities(World world, Entity e, double range, Class<T> c) {
        return WorldUtils.getCloseEntities(world, e.func_213303_ch(), range, c);
    }

    public static <T extends Entity> List<T> getCloseEntities(World world, Vector3d pos, double range, Class<T> c) {
        return world.func_217357_a(c, new AxisAlignedBB(pos, pos).func_186662_g(range));
    }

    public static <T extends PersistentStateCompat> T loadData(final ServerWorld world, final Function<CompoundNBT, T> loader, final Function<ServerWorld, T> factory, String dataId) {
        return (world.func_217481_x().func_215752_a(() -> new WorldSavedData(dataId){
            private T obj;

            public void func_76184_a(CompoundNBT tag) {
                this.obj = (PersistentStateCompat)loader.apply(tag);
                ((PersistentStateCompat)this.obj).attach(this);
            }

            public CompoundNBT func_189551_b(CompoundNBT nbt) {
                return ((PersistentStateCompat)this.get()).writeNbt(nbt);
            }

            public T get() {
                if (this.obj == null) {
                    this.obj = (PersistentStateCompat)factory.apply(world);
                    ((PersistentStateCompat)this.obj).attach(this);
                }
                return this.obj;
            }
        }, dataId)).get();
    }

    public static void spawnEntity(World world, MobEntity entity, SpawnReason reason) {
        entity.func_213386_a((IServerWorld)world, world.func_175649_E(entity.func_233580_cy_()), reason, null, null);
        world.func_217376_c((Entity)entity);
    }

    public static Optional<BlockPos> getClosestStructurePosition(ServerWorld world, BlockPos center, ResourceLocation structure, int radius) {
        Structure feature = (Structure)Registry.field_218361_B.func_82594_a(structure);
        if (feature != null) {
            BlockPos pos = world.func_241117_a_(feature, center, radius, false);
            return pos == null ? Optional.empty() : Optional.of(pos);
        }
        return Optional.empty();
    }
}

