/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util.compat;

import com.google.common.annotations.VisibleForTesting;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.util.math.BlockPos;

public class FuzzyPositionsCompat {
    public static BlockPos localFuzz(Random random, int horizontalRange, int verticalRange) {
        int i = random.nextInt(2 * horizontalRange + 1) - horizontalRange;
        int j = random.nextInt(2 * verticalRange + 1) - verticalRange;
        int k = random.nextInt(2 * horizontalRange + 1) - horizontalRange;
        return new BlockPos(i, j, k);
    }

    @VisibleForTesting
    public static BlockPos upWhile(BlockPos pos, int maxY, Predicate<BlockPos> condition) {
        if (!condition.test(pos)) {
            return pos;
        }
        BlockPos blockPos = pos.func_177984_a();
        while (blockPos.func_177956_o() < maxY && condition.test(blockPos)) {
            blockPos = blockPos.func_177984_a();
        }
        return blockPos;
    }

    @VisibleForTesting
    public static BlockPos downWhile(BlockPos pos, int minY, Predicate<BlockPos> condition) {
        if (!condition.test(pos)) {
            return pos;
        }
        BlockPos blockPos = pos.func_177977_b();
        while (blockPos.func_177956_o() > minY && condition.test(blockPos)) {
            blockPos = blockPos.func_177977_b();
        }
        return blockPos;
    }
}

