/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util.network.datasync;

import forge.net.mca.util.network.datasync.CParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;

public class CDataManager<E extends Entity> {
    private final List<Entry<E, ?, ?>> params;
    private final Map<CParameter<?, ?>, Entry<E, ?, ?>> forwardLookup = new HashMap();
    private final Map<DataParameter<?>, Entry<E, ?, ?>> backwardLookup = new HashMap();

    private CDataManager(List<Entry<E, ?, ?>> params) {
        this.params = params;
        params.forEach(param -> {
            this.forwardLookup.put(param.parameter, (Entry<E, ?, ?>)param);
            this.backwardLookup.put(param.data, (Entry<E, ?, ?>)param);
        });
    }

    public boolean isParam(CParameter<?, ?> parameter, DataParameter<?> data) {
        Entry<E, ?, ?> entry = this.backwardLookup.get(data);
        return entry != null && entry.parameter == parameter;
    }

    public <T, TrackedType> T get(E entity, CParameter<T, TrackedType> parameter) {
        return parameter.get(this.forwardLookup.get(parameter).data, entity.func_184212_Q());
    }

    public <T, TrackedType> void set(E entity, CParameter<T, TrackedType> parameter, T value) {
        parameter.set(this.forwardLookup.get(parameter).data, entity.func_184212_Q(), value);
    }

    public void register(E entity) {
        this.params.forEach(p -> p.register(entity));
    }

    public void load(E entity, CompoundNBT nbt) {
        this.params.forEach(p -> p.load(entity, nbt));
    }

    public void save(E entity, CompoundNBT nbt) {
        this.params.forEach(p -> p.save(entity, nbt));
    }

    private static class Entry<E extends Entity, T, TrackedType> {
        CParameter<T, TrackedType> parameter;
        DataParameter<TrackedType> data;

        public Entry(Class<E> type, CParameter<T, TrackedType> parameter) {
            this.parameter = parameter;
            this.data = parameter.createParam(type);
        }

        public void save(E entity, CompoundNBT nbt) {
            this.parameter.save(nbt, this.parameter.get(this.data, entity.func_184212_Q()));
        }

        public void load(E entity, CompoundNBT nbt) {
            this.parameter.set(this.data, entity.func_184212_Q(), this.parameter.load(nbt));
        }

        public void register(E entity) {
            entity.func_184212_Q().func_187214_a(this.data, this.parameter.getDefault());
        }
    }

    public static class Builder<E extends Entity> {
        private final Class<E> type;
        private final List<Entry<E, ?, ?>> params = new ArrayList();

        public Builder(Class<E> type) {
            this.type = type;
        }

        public Builder<E> addAll(CParameter<?, ?> ... params) {
            Stream.of(params).map(p -> new Entry(this.type, p)).forEach(this.params::add);
            return this;
        }

        public Builder<E> add(Function<Builder<E>, Builder<E>> subType) {
            return subType.apply(this);
        }

        public CDataManager<E> build() {
            return new CDataManager(this.params);
        }
    }
}

