/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util.network.datasync;

import forge.net.mca.util.network.datasync.CParameter;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;

public class CDataParameter<T>
implements CParameter<T, T> {
    private final String id;
    private final T defaultValue;
    private final IDataSerializer<T> valueType;
    private final BiFunction<CompoundNBT, String, T> load;
    private final TriConsumer<CompoundNBT, String, ? super T> save;

    protected CDataParameter(String id, IDataSerializer<T> valueType, T defaultValue, BiFunction<CompoundNBT, String, T> load, TriConsumer<CompoundNBT, String, ? super T> save) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.valueType = valueType;
        this.load = load;
        this.save = save;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T get(DataParameter<T> param, EntityDataManager tracker) {
        return (T)tracker.func_187225_a(param);
    }

    @Override
    public void set(DataParameter<T> param, EntityDataManager tracker, T v) {
        tracker.func_187227_b(param, v);
    }

    @Override
    public T load(CompoundNBT nbt) {
        return this.load.apply(nbt, this.id);
    }

    @Override
    public void save(CompoundNBT nbt, T value) {
        this.save.accept(nbt, this.id, value);
    }

    @Override
    public DataParameter<T> createParam(Class<? extends Entity> type) {
        return EntityDataManager.func_187226_a(type, this.valueType);
    }

    public static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

