/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.util.network.datasync;

import forge.net.mca.util.network.datasync.CParameter;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import org.jetbrains.annotations.Nullable;

public class CEnumParameter<T extends Enum<T>>
implements CParameter<T, Integer> {
    private final String id;
    @Nullable
    private final T defaultValue;
    private final T[] values;

    public CEnumParameter(String id, Class<T> type, @Nullable T dv) {
        this.id = id;
        this.defaultValue = dv;
        this.values = (Enum[])type.getEnumConstants();
    }

    @Override
    public Integer getDefault() {
        return this.defaultValue == null ? -1 : ((Enum)this.defaultValue).ordinal();
    }

    @Override
    public T get(DataParameter<Integer> param, EntityDataManager tracker) {
        return this.fromIndex((Integer)tracker.func_187225_a(param));
    }

    @Override
    public void set(DataParameter<Integer> param, EntityDataManager tracker, @Nullable T v) {
        tracker.func_187227_b(param, (Object)(v == null ? -1 : ((Enum)v).ordinal()));
    }

    @Override
    public T load(CompoundNBT nbt) {
        return nbt.func_150297_b(this.id, 99) ? this.fromIndex(nbt.func_74762_e(this.id)) : this.defaultValue;
    }

    @Override
    public void save(CompoundNBT nbt, T value) {
        if (value != null) {
            nbt.func_74768_a(this.id, ((Enum)value).ordinal());
        }
    }

    private T fromIndex(int index) {
        return index < 0 || index >= this.values.length ? this.defaultValue : this.values[index];
    }

    @Override
    public DataParameter<Integer> createParam(Class<? extends Entity> type) {
        return EntityDataManager.func_187226_a(type, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

