/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import quek.undergarden.block.tileentity.DepthrockBedTE;
import quek.undergarden.registry.UGDimensions;

public class DepthrockBedBlock
extends BedBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public DepthrockBedBlock(AbstractBlock.Properties properties) {
        super(DyeColor.GREEN, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((Property)field_176471_b, (Comparable)Boolean.FALSE));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        if (state.func_177229_b((Property)field_176472_a) != BedPart.HEAD && !(state = world.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((Property)field_185512_D)))).func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!DepthrockBedBlock.canSetSpawn(world)) {
            world.func_217377_a(pos, false);
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d());
            if (world.func_180495_p(blockpos).func_203425_a((Block)this)) {
                world.func_217377_a(blockpos, false);
            }
            world.func_230546_a_(null, DamageSource.func_233546_a_(), null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)field_176471_b)).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied"), true);
            return ActionResultType.SUCCESS;
        }
        player.func_213819_a(pos).ifLeft(sleepResult -> {
            if (sleepResult != null) {
                player.func_146105_b(sleepResult.func_221259_a(), true);
            }
        });
        return ActionResultType.SUCCESS;
    }

    public static boolean canSetSpawn(World world) {
        return world.func_234923_W_() == UGDimensions.UNDERGARDEN_WORLD;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new DepthrockBedTE();
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        super.func_180658_a(world, pos, entity, distance);
    }

    public void func_176216_a(IBlockReader world, Entity entity) {
        entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
    }
}

