/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.potion.Potion;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.data.LanguageProvider;
import quek.undergarden.registry.UGBiomes;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItemGroups;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGPotions;

public class UGLang
extends LanguageProvider {
    public UGLang(DataGenerator gen) {
        super(gen, "undergarden", "en_us");
    }

    private void addItemGroup(ItemGroup group, String name) {
        this.add(group.func_242392_c().getString(), name);
    }

    private void addAdvTitle(String advancementTitle, String name) {
        this.add("advancement." + advancementTitle + ".title", name);
    }

    private void addAdvDesc(String advancementTitle, String name) {
        this.add("advancement." + advancementTitle + ".desc", name);
    }

    private void addSubtitle(String category, String subtitleName, String name) {
        this.add("subtitles." + category + "." + subtitleName, name);
    }

    private void addBiome(RegistryKey<Biome> biomeKey, String name) {
        this.add("biome.undergarden." + biomeKey.func_240901_a_().func_110623_a(), name);
    }

    private void addDeath(String deathName, String name) {
        this.add("death.attack." + deathName, name);
    }

    private void addPotion(Supplier<? extends Potion> potion, String name) {
        this.add("item.minecraft.potion.effect." + potion.get().getRegistryName().func_110623_a(), "Potion of " + name);
        this.add("item.minecraft.splash_potion.effect." + potion.get().getRegistryName().func_110623_a(), "Splash Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect." + potion.get().getRegistryName().func_110623_a(), "Lingering Potion of " + name);
        this.add("item.minecraft.tipped_arrow.effect." + potion.get().getRegistryName().func_110623_a(), "Arrow of " + name);
    }

    protected void addTranslations() {
        this.addBlock((Supplier)UGBlocks.UNDERGARDEN_PORTAL, "Undergarden Portal");
        this.addBlock((Supplier)UGBlocks.SHARD_TORCH, "Shard Torch");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK, "Depthrock");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_BRICKS, "Depthrock Bricks");
        this.addBlock((Supplier)UGBlocks.CRACKED_DEPTHROCK_BRICKS, "Cracked Depthrock Bricks");
        this.addBlock((Supplier)UGBlocks.CHISELED_DEPTHROCK_BRICKS, "Chiseled Depthrock Bricks");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_TILES, "Depthrock Tiles");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_STAIRS, "Depthrock Stairs");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_BRICK_STAIRS, "Depthrock Brick Stairs");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_TILE_STAIRS, "Depthrock Tile Stairs");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_SLAB, "Depthrock Slab");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_BRICK_SLAB, "Depthrock Brick Slab");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_TILE_SLAB, "Depthrock Tile Slab");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_WALL, "Depthrock Wall");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_BRICK_WALL, "Depthrock Brick Wall");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_BUTTON, "Depthrock Button");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_PRESSURE_PLATE, "Depthrock Pressure Plate");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE, "Shiverstone");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_BRICKS, "Shiverstone Bricks");
        this.addBlock((Supplier)UGBlocks.CRACKED_SHIVERSTONE_BRICKS, "Cracked Shiverstone Bricks");
        this.addBlock((Supplier)UGBlocks.CHISELED_SHIVERSTONE_BRICKS, "Chiseled Shiverstone Bricks");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_STAIRS, "Shiverstone Stairs");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_BRICK_STAIRS, "Shiverstone Brick Stairs");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_SLAB, "Shiverstone Slab");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_BRICK_SLAB, "Shiverstone Brick Slab");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_WALL, "Shiverstone Wall");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_BRICK_WALL, "Shiverstone Brick Wall");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_BUTTON, "Shiverstone Button");
        this.addBlock((Supplier)UGBlocks.SHIVERSTONE_PRESSURE_PLATE, "Shiverstone Pressure Plate");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST, "Tremblecrust");
        this.addBlock((Supplier)UGBlocks.LOOSE_TREMBLECRUST, "Loose Tremblecrust");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_BRICKS, "Tremblecrust Bricks");
        this.addBlock((Supplier)UGBlocks.CRACKED_TREMBLECRUST_BRICKS, "Cracked Tremblecrust Bricks");
        this.addBlock((Supplier)UGBlocks.CHISELED_TREMBLECRUST_BRICKS, "Chiseled Tremblecrust Bricks");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_STAIRS, "Tremblecrust Stairs");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_BRICK_STAIRS, "Tremblecrust Brick Stairs");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_SLAB, "Tremblecrust Slab");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_BRICK_SLAB, "Tremblecrust Brick Slab");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_WALL, "Tremblecrust Wall");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_BRICK_WALL, "Tremblecrust Brick Wall");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_BUTTON, "Tremblecrust Button");
        this.addBlock((Supplier)UGBlocks.TREMBLECRUST_PRESSURE_PLATE, "Tremblecrust Pressure Plate");
        this.addBlock((Supplier)UGBlocks.COAL_ORE, "Undergarden Coal Ore");
        this.addBlock((Supplier)UGBlocks.IRON_ORE, "Undergarden Iron Ore");
        this.addBlock((Supplier)UGBlocks.GOLD_ORE, "Undergarden Gold Ore");
        this.addBlock((Supplier)UGBlocks.DIAMOND_ORE, "Undergarden Diamond Ore");
        this.addBlock((Supplier)UGBlocks.CLOGGRUM_ORE, "Cloggrum Ore");
        this.addBlock((Supplier)UGBlocks.FROSTSTEEL_ORE, "Froststeel Ore");
        this.addBlock((Supplier)UGBlocks.UTHERIUM_ORE, "Utherium Ore");
        this.addBlock((Supplier)UGBlocks.OTHERSIDE_UTHERIUM_ORE, "Otherside Utherium Ore");
        this.addBlock((Supplier)UGBlocks.REGALIUM_ORE, "Regalium Ore");
        this.addBlock((Supplier)UGBlocks.CLOGGRUM_BLOCK, "Block of Cloggrum");
        this.addBlock((Supplier)UGBlocks.FROSTSTEEL_BLOCK, "Block of Froststeel");
        this.addBlock((Supplier)UGBlocks.UTHERIUM_BLOCK, "Block of Utherium");
        this.addBlock((Supplier)UGBlocks.REGALIUM_BLOCK, "Block of Regalium");
        this.addBlock((Supplier)UGBlocks.FORGOTTEN_BLOCK, "Block of Forgotten Metal");
        this.addBlock((Supplier)UGBlocks.DEEPTURF_BLOCK, "Deepturf Block");
        this.addBlock((Supplier)UGBlocks.ASHEN_DEEPTURF_BLOCK, "Ashen Deepturf Block");
        this.addBlock((Supplier)UGBlocks.FROZEN_DEEPTURF_BLOCK, "Frozen Deepturf Block");
        this.addBlock((Supplier)UGBlocks.DEEPSOIL, "Deepsoil");
        this.addBlock((Supplier)UGBlocks.COARSE_DEEPSOIL, "Coarse Deepsoil");
        this.addBlock((Supplier)UGBlocks.DEEPSOIL_FARMLAND, "Deepsoil Farmland");
        this.addBlock((Supplier)UGBlocks.GOO, "Scintling Goo");
        this.addBlock((Supplier)UGBlocks.GOO_BLOCK, "Scintling Goo Block");
        this.addBlock((Supplier)UGBlocks.SMOG_VENT, "Smog Vent");
        this.addBlock((Supplier)UGBlocks.SEDIMENT, "Sediment");
        this.addBlock((Supplier)UGBlocks.SEDIMENT_GLASS, "Sediment Glass");
        this.addBlock((Supplier)UGBlocks.SEDIMENT_GLASS_PANE, "Sediment Glass Pane");
        this.addBlock((Supplier)UGBlocks.CLOGGRUM_BARS, "Cloggrum Bars");
        this.addBlock((Supplier)UGBlocks.CLOGGRUM_TILES, "Cloggrum Tiles");
        this.addBlock((Supplier)UGBlocks.CLOGGRUM_TILE_STAIRS, "Cloggrum Tile Stairs");
        this.addBlock((Supplier)UGBlocks.CLOGGRUM_TILE_SLAB, "Cloggrum Tile Slab");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_BED, "Depthrock Bed");
        this.addBlock((Supplier)UGBlocks.MOGMOSS_RUG, "Mogmoss Rug");
        this.addBlock((Supplier)UGBlocks.UNDERBEAN_BUSH, "Underbean Bush");
        this.addBlock((Supplier)UGBlocks.BLISTERBERRY_BUSH, "Blisterberry Bush");
        this.addBlock((Supplier)UGBlocks.DEEPTURF, "Deepturf");
        this.addBlock((Supplier)UGBlocks.ASHEN_DEEPTURF, "Ashen Deepturf");
        this.addBlock((Supplier)UGBlocks.FROZEN_DEEPTURF, "Frozen Deepturf");
        this.addBlock((Supplier)UGBlocks.TALL_DEEPTURF, "Tall Deepturf");
        this.addBlock((Supplier)UGBlocks.SHIMMERWEED, "Shimmerweed");
        this.addBlock((Supplier)UGBlocks.TALL_SHIMMERWEED, "Tall Shimmerweed");
        this.addBlock((Supplier)UGBlocks.DITCHBULB_PLANT, "Ditchbulb Plant");
        this.addBlock((Supplier)UGBlocks.GLOOMGOURD, "Gloomgourd");
        this.addBlock((Supplier)UGBlocks.CARVED_GLOOMGOURD, "Carved Gloomgourd");
        this.addBlock((Supplier)UGBlocks.GLOOM_O_LANTERN, "Gloom o'Lantern");
        this.addBlock((Supplier)UGBlocks.SHARD_O_LANTERN, "Shard o'Lantern");
        this.addBlock((Supplier)UGBlocks.GLOOMGOURD_STEM, "Gloomgourd Stem");
        this.addBlock((Supplier)UGBlocks.DEPTHROCK_PEBBLES, "Depthrock Pebbles");
        this.addBlock((Supplier)UGBlocks.GLOWING_KELP, "Glitterkelp");
        this.addBlock((Supplier)UGBlocks.GLOWING_KELP_PLANT, "Glitterkelp");
        this.addBlock((Supplier)UGBlocks.DROOPVINE_TOP, "Droopvine");
        this.addBlock((Supplier)UGBlocks.DROOPVINE, "Droopvine");
        this.addBlock((Supplier)UGBlocks.INDIGO_MUSHROOM, "Indigo Mushroom");
        this.addBlock((Supplier)UGBlocks.INDIGO_MUSHROOM_CAP, "Indigo Mushroom Cap");
        this.addBlock((Supplier)UGBlocks.INDIGO_MUSHROOM_STALK, "Indigo Mushroom Stalk");
        this.addBlock((Supplier)UGBlocks.VEIL_MUSHROOM, "Veiled Mushroom");
        this.addBlock((Supplier)UGBlocks.VEIL_MUSHROOM_CAP, "Veil Mushroom Cap");
        this.addBlock((Supplier)UGBlocks.VEIL_MUSHROOM_STALK, "Veil Mushroom Stalk");
        this.addBlock((Supplier)UGBlocks.MUSHROOM_VEIL, "Mushroom Veil");
        this.addBlock((Supplier)UGBlocks.MUSHROOM_VEIL_TOP, "Mushroom Veil");
        this.addBlock((Supplier)UGBlocks.INK_MUSHROOM, "Ink Mushroom");
        this.addBlock((Supplier)UGBlocks.INK_MUSHROOM_CAP, "Ink Mushroom Cap");
        this.addBlock((Supplier)UGBlocks.SEEPING_INK, "Seeping Ink");
        this.addBlock((Supplier)UGBlocks.BLOOD_MUSHROOM, "Blood Mushroom");
        this.addBlock((Supplier)UGBlocks.BLOOD_MUSHROOM_CAP, "Blood Mushroom Cap");
        this.addBlock((Supplier)UGBlocks.BLOOD_MUSHROOM_GLOBULE, "Blood Mushroom Globule");
        this.addBlock((Supplier)UGBlocks.BLOOD_MUSHROOM_STALK, "Blood Mushroom Stalk");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_SAPLING, "Smogstem Sapling");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_LOG, "Smogstem Log");
        this.addBlock((Supplier)UGBlocks.STRIPPED_SMOGSTEM_LOG, "Stripped Smogstem Log");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_WOOD, "Smogstem Wood");
        this.addBlock((Supplier)UGBlocks.STRIPPED_SMOGSTEM_WOOD, "Stripped Smogstem Wood");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_LEAVES, "Smogstem Leaves");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_PLANKS, "Smogstem Planks");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_STAIRS, "Smogstem Stairs");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_SLAB, "Smogstem Slab");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_FENCE, "Smogstem Fence");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_FENCE_GATE, "Smogstem Fence Gate");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_DOOR, "Smogstem Door");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_TRAPDOOR, "Smogstem Trapdoor");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_BUTTON, "Smogstem Button");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_PRESSURE_PLATE, "Smogstem Pressure Plate");
        this.addBlock((Supplier)UGBlocks.SMOGSTEM_SIGN, "Smogstem Sign");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_SAPLING, "Wigglewood Sapling");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_LOG, "Wigglewood Log");
        this.addBlock((Supplier)UGBlocks.STRIPPED_WIGGLEWOOD_LOG, "Stripped Wigglewood Log");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_WOOD, "Wigglewood.. Wood");
        this.addBlock((Supplier)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD, "Stripped Wigglewood Wood");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_LEAVES, "Wigglewood Leaves");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_PLANKS, "Wigglewood Planks");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_STAIRS, "Wigglewood Stairs");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_SLAB, "Wigglewood Slab");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_FENCE, "Wigglewood Fence");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_FENCE_GATE, "Wigglewood Fence Gate");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_DOOR, "Wigglewood Door");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_TRAPDOOR, "Wigglewood Trapdoor");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_BUTTON, "Wigglewood Button");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_PRESSURE_PLATE, "Wigglewood Pressure Plate");
        this.addBlock((Supplier)UGBlocks.WIGGLEWOOD_SIGN, "Wigglewood Sign");
        this.addBlock((Supplier)UGBlocks.GRONGLE_SAPLING, "Grongle Sapling");
        this.addBlock((Supplier)UGBlocks.GRONGLE_LOG, "Grongle Log");
        this.addBlock((Supplier)UGBlocks.STRIPPED_GRONGLE_LOG, "Stripped Grongle Log");
        this.addBlock((Supplier)UGBlocks.GRONGLE_WOOD, "Grongle Wood");
        this.addBlock((Supplier)UGBlocks.STRIPPED_GRONGLE_WOOD, "Stripped Grongle Wood");
        this.addBlock((Supplier)UGBlocks.GRONGLE_LEAVES, "Grongle Leaves");
        this.addBlock((Supplier)UGBlocks.HANGING_GRONGLE_LEAVES, "Hanging Grongle Leaves");
        this.addBlock((Supplier)UGBlocks.HANGING_GRONGLE_LEAVES_TOP, "Hanging Grongle Leaves");
        this.addBlock((Supplier)UGBlocks.GRONGLE_PLANKS, "Grongle Planks");
        this.addBlock((Supplier)UGBlocks.GRONGLE_STAIRS, "Grongle Stairs");
        this.addBlock((Supplier)UGBlocks.GRONGLE_SLAB, "Grongle Slab");
        this.addBlock((Supplier)UGBlocks.GRONGLE_FENCE, "Grongle Fence");
        this.addBlock((Supplier)UGBlocks.GRONGLE_FENCE_GATE, "Grongle Fence Gate");
        this.addBlock((Supplier)UGBlocks.GRONGLE_DOOR, "Grongle Door");
        this.addBlock((Supplier)UGBlocks.GRONGLE_TRAPDOOR, "Grongle Trapdoor");
        this.addBlock((Supplier)UGBlocks.GRONGLE_BUTTON, "Grongle Button");
        this.addBlock((Supplier)UGBlocks.GRONGLE_PRESSURE_PLATE, "Grongle Pressure Plate");
        this.addBlock((Supplier)UGBlocks.GRONGLE_SIGN, "Grongle Sign");
        this.addItem((Supplier)UGItems.MAMMOTH_DISC, "Music Disc");
        this.add(((Item)UGItems.MAMMOTH_DISC.get()).func_77658_a() + ".desc", "Screem - Mammoth");
        this.addItem((Supplier)UGItems.LIMAX_MAXIMUS_DISC, "Music Disc");
        this.add(((Item)UGItems.LIMAX_MAXIMUS_DISC.get()).func_77658_a() + ".desc", "Screem - Limax Maximus");
        this.addItem((Supplier)UGItems.RELICT_DISC, "Music Disc");
        this.add(((Item)UGItems.RELICT_DISC.get()).func_77658_a() + ".desc", "Screem - Relict");
        this.addItem((Supplier)UGItems.GLOOMPER_ANTHEM_DISC, "Music Disc");
        this.add(((Item)UGItems.GLOOMPER_ANTHEM_DISC.get()).func_77658_a() + ".desc", "Screem - Gloomper Anthem");
        this.addItem((Supplier)UGItems.GLOOMPER_SECRET_DISC, "Music Disc");
        this.add(((Item)UGItems.GLOOMPER_SECRET_DISC.get()).func_77658_a() + ".desc", "An AI was given an image of a Gloomper and made this song");
        this.addItem((Supplier)UGItems.CATALYST, "Catalyst");
        this.addItem((Supplier)UGItems.DEPTHROCK_PEBBLE, "Depthrock Pebble");
        this.addItem((Supplier)UGItems.TWISTYTWIG, "Twistytwig");
        this.addItem((Supplier)UGItems.CLOGGRUM_INGOT, "Cloggrum Ingot");
        this.addItem((Supplier)UGItems.CLOGGRUM_NUGGET, "Cloggrum Nugget");
        this.addItem((Supplier)UGItems.FROSTSTEEL_INGOT, "Froststeel Ingot");
        this.addItem((Supplier)UGItems.FROSTSTEEL_NUGGET, "Froststeel Nugget");
        this.addItem((Supplier)UGItems.UTHERIC_SHARD, "Utheric Shard");
        this.addItem((Supplier)UGItems.UTHERIUM_INGOT, "Utherium Ingot");
        this.addItem((Supplier)UGItems.UTHERIUM_CHUNK, "Utherium Nugget");
        this.addItem((Supplier)UGItems.REGALIUM_INGOT, "Regalium Ingot");
        this.addItem((Supplier)UGItems.REGALIUM_NUGGET, "Regalium Nugget");
        this.addItem((Supplier)UGItems.FORGOTTEN_INGOT, "Forgotten Ingot");
        this.addItem((Supplier)UGItems.FORGOTTEN_NUGGET, "Forgotten Nugget");
        this.addItem((Supplier)UGItems.GLOOMGOURD_SEEDS, "Gloomgourd Seeds");
        this.addItem((Supplier)UGItems.DITCHBULB, "Ditchbulb");
        this.addItem((Supplier)UGItems.BRUTE_TUSK, "Brute Tusk");
        this.addItem((Supplier)UGItems.MOGMOSS, "Mogmoss");
        this.addItem((Supplier)UGItems.GOO_BALL, "Scintling Goo Ball");
        this.addItem((Supplier)UGItems.ROTTEN_BLISTERBERRY, "Rotten Blisterberry");
        this.addItem((Supplier)UGItems.BLISTERBOMB, "Blisterbomb");
        this.addItem((Supplier)UGItems.UNDERBEAN_STICK, "Underbean on a Stick");
        this.addItem((Supplier)UGItems.MASTICATOR_SCALES, "Masticator Scales");
        this.addItem((Supplier)UGItems.MASTICATED_CHESTPLATE, "Masticated Chestplate");
        this.addItem((Supplier)UGItems.CLOGGRUM_BATTLEAXE, "Cloggrum Battle Axe");
        this.addItem((Supplier)UGItems.CLOGGRUM_SWORD, "Cloggrum Sword");
        this.addItem((Supplier)UGItems.CLOGGRUM_PICKAXE, "Cloggrum Pickaxe");
        this.addItem((Supplier)UGItems.CLOGGRUM_AXE, "Cloggrum Axe");
        this.addItem((Supplier)UGItems.CLOGGRUM_SHOVEL, "Cloggrum Shovel");
        this.addItem((Supplier)UGItems.CLOGGRUM_HOE, "Cloggrum Hoe");
        this.addItem((Supplier)UGItems.CLOGGRUM_SHIELD, "Cloggrum Shield");
        this.addItem((Supplier)UGItems.FROSTSTEEL_SWORD, "Froststeel Sword");
        this.addItem((Supplier)UGItems.FROSTSTEEL_PICKAXE, "Froststeel Pickaxe");
        this.addItem((Supplier)UGItems.FROSTSTEEL_AXE, "Froststeel Axe");
        this.addItem((Supplier)UGItems.FROSTSTEEL_SHOVEL, "Froststeel Shovel");
        this.addItem((Supplier)UGItems.FROSTSTEEL_HOE, "Froststeel Hoe");
        this.addItem((Supplier)UGItems.UTHERIUM_SWORD, "Utherium Sword");
        this.addItem((Supplier)UGItems.UTHERIUM_PICKAXE, "Utherium Pickaxe");
        this.addItem((Supplier)UGItems.UTHERIUM_AXE, "Utherium Axe");
        this.addItem((Supplier)UGItems.UTHERIUM_SHOVEL, "Utherium Shovel");
        this.addItem((Supplier)UGItems.UTHERIUM_HOE, "Utherium Hoe");
        this.addItem((Supplier)UGItems.FORGOTTEN_BATTLEAXE, "Forgotten Battle Axe");
        this.addItem((Supplier)UGItems.FORGOTTEN_SWORD, "Forgotten Sword");
        this.addItem((Supplier)UGItems.FORGOTTEN_PICKAXE, "Forgotten Pickaxe");
        this.addItem((Supplier)UGItems.FORGOTTEN_AXE, "Forgotten Axe");
        this.addItem((Supplier)UGItems.FORGOTTEN_SHOVEL, "Forgotten Shovel");
        this.addItem((Supplier)UGItems.FORGOTTEN_HOE, "Forgotten Hoe");
        this.addItem((Supplier)UGItems.SMOGSTEM_BOAT, "Smogstem Boat");
        this.addItem((Supplier)UGItems.WIGGLEWOOD_BOAT, "Wigglewood Boat");
        this.addItem((Supplier)UGItems.GRONGLE_BOAT, "Grongle Boat");
        this.addItem((Supplier)UGItems.SLINGSHOT, "Slingshot");
        this.addItem((Supplier)UGItems.VIRULENT_MIX_BUCKET, "Virulent Mix Bucket");
        this.addItem((Supplier)UGItems.GWIBLING_BUCKET, "Bucket of Gwibling");
        this.addItem((Supplier)UGItems.CLOGGRUM_HELMET, "Cloggrum Helmet");
        this.addItem((Supplier)UGItems.CLOGGRUM_CHESTPLATE, "Cloggrum Chestplate");
        this.addItem((Supplier)UGItems.CLOGGRUM_LEGGINGS, "Cloggrum Leggings");
        this.addItem((Supplier)UGItems.CLOGGRUM_BOOTS, "Cloggrum Boots");
        this.addItem((Supplier)UGItems.FROSTSTEEL_HELMET, "Froststeel Helmet");
        this.addItem((Supplier)UGItems.FROSTSTEEL_CHESTPLATE, "Froststeel Chestplate");
        this.addItem((Supplier)UGItems.FROSTSTEEL_LEGGINGS, "Froststeel Leggings");
        this.addItem((Supplier)UGItems.FROSTSTEEL_BOOTS, "Froststeel Boots");
        this.addItem((Supplier)UGItems.UTHERIUM_HELMET, "Utherium Helmet");
        this.addItem((Supplier)UGItems.UTHERIUM_CHESTPLATE, "Utherium Chestplate");
        this.addItem((Supplier)UGItems.UTHERIUM_LEGGINGS, "Utherium Leggings");
        this.addItem((Supplier)UGItems.UTHERIUM_BOOTS, "Utherium Boots");
        this.addItem((Supplier)UGItems.DROOPFRUIT, "Droopfruit");
        this.addItem((Supplier)UGItems.UNDERBEANS, "Underbeans");
        this.addItem((Supplier)UGItems.ROASTED_UNDERBEANS, "Roasted Underbeans");
        this.addItem((Supplier)UGItems.BLISTERBERRY, "Blisterberry");
        this.addItem((Supplier)UGItems.GLOOMGOURD_PIE, "Gloomgourd Pie");
        this.addItem((Supplier)UGItems.RAW_DWELLER_MEAT, "Raw Dweller Meat");
        this.addItem((Supplier)UGItems.DWELLER_STEAK, "Dweller Steak");
        this.addItem((Supplier)UGItems.RAW_GWIBLING, "Raw Gwibling");
        this.addItem((Supplier)UGItems.COOKED_GWIBLING, "Cooked Gwibling");
        this.addItem((Supplier)UGItems.RAW_GLOOMPER_LEG, "Raw Gloomper Leg");
        this.addItem((Supplier)UGItems.GLOOMPER_LEG, "Gloomper Leg");
        this.addItem((Supplier)UGItems.BLOODY_STEW, "Bloody Stew");
        this.addItem((Supplier)UGItems.INDIGO_STEW, "Indigo Stew");
        this.addItem((Supplier)UGItems.INKY_STEW, "Inky Stew");
        this.addItem((Supplier)UGItems.VEILED_STEW, "Veiled Stew");
        this.addItem((Supplier)UGItems.DWELLER_SPAWN_EGG, "Dweller Spawn Egg");
        this.addItem((Supplier)UGItems.GWIBLING_SPAWN_EGG, "Gwibling Spawn Egg");
        this.addItem((Supplier)UGItems.ROTLING_SPAWN_EGG, "Rotling Spawn Egg");
        this.addItem((Supplier)UGItems.ROTWALKER_SPAWN_EGG, "Rotwalker Spawn Egg");
        this.addItem((Supplier)UGItems.ROTBEAST_SPAWN_EGG, "Rotbeast Spawn Egg");
        this.addItem((Supplier)UGItems.BRUTE_SPAWN_EGG, "Brute Spawn Egg");
        this.addItem((Supplier)UGItems.SCINTLING_SPAWN_EGG, "Scintling Spawn Egg");
        this.addItem((Supplier)UGItems.GLOOMPER_SPAWN_EGG, "Gloomper Spawn Egg");
        this.addItem((Supplier)UGItems.STONEBORN_SPAWN_EGG, "Stoneborn Spawn Egg");
        this.addItem((Supplier)UGItems.NARGOYLE_SPAWN_EGG, "Nargoyle Spawn Egg");
        this.addItem((Supplier)UGItems.MUNCHER_SPAWN_EGG, "Muncher Spawn Egg");
        this.addItem((Supplier)UGItems.SPLOOGIE_SPAWN_EGG, "Sploogie Spawn Egg");
        this.addItem((Supplier)UGItems.GWIB_SPAWN_EGG, "Gwib Spawn Egg");
        this.addItem((Supplier)UGItems.MOG_SPAWN_EGG, "Mog Spawn Egg");
        this.addItem((Supplier)UGItems.MASTICATOR_SPAWN_EGG, "Masticator Spawn Egg");
        this.addItem((Supplier)UGItems.FORGOTTEN_GUARDIAN_SPAWN_EGG, "Forgotten Guardian Spawn Egg");
        this.addBiome(UGBiomes.BARREN_ABYSS, "Barren Abyss");
        this.addBiome(UGBiomes.DENSE_FOREST, "Dense Forest");
        this.addBiome(UGBiomes.FORGOTTEN_FIELD, "Forgotten Field");
        this.addBiome(UGBiomes.FROSTFIELDS, "Frostfields");
        this.addBiome(UGBiomes.GRONGLEGROWTH, "Gronglegrowth");
        this.addBiome(UGBiomes.MUSHROOM_BOG, "Mushroom Bog");
        this.addBiome(UGBiomes.SMOGSTEM_FOREST, "Smogstem Forest");
        this.addBiome(UGBiomes.SMOG_SPIRES, "Smog Spires");
        this.addBiome(UGBiomes.WIGGLEWOOD_FOREST, "Wigglewood Forest");
        this.addEntityType((Supplier)UGEntityTypes.BOAT, "Undergarden Boat");
        this.addEntityType((Supplier)UGEntityTypes.MINION, "Forgotten Minion");
        this.addEntityType((Supplier)UGEntityTypes.DWELLER, "Dweller");
        this.addEntityType((Supplier)UGEntityTypes.GWIBLING, "Gwibling");
        this.addEntityType((Supplier)UGEntityTypes.ROTLING, "Rotling");
        this.addEntityType((Supplier)UGEntityTypes.ROTWALKER, "Rotwalker");
        this.addEntityType((Supplier)UGEntityTypes.ROTBEAST, "Rotbeast");
        this.addEntityType((Supplier)UGEntityTypes.BRUTE, "Brute");
        this.addEntityType((Supplier)UGEntityTypes.SCINTLING, "Scintling");
        this.addEntityType((Supplier)UGEntityTypes.GLOOMPER, "Gloomper");
        this.addEntityType((Supplier)UGEntityTypes.STONEBORN, "Stoneborn");
        this.addEntityType((Supplier)UGEntityTypes.NARGOYLE, "Nargoyle");
        this.addEntityType((Supplier)UGEntityTypes.MUNCHER, "Muncher");
        this.addEntityType((Supplier)UGEntityTypes.SPLOOGIE, "Sploogie");
        this.addEntityType((Supplier)UGEntityTypes.GWIB, "Gwib");
        this.addEntityType((Supplier)UGEntityTypes.MOG, "Mog");
        this.addEntityType((Supplier)UGEntityTypes.MASTICATOR, "Masticator");
        this.addEntityType((Supplier)UGEntityTypes.FORGOTTEN_GUARDIAN, "Forgotten Guardian");
        this.addItemGroup(UGItemGroups.GROUP, "The Undergarden");
        this.addEffect((Supplier)UGEffects.GOOEY, "Gooey");
        this.addEffect((Supplier)UGEffects.BRITTLENESS, "Brittleness");
        this.addEffect((Supplier)UGEffects.FEATHERWEIGHT, "Featherweight");
        this.addEffect((Supplier)UGEffects.VIRULENT_RESISTANCE, "Virulent Resistance");
        this.addPotion((Supplier<? extends Potion>)UGPotions.BRITTLENESS, "Brittleness");
        this.addPotion((Supplier<? extends Potion>)UGPotions.FEATHERWEIGHT, "Featherweight");
        this.addPotion((Supplier<? extends Potion>)UGPotions.VIRULENT_RESISTANCE, "Virulent Resistance");
        this.addPotion((Supplier<? extends Potion>)UGPotions.GLOWING, "Glowing");
        this.addAdvTitle("undergarden_root", "The Undergarden");
        this.addAdvTitle("catalyst", "One Ticket Please");
        this.addAdvDesc("catalyst", "Create the Catalyst.");
        this.addAdvTitle("undergarden", "Enter the Undergarden");
        this.addAdvDesc("undergarden", "The forgotten land awaits...");
        this.addAdvTitle("64gloomgourds", "Gourd Lord");
        this.addAdvDesc("64gloomgourds", "Acquire a stack of Gloomgourds.");
        this.addAdvTitle("slingshot", "Your New Best Friend");
        this.addAdvDesc("slingshot", "Craft a Slingshot.");
        this.addAdvTitle("shoot_slingshot", "Flinging Rocks");
        this.addAdvDesc("shoot_slingshot", "Shoot a pebble at something.");
        this.addAdvTitle("slay_rotling", "Birth Control");
        this.addAdvDesc("slay_rotling", "Slay the weakest of the Rotspawn, the Rotling.");
        this.addAdvTitle("shard_torch", "Warding Device");
        this.addAdvDesc("shard_torch", "Craft a Shard Torch, a torch that can damage Rotspawn in its vicinity.");
        this.addAdvTitle("slay_all_rotspawn", "Rotbane");
        this.addAdvDesc("slay_all_rotspawn", "Slay all kinds of Rotspawn.");
        this.addAdvTitle("all_undergarden_biomes", "Subterranean Cartographer");
        this.addAdvDesc("all_undergarden_biomes", "Discover every Undergarden biome.");
        this.addAdvTitle("any_ore", "Deep Extraction");
        this.addAdvDesc("any_ore", "Acquire any Undergarden ore.");
        this.addAdvTitle("underbeans", "Glorious Beans!");
        this.addAdvDesc("underbeans", "Find and pick an Underbean Bush.");
        this.addAdvTitle("trade_with_stoneborn", "Interdimensional Business");
        this.addAdvDesc("trade_with_stoneborn", "Trade with a Stoneborn.");
        this.addAdvTitle("catch_gwibling", "Weird Fish");
        this.addAdvDesc("catch_gwibling", "Catch a Gwibling with a bucket.");
        this.addAdvTitle("catacombs", "Forgotten Halls");
        this.addAdvDesc("catacombs", "Enter some Catacombs.");
        this.addAdvTitle("plant_gloomgourd", "Purple Pumpkins");
        this.addAdvDesc("plant_gloomgourd", "Plant a Gloomgourd seed.");
        this.addAdvTitle("slay_forgotten_guardian", "Decommissioned");
        this.addAdvDesc("slay_forgotten_guardian", "Slay a Forgotten Guardian.");
        this.addAdvTitle("forgotten_ingot", "What Now Is");
        this.addAdvDesc("forgotten_ingot", "Forge a Forgotten Ingot from a Forgotten Guardian's nuggets.");
        this.addAdvTitle("forgotten_tools", "Forgotten Arsenal");
        this.addAdvDesc("forgotten_tools", "Use Forgotten Ingots to upgrade Cloggrum tools and make all 5 Forgotten tools.");
        this.addAdvTitle("slay_scintling", "Terrible Person");
        this.addAdvDesc("slay_scintling", "You killed an innocent Scintling. You monster...");
        this.addAdvTitle("summon_minion", "Buildin' a Sentry");
        this.addAdvDesc("summon_minion", "Create a Forgotten Minion using a Forgotten Block and a Carved Gloomgourd.");
        this.addAdvTitle("cloggrum_armor", "Cover Me in Coprolites");
        this.addAdvDesc("cloggrum_armor", "Obtain a full suit of Cloggrum armor.");
        this.addAdvTitle("all_blocks", "Collector's Edition");
        this.addAdvDesc("all_blocks", "Collect one block of every Undergarden ore.");
        this.addAdvTitle("gloomper_secret_disc", "Death Gloomps");
        this.addAdvDesc("gloomper_secret_disc", "Obtain the secret music disc.");
        this.addAdvTitle("forgotten_battleaxe", "Axe of Legends");
        this.addAdvDesc("forgotten_battleaxe", "Upgrade a Cloggrum Battle Axe with a Forgotten Ingot.");
        this.addAdvTitle("otherside_root", "The Otherside");
        this.addAdvDesc("otherside_root", "Enter the realm of madness.");
        this.add("tooltip.froststeel_sword", "Slows targets.");
        this.add("tooltip.utheric_sword", "Deals 1.5x damage to Rotspawn.");
        this.add("tooltip.slingshot", "Uses Depthrock Pebbles as ammo.");
        this.add("tooltip.cloggrum_boots", "Scintling Goo doesn't slow you down when worn.");
        this.add("tooltip.forgotten_sword", "Deals 2x damage to non-boss Undergarden mobs.");
        this.add("tooltip.pebble", "Can be used as Slingshot ammo.");
        this.add("tooltip.forgotten_tool", "Mines Undergarden blocks 1.5x as fast.");
        this.addSubtitle("item", "blisterbomb", "Blisterbomb thrown");
        this.addSubtitle("item", "slingshot_draw", "Slingshot drawn");
        this.addSubtitle("item", "slingshot_shoot", "Slingshot fired");
        this.addSubtitle("item", "blisterberry_bush_pick_berries", "Blisterberry Bush picked");
        this.addSubtitle("block", "undergarden_portal_ambient", "Undergarden Portal beckons");
        this.addSubtitle("block", "undergarden_portal_activate", "Undergarden Portal activates");
        this.addSubtitle("block", "undergarden_portal_travel", "Travelling through Undergarden portal");
        this.addSubtitle("entity", "dweller_ambient", "Dweller grumbles");
        this.addSubtitle("entity", "dweller_hurt", "Dweller hurts");
        this.addSubtitle("entity", "dweller_death", "Dweller dies");
        this.addSubtitle("entity", "dweller_step", "Dweller steps");
        this.addSubtitle("entity", "rotwalker_ambient", "Rotwalker groans");
        this.addSubtitle("entity", "rotwalker_hurt", "Rotwalker hurts");
        this.addSubtitle("entity", "rotwalker_death", "Rotwalker dies");
        this.addSubtitle("entity", "rotwalker_step", "Rotwalker steps");
        this.addSubtitle("entity", "rotbeast_ambient", "Rotbeast groans");
        this.addSubtitle("entity", "rotbeast_hurt", "Rotbeast hurts");
        this.addSubtitle("entity", "rotbeast_death", "Rotbeast dies");
        this.addSubtitle("entity", "rotbeast_step", "Rotbeast steps");
        this.addSubtitle("entity", "rotbeast_attack", "Rotbeast attacks");
        this.addSubtitle("entity", "brute_ambient", "Brute exhales");
        this.addSubtitle("entity", "brute_hurt", "Brute hurts");
        this.addSubtitle("entity", "brute_death", "Brute dies");
        this.addSubtitle("entity", "gloomper_ambient", "Gloomper croaks");
        this.addSubtitle("entity", "gloomper_hurt", "Gloomper hurts");
        this.addSubtitle("entity", "gloomper_death", "Gloomper dies");
        this.addSubtitle("entity", "gloomper_hop", "Gloomper hops");
        this.addSubtitle("entity", "gloomper_fart", "Gloomper farts");
        this.addSubtitle("entity", "stoneborn_step", "Stoneborn steps");
        this.addSubtitle("entity", "stoneborn_speaking", "Stoneborn speaks");
        this.addSubtitle("entity", "stoneborn_pleased", "Stoneborn pleased");
        this.addSubtitle("entity", "stoneborn_hurt", "Stoneborn hurts");
        this.addSubtitle("entity", "stoneborn_angry", "Stoneborn angered");
        this.addSubtitle("entity", "stoneborn_confused", "Stoneborn confused");
        this.addSubtitle("entity", "stoneborn_chant", "Stoneborn chanting");
        this.addSubtitle("entity", "stoneborn_death", "Stoneborn dies");
        this.addSubtitle("entity", "rotling_ambient", "Rotling groans");
        this.addSubtitle("entity", "rotling_hurt", "Rotling hurts");
        this.addSubtitle("entity", "rotling_death", "Rotling dies");
        this.addSubtitle("entity", "rotling_step", "Rotling steps");
        this.addSubtitle("entity", "forgotten_guardian_ambient", "Forgotten Guardian creaks");
        this.addSubtitle("entity", "forgotten_guardian_hurt", "Forgotten Guardian hurts");
        this.addSubtitle("entity", "forgotten_guardian_death", "Forgotten Guardian dies");
        this.addSubtitle("entity", "forgotten_guardian_attack", "Forgotten Guardian attacks");
        this.addSubtitle("entity", "forgotten_guardian_deflect", "Forgotten Guardian deflects");
        this.addSubtitle("entity", "forgotten_guardian_step", "Forgotten Guardian steps");
        this.addSubtitle("entity", "minion_shoot", "Forgotten Minion shoots");
        this.addSubtitle("entity", "minion_death", "Forgotten Minion dies");
        this.addSubtitle("entity", "minion_repair", "Forgotten Minion repaired");
        this.addSubtitle("entity", "nargoyle_hurt", "Nargoyle hurts");
        this.addSubtitle("entity", "nargoyle_death", "Nargoyle dies");
        this.addSubtitle("entity", "nargoyle_attack", "Nargoyle leaps");
        this.addSubtitle("entity", "muncher_ambient", "Muncher grumbles");
        this.addSubtitle("entity", "muncher_hurt", "Muncher hurts");
        this.addSubtitle("entity", "muncher_death", "Muncher dies");
        this.addSubtitle("entity", "muncher_chew", "Muncher chews");
        this.addSubtitle("entity", "sploogie_ambient", "Sploogie squeaks");
        this.addSubtitle("entity", "sploogie_hurt", "Sploogie hurts");
        this.addSubtitle("entity", "sploogie_death", "Sploogie dies");
        this.addSubtitle("entity", "sploogie_spit", "Sploogie spits");
        this.addSubtitle("entity", "masticator_ambient", "Masticator roars");
        this.addSubtitle("entity", "masticator_hurt", "Masticator hurts");
        this.addSubtitle("entity", "masticator_death", "Masticator dies");
        this.addSubtitle("entity", "masticator_eat", "Masticator eats");
        this.addSubtitle("entity", "masticator_step", "Masticator steps");
        this.addSubtitle("entity", "gwib_hurt", "Gwib hurts");
        this.addSubtitle("entity", "gwib_death", "Gwib dies");
        this.addSubtitle("entity", "gwib_flop", "Gwib flops");
        this.addSubtitle("entity", "gwibling_hurt", "Gwibling hurts");
        this.addSubtitle("entity", "gwibling_death", "Gwibling dies");
        this.addSubtitle("entity", "gwibling_flop", "Gwibling flops");
        this.addSubtitle("entity", "mog_ambient", "Mog squeaks");
        this.addSubtitle("entity", "mog_hurt", "Mog hurts");
        this.addSubtitle("entity", "mog_death", "Mog dies");
        this.addDeath("blisterberry_bush", "%1$s was poked by a Blisterberry Bush");
        this.addDeath("blisterberry_bush.player", "%1$s was poked by a Blisterberry Bush whilst trying to escape %2$s");
        this.addDeath("shard_torch", "%1$s was killed by a Shard Torch's magic");
        this.addDeath("shard_torch.player", "%1$s was killed by a Shard Torch's magic whilst trying to escape %2$s");
    }
}

