/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import quek.undergarden.registry.UGBlocks;

public class FrostfieldsSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    public FrostfieldsSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void apply(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState top, BlockState middle, BlockState bottom, int sealevel) {
        BlockState topBlock = top;
        BlockState middleBlock = middle;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int i = -1;
        int basin = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        for (int y = startHeight; y >= 0; --y) {
            pos.func_181079_c(xPos, y, zPos);
            BlockState blockstate2 = chunkIn.func_180495_p((BlockPos)pos);
            if (blockstate2.func_196958_f()) {
                i = -1;
            } else if (blockstate2.func_203425_a(defaultBlock.func_177230_c())) {
                if (i == -1) {
                    if (basin <= 0) {
                        topBlock = Blocks.field_150350_a.func_176223_P();
                        middleBlock = defaultBlock;
                    } else if (y >= sealevel - 4 && y <= sealevel + 1) {
                        topBlock = top;
                        middleBlock = middle;
                    }
                    if (y < sealevel && (topBlock == null || topBlock.func_196958_f())) {
                        topBlock = Blocks.field_150432_aD.func_176223_P();
                        pos.func_181079_c(xPos, y, zPos);
                    }
                    i = basin;
                    if (y >= sealevel - 1) {
                        chunkIn.func_177436_a((BlockPos)pos, topBlock, false);
                    } else if (y < sealevel - 7 - basin) {
                        topBlock = Blocks.field_150350_a.func_176223_P();
                        middleBlock = defaultBlock;
                        chunkIn.func_177436_a((BlockPos)pos, bottom, false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)pos, middleBlock, false);
                    }
                } else if (i > 0) {
                    --i;
                    chunkIn.func_177436_a((BlockPos)pos, middleBlock, false);
                }
            }
            if (chunkIn.func_180495_p((BlockPos)pos).func_203425_a(defaultBlock.func_177230_c())) {
                chunkIn.func_177436_a((BlockPos)pos, ((Block)UGBlocks.SHIVERSTONE.get()).func_176223_P(), false);
            }
            if (!chunkIn.func_180495_p((BlockPos)pos).func_203425_a(Blocks.field_150355_j)) continue;
            chunkIn.func_177436_a((BlockPos)pos, Blocks.field_150432_aD.func_176223_P(), false);
        }
    }
}

