/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class PotionEvent
extends LivingEvent {
    @Nullable
    protected final EffectInstance effect;

    public PotionEvent(LivingEntity living, EffectInstance effect) {
        super(living);
        this.effect = effect;
    }

    @Nullable
    public EffectInstance getPotionEffect() {
        return this.effect;
    }

    public static class PotionExpiryEvent
    extends PotionEvent {
        public PotionExpiryEvent(LivingEntity living, EffectInstance effect) {
            super(living, effect);
        }
    }

    public static class PotionAddedEvent
    extends PotionEvent {
        private final EffectInstance oldEffect;

        public PotionAddedEvent(LivingEntity living, EffectInstance oldEffect, EffectInstance newEffect) {
            super(living, newEffect);
            this.oldEffect = oldEffect;
        }

        @Override
        @Nonnull
        public EffectInstance getPotionEffect() {
            return super.getPotionEffect();
        }

        @Nullable
        public EffectInstance getOldPotionEffect() {
            return this.oldEffect;
        }
    }

    @Event.HasResult
    public static class PotionApplicableEvent
    extends PotionEvent {
        public PotionApplicableEvent(LivingEntity living, EffectInstance effect) {
            super(living, effect);
        }

        @Override
        @Nonnull
        public EffectInstance getPotionEffect() {
            return super.getPotionEffect();
        }
    }

    @Cancelable
    public static class PotionRemoveEvent
    extends PotionEvent {
        private final Effect potion;

        public PotionRemoveEvent(LivingEntity living, Effect potion) {
            super(living, living.func_70660_b(potion));
            this.potion = potion;
        }

        public PotionRemoveEvent(LivingEntity living, EffectInstance effect) {
            super(living, effect);
            this.potion = effect.func_188419_a();
        }

        public Effect getPotion() {
            return this.potion;
        }

        @Override
        @Nullable
        public EffectInstance getPotionEffect() {
            return super.getPotionEffect();
        }
    }
}

