/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.core.materials.BasicData;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;

public class KineticData
extends BasicData {
    private float x;
    private float y;
    private float z;
    private float rotationalSpeed;
    private float rotationOffset;

    protected KineticData(Instancer<?> owner) {
        super(owner);
    }

    public KineticData setPosition(BlockPos pos) {
        return this.setPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public KineticData setPosition(Vector3f pos) {
        return this.setPosition(pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c());
    }

    public KineticData setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.markDirty();
        return this;
    }

    public KineticData nudge(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.markDirty();
        return this;
    }

    public KineticData setColor(KineticTileEntity te) {
        if (te.hasNetwork()) {
            this.setColor(Color.generateFromLong(te.network));
        } else {
            this.setColor(255, 255, 255);
        }
        return this;
    }

    public KineticData setColor(Color c) {
        this.setColor(c.getRed(), c.getGreen(), c.getBlue());
        return this;
    }

    public KineticData setRotationalSpeed(float rotationalSpeed) {
        this.rotationalSpeed = rotationalSpeed;
        return this;
    }

    public KineticData setRotationOffset(float rotationOffset) {
        this.rotationOffset = rotationOffset;
        return this;
    }

    public void write(MappedBuffer buf) {
        super.write(buf);
        buf.putFloatArray(new float[]{this.x, this.y, this.z, this.rotationalSpeed, this.rotationOffset});
    }
}

