/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.particle.AirParticle;
import com.simibubi.create.content.contraptions.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AirParticleData
implements IParticleData,
ICustomParticleDataWithSprite<AirParticleData> {
    public static final Codec<AirParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("drag").forGetter(p -> Float.valueOf(p.drag)), (App)Codec.FLOAT.fieldOf("speed").forGetter(p -> Float.valueOf(p.speed))).apply((Applicative)i, AirParticleData::new));
    public static final IParticleData.IDeserializer<AirParticleData> DESERIALIZER = new IParticleData.IDeserializer<AirParticleData>(){

        public AirParticleData fromCommand(ParticleType<AirParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float drag = reader.readFloat();
            reader.expect(' ');
            float speed = reader.readFloat();
            return new AirParticleData(drag, speed);
        }

        public AirParticleData fromNetwork(ParticleType<AirParticleData> particleTypeIn, PacketBuffer buffer) {
            return new AirParticleData(buffer.readFloat(), buffer.readFloat());
        }
    };
    float drag;
    float speed;

    public AirParticleData(float drag, float speed) {
        this.drag = drag;
        this.speed = speed;
    }

    public AirParticleData() {
        this(0.0f, 0.0f);
    }

    public ParticleType<?> func_197554_b() {
        return AllParticleTypes.AIR.get();
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.drag);
        buffer.writeFloat(this.speed);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %f %f", AllParticleTypes.AIR.parameter(), Float.valueOf(this.drag), Float.valueOf(this.speed));
    }

    @Override
    public IParticleData.IDeserializer<AirParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<AirParticleData> getCodec(ParticleType<AirParticleData> type) {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ParticleManager.IParticleMetaFactory<AirParticleData> getMetaFactory() {
        return AirParticle.Factory::new;
    }
}

