/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ToolboxInventory
extends ItemStackHandler {
    public static final int STACKS_PER_COMPARTMENT = 4;
    List<ItemStack> filters;
    boolean settling;
    private ToolboxTileEntity te;
    private boolean limitedMode;

    public ToolboxInventory(ToolboxTileEntity te) {
        super(32);
        this.te = te;
        this.limitedMode = false;
        this.filters = new ArrayList<ItemStack>();
        this.settling = false;
        for (int i = 0; i < 8; ++i) {
            this.filters.add(ItemStack.field_190927_a);
        }
    }

    public void inLimitedMode(Consumer<ToolboxInventory> action) {
        this.limitedMode = true;
        action.accept(this);
        this.limitedMode = false;
    }

    public void settle(int compartment) {
        int i;
        int totalCount = 0;
        boolean valid = true;
        boolean shouldBeEmpty = false;
        ItemStack sample = ItemStack.field_190927_a;
        for (i = 0; i < 4; ++i) {
            ItemStack stackInSlot = this.getStackInSlot(compartment * 4 + i);
            totalCount += stackInSlot.func_190916_E();
            if (!shouldBeEmpty) {
                shouldBeEmpty = stackInSlot.func_190926_b() || stackInSlot.func_190916_E() != stackInSlot.func_77976_d();
                continue;
            }
            if (stackInSlot.func_190926_b()) continue;
            valid = false;
            sample = stackInSlot;
        }
        if (valid) {
            return;
        }
        this.settling = true;
        if (!sample.func_77985_e()) {
            block1: for (i = 0; i < 4; ++i) {
                if (!this.getStackInSlot(compartment * 4 + i).func_190926_b()) continue;
                for (int j = i + 1; j < 4; ++j) {
                    ItemStack stackInSlot = this.getStackInSlot(compartment * 4 + j);
                    if (stackInSlot.func_190926_b()) continue;
                    this.setStackInSlot(compartment * 4 + i, stackInSlot);
                    this.setStackInSlot(compartment * 4 + j, ItemStack.field_190927_a);
                    continue block1;
                }
            }
        } else {
            for (i = 0; i < 4; ++i) {
                ItemStack copy = totalCount <= 0 ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)sample, (int)Math.min(totalCount, sample.func_77976_d()));
                this.setStackInSlot(compartment * 4 + i, copy);
                totalCount -= copy.func_190916_E();
            }
        }
        this.settling = false;
        this.te.sendData();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        BlockItem blockItem;
        if (AllTags.AllItemTags.TOOLBOXES.matches(stack)) {
            return false;
        }
        if (stack.func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock) {
            return false;
        }
        if (slot < 0 || slot >= this.getSlots()) {
            return false;
        }
        int compartment = slot / 4;
        ItemStack filter = this.filters.get(compartment);
        if (this.limitedMode && filter.func_190926_b()) {
            return false;
        }
        if (filter.func_190926_b() || ToolboxInventory.canItemsShareCompartment(filter, stack)) {
            return super.isItemValid(slot, stack);
        }
        return false;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        int compartment = slot / 4;
        if (!stack.func_190926_b() && this.filters.get(compartment).func_190926_b()) {
            this.filters.set(compartment, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            this.te.sendData();
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack insertItem = super.insertItem(slot, stack, simulate);
        if (insertItem.func_190916_E() != stack.func_190916_E()) {
            int compartment = slot / 4;
            if (!stack.func_190926_b() && this.filters.get(compartment).func_190926_b()) {
                this.filters.set(compartment, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                this.te.sendData();
            }
        }
        return insertItem;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_218657_a("Compartments", (INBT)NBTHelper.writeItemList(this.filters));
        return compound;
    }

    protected void onContentsChanged(int slot) {
        if (!this.settling && !this.te.getWorld().field_72995_K) {
            this.settle(slot / 4);
        }
        this.te.sendData();
        super.onContentsChanged(slot);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.filters = NBTHelper.readItemList(nbt.func_150295_c("Compartments", 10));
        if (this.filters.size() != 8) {
            this.filters.clear();
            for (int i = 0; i < 8; ++i) {
                this.filters.add(ItemStack.field_190927_a);
            }
        }
        super.deserializeNBT(nbt);
    }

    public ItemStack distributeToCompartment(@Nonnull ItemStack stack, int compartment, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (this.filters.get(compartment).func_190926_b()) {
            return stack;
        }
        for (int i = 3; i >= 0; --i) {
            int slot = compartment * 4 + i;
            if (!(stack = this.insertItem(slot, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack takeFromCompartment(int amount, int compartment, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        int remaining = amount;
        ItemStack lastValid = ItemStack.field_190927_a;
        for (int i = 3; i >= 0; --i) {
            int slot = compartment * 4 + i;
            ItemStack extracted = this.extractItem(slot, remaining, simulate);
            remaining -= extracted.func_190916_E();
            if (!extracted.func_190926_b()) {
                lastValid = extracted;
            }
            if (remaining != 0) continue;
            return ItemHandlerHelper.copyStackWithSize((ItemStack)lastValid, (int)amount);
        }
        if (remaining == amount) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)lastValid, (int)(amount - remaining));
    }

    public static ItemStack cleanItemNBT(ItemStack stack) {
        if (AllItems.BELT_CONNECTOR.isIn(stack)) {
            stack.func_196083_e("FirstPulley");
        }
        return stack;
    }

    public static boolean canItemsShareCompartment(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77985_e() && !stack2.func_77985_e() && stack1.func_77984_f() && stack2.func_77984_f()) {
            return stack1.func_77973_b() == stack2.func_77973_b();
        }
        if (AllItems.BELT_CONNECTOR.isIn(stack1) && AllItems.BELT_CONNECTOR.isIn(stack2)) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2);
    }
}

