/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.curiosities.toolbox.ToolboxContainer;
import com.simibubi.create.content.curiosities.toolbox.ToolboxDisposeAllPacket;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class ToolboxScreen
extends AbstractSimiContainerScreen<ToolboxContainer> {
    AllGuiTextures BG = AllGuiTextures.TOOLBOX;
    AllGuiTextures PLAYER = AllGuiTextures.PLAYER_INVENTORY;
    protected Slot hoveredToolboxSlot;
    private IconButton confirmButton;
    private IconButton disposeButton;
    private DyeColor color;
    private List<Rectangle2d> extraAreas = Collections.emptyList();

    public ToolboxScreen(ToolboxContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.func_231160_c_();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.widgets.clear();
        this.setWindowSize(this.BG.width, 256);
        this.confirmButton = new IconButton(this.getGuiLeft() + this.BG.width - 23, this.getGuiTop() + this.BG.height - 24, AllIcons.I_CONFIRM);
        this.disposeButton = new IconButton(this.getGuiLeft() + 91, this.getGuiTop() + 69, AllIcons.I_TOOLBOX);
        this.disposeButton.setToolTip((ITextComponent)Lang.translate("toolbox.depositBox", new Object[0]));
        this.widgets.add(this.confirmButton);
        this.widgets.add(this.disposeButton);
        this.color = ((ToolboxTileEntity)((ToolboxContainer)this.field_147002_h).contentHolder).getColor();
        this.extraAreas = ImmutableList.of((Object)new Rectangle2d(this.getGuiLeft() + -28, this.getGuiTop() + 141, 80, 100), (Object)new Rectangle2d(this.getGuiLeft() + 162, this.getGuiTop() + 111, 100, 70));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ((ToolboxContainer)this.field_147002_h).renderPass = true;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ((ToolboxContainer)this.field_147002_h).renderPass = false;
    }

    public void func_230926_e_(int p_230926_1_) {
        super.func_230926_e_(p_230926_1_);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.BG.draw(ms, (AbstractGui)this, this.field_147003_i + 10, this.field_147009_r);
        this.PLAYER.draw(ms, (AbstractGui)this, this.field_147003_i + (this.BG.width - this.PLAYER.width) / 2 - 26, this.field_147009_r + this.field_147000_g - this.PLAYER.height);
        this.field_230712_o_.func_243248_b(ms, this.field_230704_d_, (float)(this.field_147003_i + 24), (float)(this.field_147009_r + 4), 0x442000);
        this.field_230712_o_.func_243248_b(ms, this.field_213127_e.func_145748_c_(), (float)(this.field_147003_i - 13), (float)(this.field_147009_r + 154), 0x404040);
        this.renderToolbox(ms, mouseX, mouseY, partialTicks);
        this.hoveredToolboxSlot = null;
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            Slot slot = (Slot)((ToolboxContainer)this.field_147002_h).field_75151_b.get(baseIndex);
            ItemStack itemstack = slot.func_75211_c();
            int i = slot.field_75223_e + this.field_147003_i;
            int j = slot.field_75221_f + this.field_147009_r;
            if (itemstack.func_190926_b()) {
                itemstack = ((ToolboxContainer)this.field_147002_h).getFilter(compartment);
            }
            if (!itemstack.func_190926_b()) {
                int count = ((ToolboxContainer)this.field_147002_h).totalCountInCompartment(compartment);
                String s = count + "";
                this.func_230926_e_(100);
                this.field_230707_j_.field_77023_b = 100.0f;
                RenderSystem.enableDepthTest();
                this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, itemstack, i, j);
                this.field_230707_j_.func_180453_a(this.field_230712_o_, itemstack, i, j, s);
                this.func_230926_e_(0);
                this.field_230707_j_.field_77023_b = 0.0f;
            }
            if (!this.func_195359_a(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            this.hoveredToolboxSlot = slot;
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int slotColor = this.getSlotColor(baseIndex);
            this.func_238468_a_(ms, i, j, i + 16, j + 16, slotColor, slotColor);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    private void renderToolbox(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        ms.func_227860_a_();
        ms.func_227861_a_((double)(this.field_147003_i + 247), (double)(this.field_147009_r + 180), 100.0);
        MatrixTransformStack.of((MatrixStack)ms).scale(50.0f).rotateX(-22.0).rotateY(-202.0);
        GuiGameElement.of(AllBlocks.TOOLBOXES.get(this.color).getDefaultState()).render(ms);
        ms.func_227860_a_();
        MatrixTransformStack.of((MatrixStack)ms).translate(0.0, -0.375, 0.75).rotateX((double)(-105.0f * ((ToolboxTileEntity)((ToolboxContainer)this.field_147002_h).contentHolder).lid.getValue(partialTicks))).translate(0.0, 0.375, -0.75);
        GuiGameElement.of(AllBlockPartials.TOOLBOX_LIDS.get(this.color)).render(ms);
        ms.func_227865_b_();
        for (int offset : Iterate.zeroAndOne) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)((float)(-offset * 1) / 8.0f), (double)(((ToolboxTileEntity)((ToolboxContainer)this.field_147002_h).contentHolder).drawers.getValue(partialTicks) * -0.175f * (float)(2 - offset)));
            GuiGameElement.of(AllBlockPartials.TOOLBOX_DRAWER).render(ms);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    @Override
    protected void renderWindowForeground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredToolboxSlot != null) {
            this.field_147006_u = this.hoveredToolboxSlot;
        }
        super.renderWindowForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        boolean mouseClicked = super.func_231044_a_(x, y, button);
        if (button == 0) {
            if (this.confirmButton.func_230449_g_()) {
                this.field_230706_i_.field_71439_g.func_71053_j();
                return true;
            }
            if (this.disposeButton.func_230449_g_()) {
                AllPackets.channel.sendToServer((Object)new ToolboxDisposeAllPacket(((ToolboxTileEntity)((ToolboxContainer)this.field_147002_h).contentHolder).func_174877_v()));
                return true;
            }
        }
        return mouseClicked;
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }
}

