/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.google.gson.JsonObject;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.tools.BlueprintEntity;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BlueprintItem
extends Item {
    public BlueprintItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        Direction face = ctx.func_196000_l();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        BlockPos pos = ctx.func_195995_a().func_177972_a(face);
        if (player != null && !player.func_175151_a(pos, face, stack)) {
            return ActionResultType.FAIL;
        }
        World world = ctx.func_195991_k();
        BlueprintEntity hangingentity = new BlueprintEntity(world, pos, face, face.func_176740_k().func_176722_c() ? Direction.DOWN : ctx.func_195992_f());
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null) {
            EntityType.func_208048_a((World)world, (PlayerEntity)player, (Entity)hangingentity, (CompoundNBT)compoundnbt);
        }
        if (!hangingentity.func_70518_d()) {
            return ActionResultType.CONSUME;
        }
        if (!world.field_72995_K) {
            hangingentity.func_184523_o();
            world.func_217376_c((Entity)hangingentity);
        }
        stack.func_190918_g(1);
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    protected boolean canPlace(PlayerEntity p_200127_1_, Direction p_200127_2_, ItemStack p_200127_3_, BlockPos p_200127_4_) {
        return p_200127_1_.func_175151_a(p_200127_4_, p_200127_2_, p_200127_3_);
    }

    public static void assignCompleteRecipe(ItemStackHandler inv, IRecipe<?> recipe) {
        int i;
        NonNullList ingredients = recipe.func_192400_c();
        for (i = 0; i < 9; ++i) {
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        inv.setStackInSlot(9, recipe.func_77571_b());
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            for (int row = 0; row < shapedRecipe.func_192404_g(); ++row) {
                for (int col = 0; col < shapedRecipe.func_192403_f(); ++col) {
                    inv.setStackInSlot(row * 3 + col, BlueprintItem.convertIngredientToFilter((Ingredient)ingredients.get(row * shapedRecipe.func_192403_f() + col)));
                }
            }
        } else {
            for (i = 0; i < ingredients.size(); ++i) {
                inv.setStackInSlot(i, BlueprintItem.convertIngredientToFilter((Ingredient)ingredients.get(i)));
            }
        }
    }

    private static ItemStack convertIngredientToFilter(Ingredient ingredient) {
        Ingredient.IItemList[] acceptedItems = (Ingredient.IItemList[])ObfuscationReflectionHelper.getPrivateValue(Ingredient.class, (Object)ingredient, (String)"field_199807_b");
        if (acceptedItems == null || acceptedItems.length > 18) {
            return ItemStack.field_190927_a;
        }
        if (acceptedItems.length == 0) {
            return ItemStack.field_190927_a;
        }
        if (acceptedItems.length == 1) {
            return BlueprintItem.convertIItemListToFilter(acceptedItems[0]);
        }
        ItemStack result = AllItems.FILTER.asStack();
        ItemStackHandler filterItems = FilterItem.getFilterItems(result);
        for (int i = 0; i < acceptedItems.length; ++i) {
            filterItems.setStackInSlot(i, BlueprintItem.convertIItemListToFilter(acceptedItems[i]));
        }
        result.func_196082_o().func_218657_a("Items", (INBT)filterItems.serializeNBT());
        return result;
    }

    private static ItemStack convertIItemListToFilter(Ingredient.IItemList itemList) {
        Iterator iterator;
        Collection stacks = itemList.func_199799_a();
        if (itemList instanceof Ingredient.SingleItemList && (iterator = stacks.iterator()).hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            return itemStack;
        }
        if (itemList instanceof Ingredient.TagList) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)itemList.func_200303_b(), (String)"tag"));
            ItemStack filterItem = AllItems.ATTRIBUTE_FILTER.asStack();
            filterItem.func_196082_o().func_74768_a("WhitelistMode", AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ.ordinal());
            ListNBT attributes = new ListNBT();
            ItemAttribute.InTag at = new ItemAttribute.InTag(resourcelocation);
            CompoundNBT compoundNBT = new CompoundNBT();
            at.serializeNBT(compoundNBT);
            compoundNBT.func_74757_a("Inverted", false);
            attributes.add((Object)compoundNBT);
            filterItem.func_196082_o().func_218657_a("MatchedAttributes", (INBT)attributes);
            return filterItem;
        }
        if (itemList instanceof StackList) {
            ItemStack result = AllItems.FILTER.asStack();
            ItemStackHandler filterItems = FilterItem.getFilterItems(result);
            int i = 0;
            for (ItemStack itemStack : stacks) {
                if (i >= 18) break;
                filterItems.setStackInSlot(i++, itemStack);
            }
            CompoundNBT tag = result.func_196082_o();
            tag.func_218657_a("Items", (INBT)filterItems.serializeNBT());
            tag.func_74757_a("RespectNBT", true);
            return result;
        }
        return ItemStack.field_190927_a;
    }
}

