/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.IRedstoneLinkable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.WorldHelper;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneLinkNetworkHandler {
    static final Map<IWorld, Map<Pair<Frequency, Frequency>, Set<IRedstoneLinkable>>> connections = new IdentityHashMap<IWorld, Map<Pair<Frequency, Frequency>, Set<IRedstoneLinkable>>>();

    public void onLoadWorld(IWorld world) {
        connections.put(world, new HashMap());
        Create.LOGGER.debug("Prepared Redstone Network Space for " + WorldHelper.getDimensionID(world));
    }

    public void onUnloadWorld(IWorld world) {
        connections.remove(world);
        Create.LOGGER.debug("Removed Redstone Network Space for " + WorldHelper.getDimensionID(world));
    }

    public Set<IRedstoneLinkable> getNetworkOf(IWorld world, IRedstoneLinkable actor) {
        Pair<Frequency, Frequency> key;
        Map<Pair<Frequency, Frequency>, Set<IRedstoneLinkable>> networksInWorld = this.networksIn(world);
        if (!networksInWorld.containsKey(key = actor.getNetworkKey())) {
            networksInWorld.put(key, new LinkedHashSet());
        }
        return networksInWorld.get(key);
    }

    public void addToNetwork(IWorld world, IRedstoneLinkable actor) {
        this.getNetworkOf(world, actor).add(actor);
        this.updateNetworkOf(world, actor);
    }

    public void removeFromNetwork(IWorld world, IRedstoneLinkable actor) {
        Set<IRedstoneLinkable> network = this.getNetworkOf(world, actor);
        network.remove(actor);
        if (network.isEmpty()) {
            this.networksIn(world).remove(actor.getNetworkKey());
            return;
        }
        this.updateNetworkOf(world, actor);
    }

    public void updateNetworkOf(IWorld world, IRedstoneLinkable actor) {
        LinkBehaviour linkBehaviour;
        Set<IRedstoneLinkable> network = this.getNetworkOf(world, actor);
        int power = 0;
        Iterator<IRedstoneLinkable> iterator = network.iterator();
        while (iterator.hasNext()) {
            IRedstoneLinkable other = iterator.next();
            if (!other.isAlive()) {
                iterator.remove();
                continue;
            }
            if (!world.isAreaLoaded(other.getLocation(), 0)) {
                iterator.remove();
                continue;
            }
            if (!RedstoneLinkNetworkHandler.withinRange(actor, other) || power >= 15) continue;
            power = Math.max(other.getTransmittedStrength(), power);
        }
        if (actor instanceof LinkBehaviour && (linkBehaviour = (LinkBehaviour)actor).isListening()) {
            linkBehaviour.newPosition = true;
            linkBehaviour.setReceivedStrength(power);
        }
        for (IRedstoneLinkable other : network) {
            if (other == actor || !other.isListening() || !RedstoneLinkNetworkHandler.withinRange(actor, other)) continue;
            other.setReceivedStrength(power);
        }
    }

    public static boolean withinRange(IRedstoneLinkable from, IRedstoneLinkable to) {
        if (from == to) {
            return true;
        }
        return from.getLocation().func_218141_a((Vector3i)to.getLocation(), (double)((Integer)AllConfigs.SERVER.logistics.linkRange.get()).intValue());
    }

    public Map<Pair<Frequency, Frequency>, Set<IRedstoneLinkable>> networksIn(IWorld world) {
        if (!connections.containsKey(world)) {
            Create.LOGGER.warn("Tried to Access unprepared network space of " + WorldHelper.getDimensionID(world));
            return new HashMap<Pair<Frequency, Frequency>, Set<IRedstoneLinkable>>();
        }
        return connections.get(world);
    }

    public static class Frequency {
        public static final Frequency EMPTY = new Frequency(ItemStack.field_190927_a);
        private static final Map<Item, Frequency> simpleFrequencies = new IdentityHashMap<Item, Frequency>();
        private ItemStack stack;
        private Item item;
        private int color;

        public static Frequency of(ItemStack stack) {
            if (stack.func_190926_b()) {
                return EMPTY;
            }
            if (!stack.func_77942_o()) {
                return simpleFrequencies.computeIfAbsent(stack.func_77973_b(), $ -> new Frequency(stack));
            }
            return new Frequency(stack);
        }

        private Frequency(ItemStack stack) {
            this.stack = stack;
            this.item = stack.func_77973_b();
            CompoundNBT displayTag = stack.func_179543_a("display");
            this.color = displayTag != null && displayTag.func_74764_b("color") ? displayTag.func_74762_e("color") : -1;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int hashCode() {
            return this.item.hashCode() * 31 ^ this.color;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof Frequency ? ((Frequency)obj).item == this.item && ((Frequency)obj).color == this.color : false;
        }
    }
}

