/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class EntityLauncher {
    private int horizontalDistance;
    private int verticalDistance;
    private double yMotion;
    private double xMotion;
    private double totalFlyingTicks;

    public EntityLauncher(int horizontalDistance, int verticalDistance) {
        this.set(horizontalDistance, verticalDistance);
    }

    public void clamp(int max) {
        this.set(Math.min(this.horizontalDistance, max), MathHelper.func_219802_k((double)this.verticalDistance) * Math.min(Math.abs(this.verticalDistance), max));
    }

    public void set(int horizontalDistance, int verticalDistance) {
        this.horizontalDistance = horizontalDistance;
        this.verticalDistance = verticalDistance;
        this.recalculateTrajectory();
    }

    public void applyMotion(Entity entity, Direction facing) {
        Vector3d motionVec = new Vector3d(0.0, this.yMotion, this.xMotion);
        motionVec = VecHelper.rotate(motionVec, AngleHelper.horizontalAngle(facing), Direction.Axis.Y);
        entity.func_213293_j(motionVec.field_72450_a * 0.91, motionVec.field_72448_b * 0.98, motionVec.field_72449_c * 0.91);
    }

    public int getHorizontalDistance() {
        return this.horizontalDistance;
    }

    public int getVerticalDistance() {
        return this.verticalDistance;
    }

    public double getTotalFlyingTicks() {
        return this.totalFlyingTicks;
    }

    public Vector3d getGlobalPos(double t, Direction d, BlockPos launcher) {
        Vector3d start = new Vector3d((double)((float)launcher.func_177958_n() + 0.5f), (double)((float)launcher.func_177956_o() + 0.5f), (double)((float)launcher.func_177952_p() + 0.5f));
        float xt = this.x(t);
        float yt = this.y(t);
        double progress = MathHelper.func_151237_a((double)(t / this.getTotalFlyingTicks()), (double)0.0, (double)1.0);
        double correctionStrength = Math.pow(progress, 3.0);
        Vector3d vec = new Vector3d(0.0, (double)yt + (double)((float)this.verticalDistance - yt) * correctionStrength * 0.5, (double)xt + (double)((float)this.horizontalDistance - xt) * correctionStrength);
        return VecHelper.rotate(vec, 180.0f + AngleHelper.horizontalAngle(d), Direction.Axis.Y).func_178787_e(start);
    }

    public Vector3d getGlobalVelocity(double t, Direction d, BlockPos launcher) {
        return VecHelper.rotate(new Vector3d(0.0, (double)this.dy(t), (double)this.dx(t)), 180.0f + AngleHelper.horizontalAngle(d), Direction.Axis.Y);
    }

    public float x(double t) {
        return (float)(this.xMotion * -10.6033 * (-1.0 + Math.pow(0.91, t)));
    }

    public float y(double t) {
        double f = Math.pow(0.98, t);
        return (float)(this.yMotion * -49.4983 * f + 49.4983 * this.yMotion - 194.033 * f - 3.92 * t + 194.033);
    }

    public float dx(double t) {
        return (float)(this.xMotion * Math.pow(0.91, t));
    }

    public float dy(double t) {
        double f = Math.pow(0.98, t);
        return (float)(this.yMotion * f + (f - 1.0) / -0.020000000000000018 * -0.0784);
    }

    protected void recalculateTrajectory() {
        double xTarget = this.horizontalDistance;
        double yTarget = this.verticalDistance;
        double xError = -7.0E-4 * Math.pow(xTarget + 0.5, 2.0) + 0.484 - Math.min(5.0, yTarget) / 5.0 * Math.min(1.0, 0.076 * xTarget - 0.0014 * xTarget * xTarget);
        double yPeak = Math.max(0.0, yTarget + (xTarget + 0.5) / 8.0) + (double)(xTarget <= 1.0 ? 1 : 4);
        this.yMotion = Math.sqrt(2.0 * yPeak / 13.0) + 0.015 * yPeak;
        double tPeak = Math.log(98.0 / (25.0 * this.yMotion + 98.0)) / (2.0 * Math.log(7.0) - 2.0 * Math.log(5.0) - Math.log(2.0));
        this.totalFlyingTicks = Math.sqrt(yPeak - this.yMotion) * 4.87 + 0.115 * (yPeak - this.yMotion) + tPeak;
        this.xMotion = (xTarget - xError + 0.5) / (-10.6033 * (-1.0 + Math.pow(0.91, this.totalFlyingTicks)));
    }
}

