/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ArmPlacementPacket
extends SimplePacketBase {
    private Collection<ArmInteractionPoint> points;
    private ListNBT receivedTag;
    private BlockPos pos;

    public ArmPlacementPacket(Collection<ArmInteractionPoint> points, BlockPos pos) {
        this.points = points;
        this.pos = pos;
    }

    public ArmPlacementPacket(PacketBuffer buffer) {
        CompoundNBT nbt = buffer.func_150793_b();
        this.receivedTag = nbt.func_150295_c("Points", 10);
        this.pos = buffer.func_179259_c();
    }

    @Override
    public void write(PacketBuffer buffer) {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT pointsNBT = new ListNBT();
        this.points.stream().map(aip -> aip.serialize(this.pos)).forEach(arg_0 -> pointsNBT.add(arg_0));
        nbt.func_218657_a("Points", (INBT)pointsNBT);
        buffer.func_150786_a(nbt);
        buffer.func_179255_a(this.pos);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            World world = player.field_70170_p;
            if (world == null || !world.func_195588_v(this.pos)) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (!(tileEntity instanceof ArmTileEntity)) {
                return;
            }
            ArmTileEntity arm = (ArmTileEntity)tileEntity;
            arm.interactionPointTag = this.receivedTag;
        });
        context.get().setPacketHandled(true);
    }
}

