/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantAttribute
implements ItemAttribute {
    public static final EnchantAttribute EMPTY = new EnchantAttribute(null);
    private final Enchantment enchantment;

    public EnchantAttribute(@Nullable Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return EnchantmentHelper.func_82781_a((ItemStack)itemStack).containsKey(this.enchantment);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        return EnchantmentHelper.func_82781_a((ItemStack)itemStack).keySet().stream().map(EnchantAttribute::new).collect(Collectors.toList());
    }

    @Override
    public String getTranslationKey() {
        return "has_enchant";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.enchantment != null) {
            parameter = new TranslationTextComponent(this.enchantment.func_77320_a()).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        if (this.enchantment == null) {
            return;
        }
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)this.enchantment);
        if (id == null) {
            return;
        }
        nbt.func_74778_a("id", id.toString());
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return nbt.func_74764_b("id") ? new EnchantAttribute((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)nbt.func_74779_i("id")))) : EMPTY;
    }
}

