/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.EntityElement;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.items.ItemHandlerHelper;

public class CrafterScenes {
    public static void setup(SceneBuilder scene, SceneBuildingUtil util) {
        BlockPos[] positions;
        scene.title("mechanical_crafter", "Setting up Mechanical Crafters");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(1.5f * f.floatValue()));
        Selection redstone = util.select.fromTo(3, 1, 0, 3, 1, 1);
        Selection kinetics = util.select.fromTo(4, 1, 2, 4, 1, 5);
        BlockPos depotPos = util.grid.at(0, 1, 2);
        Selection crafters = util.select.fromTo(1, 1, 2, 3, 3, 2);
        scene.world.modifyBlocks(crafters, s -> (BlockState)s.func_206870_a(MechanicalCrafterBlock.POINTING, (Comparable)((Object)Pointing.DOWN)), false);
        scene.world.setKineticSpeed(crafters, 0.0f);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                scene.world.showSection(util.select.position(y == 1 ? x + 1 : 3 - x, y + 1, 2), Direction.DOWN);
                scene.idle(2);
            }
        }
        scene.overlay.showText(70).text("An array of Mechanical Crafters can be used to automate any Crafting Recipe").pointAt(util.vector.blockSurface(util.grid.at(1, 2, 2), Direction.WEST)).attachKeyFrame().placeNearTarget();
        scene.idle(80);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 3, 2), Direction.NORTH), Pointing.RIGHT).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.cycleBlockProperty(util.grid.at(2, 3, 2), (Property<?>)MechanicalCrafterBlock.POINTING);
        scene.idle(10);
        scene.overlay.showText(50).text("Using a Wrench, the Crafters' paths can be arranged").pointAt(util.vector.blockSurface(util.grid.at(2, 3, 2), Direction.NORTH)).attachKeyFrame().placeNearTarget();
        scene.idle(60);
        for (BlockPos pos : positions = new BlockPos[]{util.grid.at(3, 1, 2), util.grid.at(2, 1, 2), util.grid.at(1, 1, 2)}) {
            scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(pos, Direction.NORTH), Pointing.RIGHT).rightClick().withWrench(), 10);
            scene.idle(7);
            scene.world.cycleBlockProperty(pos, (Property<?>)MechanicalCrafterBlock.POINTING);
            scene.idle(15);
        }
        scene.overlay.showText(100).text("For a valid setup, all paths have to converge into one exit at any side").pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), Direction.WEST).func_72441_c(0.0, 0.0, -0.5)).colored(PonderPalette.GREEN).attachKeyFrame().placeNearTarget();
        scene.idle(60);
        ImmutableList couples = ImmutableList.of(Couple.create(util.grid.at(3, 3, 2), util.grid.at(3, 2, 2)), Couple.create(util.grid.at(3, 2, 2), util.grid.at(3, 1, 2)), Couple.create(util.grid.at(2, 3, 2), util.grid.at(1, 3, 2)), Couple.create(util.grid.at(3, 1, 2), util.grid.at(2, 1, 2)), Couple.create(util.grid.at(1, 3, 2), util.grid.at(1, 2, 2)), Couple.create(util.grid.at(2, 2, 2), util.grid.at(2, 1, 2)), Couple.create(util.grid.at(1, 2, 2), util.grid.at(1, 1, 2)), Couple.create(util.grid.at(2, 1, 2), util.grid.at(1, 1, 2)), Couple.create(util.grid.at(1, 1, 2), util.grid.at(0, 1, 2)));
        for (Couple c : couples) {
            scene.idle(5);
            Vector3d p1 = util.vector.blockSurface((BlockPos)c.getFirst(), Direction.NORTH).func_72441_c(0.0, 0.0, -0.125);
            Vector3d p2 = util.vector.blockSurface((BlockPos)c.getSecond(), Direction.NORTH).func_72441_c(0.0, 0.0, -0.125);
            AxisAlignedBB point = new AxisAlignedBB(p1, p1);
            AxisAlignedBB line = new AxisAlignedBB(p1, p2);
            scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, p1, point, 2);
            scene.idle(1);
            scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, p1, line, 30);
        }
        scene.world.showSection(util.select.position(depotPos), Direction.EAST);
        scene.idle(20);
        scene.overlay.showText(60).text("The outputs will be placed into the inventory at the exit").pointAt(util.vector.blockSurface(util.grid.at(0, 1, 2), Direction.NORTH)).placeNearTarget();
        scene.idle(70);
        scene.rotateCameraY(60.0f);
        scene.idle(20);
        scene.world.showSection(kinetics, Direction.NORTH);
        scene.overlay.showText(60).text("Mechanical Crafters require Rotational Force to operate").pointAt(util.vector.blockSurface(util.grid.at(4, 1, 2), Direction.NORTH)).attachKeyFrame().placeNearTarget();
        scene.idle(8);
        scene.world.setKineticSpeed(crafters, -48.0f);
        scene.world.multiplyKineticSpeed(util.select.position(3, 2, 2).add(util.select.position(2, 3, 2)).add(util.select.position(1, 2, 2)).add(util.select.position(2, 1, 2)), -1.0f);
        scene.idle(55);
        scene.rotateCameraY(-60.0f);
        scene.idle(40);
        ItemStack planks = new ItemStack((IItemProvider)Items.field_221586_n);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(1, 3, 2), Direction.NORTH), Pointing.RIGHT).rightClick().withItem(planks), 40);
        scene.idle(7);
        Class<MechanicalCrafterTileEntity> type = MechanicalCrafterTileEntity.class;
        scene.world.modifyTileEntity(util.grid.at(1, 3, 2), type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
        scene.idle(10);
        scene.overlay.showText(50).text("Right-Click the front to insert Items manually").pointAt(util.vector.blockSurface(util.grid.at(1, 3, 2), Direction.NORTH)).attachKeyFrame().placeNearTarget();
        scene.idle(60);
        ItemStack alloy = AllItems.ANDESITE_ALLOY.asStack();
        ItemStack log = new ItemStack((IItemProvider)Items.field_221554_G);
        scene.world.setCraftingResult(util.grid.at(1, 1, 2), AllBlocks.ANDESITE_CASING.asStack(4));
        scene.world.modifyTileEntity(util.grid.at(2, 3, 2), type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(3, 3, 2), type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(3, 2, 2), type, mct -> mct.getInventory().insertItem(0, alloy.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(2, 2, 2), type, mct -> mct.getInventory().insertItem(0, log.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(1, 2, 2), type, mct -> mct.getInventory().insertItem(0, alloy.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(1, 1, 2), type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(2, 1, 2), type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(3, 1, 2), type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
        scene.overlay.showText(80).attachKeyFrame().text("Once every slot of a path contains an Item, the crafting process will begin").pointAt(util.vector.blockSurface(util.grid.at(1, 3, 2), Direction.WEST)).placeNearTarget();
        scene.idle(180);
        scene.world.removeItemsFromBelt(depotPos);
        ItemStack stick = new ItemStack((IItemProvider)Items.field_151055_y);
        ItemStack iron = new ItemStack((IItemProvider)Items.field_151042_j);
        scene.world.setCraftingResult(util.grid.at(1, 1, 2), new ItemStack((IItemProvider)Items.field_151035_b));
        scene.world.modifyTileEntity(util.grid.at(1, 3, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        scene.idle(2);
        scene.world.modifyTileEntity(util.grid.at(2, 3, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        scene.idle(2);
        scene.world.modifyTileEntity(util.grid.at(3, 3, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        scene.idle(2);
        scene.world.modifyTileEntity(util.grid.at(2, 2, 2), type, mct -> mct.getInventory().insertItem(0, stick.func_77946_l(), false));
        scene.idle(2);
        scene.world.modifyTileEntity(util.grid.at(2, 1, 2), type, mct -> mct.getInventory().insertItem(0, stick.func_77946_l(), false));
        scene.world.showSection(redstone, Direction.SOUTH);
        scene.idle(10);
        scene.overlay.showText(90).attachKeyFrame().colored(PonderPalette.RED).text("For recipes not fully occupying the crafter setup, the start can be forced using a Redstone Pulse").pointAt(util.vector.blockSurface(util.grid.at(1, 2, 2), Direction.NORTH)).placeNearTarget();
        scene.idle(100);
        scene.effects.indicateRedstone(util.grid.at(3, 1, 0));
        scene.world.toggleRedstonePower(redstone);
        scene.idle(20);
        scene.world.toggleRedstonePower(redstone);
    }

    public static void connect(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_crafter_connect", "Connecting Inventories of Crafters");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 2; ++x) {
                scene.world.showSection(util.select.position(y == 1 ? x + 1 : 2 - x, y + 1, 2), Direction.DOWN);
                scene.idle(2);
            }
        }
        Class<MechanicalCrafterTileEntity> type = MechanicalCrafterTileEntity.class;
        BlockPos depotPos = util.grid.at(0, 1, 2);
        Selection funnel = util.select.fromTo(4, 1, 5, 4, 1, 2).add(util.select.fromTo(3, 2, 2, 3, 1, 2));
        Selection kinetics = util.select.position(3, 3, 2).add(util.select.fromTo(3, 3, 3, 3, 1, 3));
        scene.idle(5);
        scene.world.showSection(kinetics, Direction.NORTH);
        scene.idle(5);
        scene.world.showSection(util.select.position(depotPos), Direction.EAST);
        scene.idle(10);
        scene.world.showSection(funnel, Direction.WEST);
        scene.rotateCameraY(60.0f);
        ItemStack planks = new ItemStack((IItemProvider)Items.field_221586_n);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), Direction.EAST, planks.func_77946_l());
        scene.idle(22);
        scene.world.modifyTileEntity(util.grid.at(2, 2, 2), type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
        scene.world.removeItemsFromBelt(util.grid.at(3, 1, 2));
        scene.world.flapFunnel(util.grid.at(3, 2, 2), false);
        scene.overlay.showSelectionWithText(util.select.position(2, 2, 2), 70).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(2, 2, 2), Direction.NORTH)).text("Items can be inserted to Crafters automatically");
        scene.idle(80);
        scene.rotateCameraY(-180.0f);
        scene.idle(40);
        Vector3d v = util.vector.blockSurface(util.grid.at(2, 2, 2), Direction.WEST);
        AxisAlignedBB bb = new AxisAlignedBB(v, v).func_72314_b(0.125, 0.5, 0.5);
        v = v.func_72441_c(0.0, 0.0, 0.5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.WHITE, new Object(), bb, 45);
        scene.overlay.showControls(new InputWindowElement(v, Pointing.LEFT).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.connectCrafterInvs(util.grid.at(2, 2, 2), util.grid.at(1, 2, 2));
        scene.idle(40);
        scene.overlay.showSelectionWithText(util.select.fromTo(2, 2, 2, 1, 2, 2), 70).attachKeyFrame().placeNearTarget().pointAt(v).text("Using the Wrench at their backs, Mechanical Crafter inputs can be combined");
        scene.idle(80);
        scene.overlay.showControls(new InputWindowElement(v.func_72441_c(0.0, 1.0, 0.0), Pointing.LEFT).rightClick().withWrench(), 20);
        scene.idle(7);
        scene.world.connectCrafterInvs(util.grid.at(2, 3, 2), util.grid.at(1, 3, 2));
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(v.func_72441_c(0.0, -1.0, 0.0), Pointing.LEFT).rightClick().withWrench(), 20);
        scene.idle(7);
        scene.world.connectCrafterInvs(util.grid.at(2, 1, 2), util.grid.at(1, 1, 2));
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(v.func_72441_c(0.5, -0.5, 0.0), Pointing.LEFT).rightClick().withWrench(), 20);
        scene.idle(7);
        scene.world.connectCrafterInvs(util.grid.at(2, 1, 2), util.grid.at(2, 2, 2));
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(v.func_72441_c(0.5, 0.5, 0.0), Pointing.LEFT).rightClick().withWrench(), 20);
        scene.idle(7);
        scene.world.connectCrafterInvs(util.grid.at(2, 2, 2), util.grid.at(2, 3, 2));
        scene.idle(20);
        scene.rotateCameraY(120.0f);
        scene.idle(40);
        scene.overlay.showSelectionWithText(util.select.fromTo(1, 1, 2, 2, 3, 2), 70).attachKeyFrame().placeNearTarget().text("All connected Crafters can now be accessed by the same input location");
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(util.grid.at(4, 2, 2)), Pointing.DOWN).withItem(planks), 40);
        scene.idle(7);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), Direction.EAST, ItemHandlerHelper.copyStackWithSize((ItemStack)planks, (int)16));
        scene.idle(22);
        scene.world.removeItemsFromBelt(util.grid.at(3, 1, 2));
        BlockPos[] positions = new BlockPos[]{util.grid.at(2, 3, 2), util.grid.at(1, 3, 2), util.grid.at(1, 2, 2), util.grid.at(2, 1, 2), util.grid.at(1, 1, 2)};
        scene.world.setCraftingResult(util.grid.at(1, 1, 2), new ItemStack((IItemProvider)Items.field_222015_iN, 3));
        for (BlockPos pos : positions) {
            scene.world.modifyTileEntity(pos, type, mct -> mct.getInventory().insertItem(0, planks.func_77946_l(), false));
            scene.idle(1);
        }
    }

    public static void covers(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_crafter_covers", "Covering slots of Mechanical Crafters");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.world.setBlock(util.grid.at(2, 2, 2), Blocks.field_150350_a.func_176223_P(), false);
        Selection kinetics = util.select.fromTo(3, 1, 2, 3, 1, 5);
        scene.world.setKineticSpeed(util.select.fromTo(1, 2, 2, 3, 1, 2), 0.0f);
        scene.world.showSection(util.select.position(3, 2, 2), Direction.EAST);
        scene.idle(5);
        scene.world.showSection(util.select.position(2, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(1, 2, 2), Direction.WEST);
        scene.idle(5);
        ItemStack iron = new ItemStack((IItemProvider)Items.field_151042_j);
        Class<MechanicalCrafterTileEntity> type = MechanicalCrafterTileEntity.class;
        scene.world.modifyTileEntity(util.grid.at(3, 2, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(2, 1, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        scene.idle(5);
        scene.world.modifyTileEntity(util.grid.at(1, 2, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        scene.idle(5);
        Selection emptyCrafter = util.select.position(2, 2, 2);
        scene.overlay.showSelectionWithText(emptyCrafter, 90).attachKeyFrame().colored(PonderPalette.RED).text("Some recipes will require additional Crafters to bridge gaps in the path").placeNearTarget();
        scene.idle(70);
        scene.world.restoreBlocks(emptyCrafter);
        scene.world.setCraftingResult(util.grid.at(2, 2, 2), new ItemStack((IItemProvider)Items.field_151133_ar));
        scene.world.showSection(emptyCrafter, Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.position(2, 3, 2), Direction.DOWN);
        scene.world.showSection(kinetics, Direction.NORTH);
        scene.idle(5);
        scene.world.setKineticSpeed(util.select.fromTo(3, 1, 2, 1, 2, 2), -32.0f);
        scene.world.setKineticSpeed(util.select.position(3, 1, 2).add(emptyCrafter), 32.0f);
        scene.idle(20);
        scene.overlay.showText(90).attachKeyFrame().colored(PonderPalette.GREEN).pointAt(util.vector.blockSurface(util.grid.at(2, 2, 2), Direction.NORTH)).text("Using Slot Covers, Crafters can be set to act as an Empty Slot in the arrangement").placeNearTarget();
        scene.idle(100);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 2, 2), Direction.NORTH).func_72441_c(0.5, 0.0, 0.0), Pointing.RIGHT).withItem(AllItems.CRAFTER_SLOT_COVER.asStack()).rightClick(), 50);
        scene.idle(7);
        scene.world.modifyTileNBT(emptyCrafter, type, compound -> compound.func_74757_a("Cover", true));
        scene.idle(130);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 3, 2), Direction.WEST), Pointing.LEFT).withItem(new ItemStack((IItemProvider)Items.field_151133_ar)), 40);
        scene.idle(50);
        scene.world.showSection(util.select.position(4, 2, 2), Direction.DOWN);
        scene.world.connectCrafterInvs(util.grid.at(3, 2, 2), util.grid.at(2, 2, 2));
        scene.idle(5);
        scene.world.connectCrafterInvs(util.grid.at(2, 1, 2), util.grid.at(2, 2, 2));
        scene.idle(5);
        scene.world.connectCrafterInvs(util.grid.at(1, 2, 2), util.grid.at(2, 2, 2));
        scene.idle(10);
        scene.overlay.showSelectionWithText(util.select.fromTo(3, 2, 2, 1, 2, 2).add(util.select.position(2, 1, 2)), 80).attachKeyFrame().pointAt(util.vector.blockSurface(util.grid.at(2, 2, 2), Direction.NORTH)).text("Shared Inputs created with the Wrench at the back can also reach across covered Crafters").placeNearTarget();
        scene.idle(60);
        ElementLink<EntityElement> ingot = scene.world.createItemEntity(util.vector.centerOf(4, 4, 2), util.vector.of(0.0, 0.2, 0.0), iron);
        scene.idle(17);
        scene.world.modifyEntity(ingot, Entity::func_70106_y);
        scene.world.modifyTileEntity(util.grid.at(3, 2, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        ingot = scene.world.createItemEntity(util.vector.centerOf(4, 4, 2), util.vector.of(0.0, 0.2, 0.0), iron);
        scene.idle(17);
        scene.world.modifyEntity(ingot, Entity::func_70106_y);
        scene.world.modifyTileEntity(util.grid.at(2, 1, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
        ingot = scene.world.createItemEntity(util.vector.centerOf(4, 4, 2), util.vector.of(0.0, 0.2, 0.0), iron);
        scene.idle(17);
        scene.world.modifyEntity(ingot, Entity::func_70106_y);
        scene.world.modifyTileEntity(util.grid.at(1, 2, 2), type, mct -> mct.getInventory().insertItem(0, iron.func_77946_l(), false));
    }
}

