/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.util.BufferBuilderReader;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.utility.Color;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class SuperByteBuffer {
    private final BufferBuilderReader template;
    private MatrixStack transforms;
    private boolean shouldColor;
    private int r;
    private int g;
    private int b;
    private int a;
    private boolean disableDiffuseDiv;
    private boolean disableDiffuseMult;
    private SpriteShiftFunc spriteShiftFunc;
    private boolean hasOverlay;
    private int overlay = OverlayTexture.field_229196_a_;
    private boolean useWorldLight;
    private Matrix4f lightTransform;
    private boolean hasCustomLight;
    private int packedLightCoords;
    private boolean hybridLight;
    private boolean fullNormalTransform;
    private static final Long2IntMap WORLD_LIGHT_CACHE = new Long2IntOpenHashMap();
    private final Vector4f pos = new Vector4f();
    private final Vector3f normal = new Vector3f();
    private final Vector4f lightPos = new Vector4f();
    private final MatrixTransformStack stacker;

    public SuperByteBuffer(BufferBuilder buf) {
        this.template = new BufferBuilderReader(buf);
        this.transforms = new MatrixStack();
        this.transforms.func_227860_a_();
        this.stacker = MatrixTransformStack.of((MatrixStack)this.transforms);
    }

    public static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.func_94212_f() - sprite.func_94209_e();
        return (u - sprite.func_94209_e()) / f * 16.0f;
    }

    public static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.func_94210_h() - sprite.func_94206_g();
        return (v - sprite.func_94206_g()) / f * 16.0f;
    }

    public void renderInto(MatrixStack input, IVertexBuilder builder) {
        Matrix3f normalMat;
        if (this.isEmpty()) {
            return;
        }
        Matrix4f modelMat = input.func_227866_c_().func_227870_a_().func_226601_d_();
        Matrix4f localTransforms = this.transforms.func_227866_c_().func_227870_a_();
        modelMat.func_226595_a_(localTransforms);
        if (this.fullNormalTransform) {
            normalMat = input.func_227866_c_().func_227872_b_().func_226121_d_();
            Matrix3f localNormalTransforms = this.transforms.func_227866_c_().func_227872_b_();
            normalMat.func_226118_b_(localNormalTransforms);
        } else {
            normalMat = this.transforms.func_227866_c_().func_227872_b_().func_226121_d_();
        }
        if (this.useWorldLight) {
            WORLD_LIGHT_CACHE.clear();
        }
        float f = 0.5f;
        int vertexCount = this.template.getVertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            int light;
            float x = this.template.getX(i);
            float y = this.template.getY(i);
            float z = this.template.getZ(i);
            byte r = this.template.getR(i);
            byte g = this.template.getG(i);
            byte b = this.template.getB(i);
            byte a = this.template.getA(i);
            float normalX = (float)this.template.getNX(i) / 127.0f;
            float normalY = (float)this.template.getNY(i) / 127.0f;
            float normalZ = (float)this.template.getNZ(i) / 127.0f;
            this.normal.func_195905_a(normalX, normalY, normalZ);
            this.normal.func_229188_a_(normalMat);
            float nx = this.normal.func_195899_a();
            float ny = this.normal.func_195900_b();
            float nz = this.normal.func_195902_c();
            float staticDiffuse = LightUtil.diffuseLight((float)normalX, (float)normalY, (float)normalZ);
            float instanceDiffuse = LightUtil.diffuseLight((float)nx, (float)ny, (float)nz);
            this.pos.func_195911_a(x, y, z, 1.0f);
            this.pos.func_229372_a_(modelMat);
            builder.func_225582_a_((double)this.pos.func_195910_a(), (double)this.pos.func_195913_b(), (double)this.pos.func_195914_c());
            if (this.shouldColor) {
                if (this.disableDiffuseMult) {
                    builder.func_225586_a_(this.r, this.g, this.b, this.a);
                } else {
                    int colorR = SuperByteBuffer.transformColor(this.r, instanceDiffuse);
                    int colorG = SuperByteBuffer.transformColor(this.g, instanceDiffuse);
                    int colorB = SuperByteBuffer.transformColor(this.b, instanceDiffuse);
                    builder.func_225586_a_(colorR, colorG, colorB, this.a);
                }
            } else if (this.disableDiffuseDiv && this.disableDiffuseMult) {
                builder.func_225586_a_((int)r, (int)g, (int)b, (int)a);
            } else {
                float diffuseMult = this.disableDiffuseDiv ? instanceDiffuse : (this.disableDiffuseMult ? 1.0f / staticDiffuse : instanceDiffuse / staticDiffuse);
                int colorR = SuperByteBuffer.transformColor(r, diffuseMult);
                int colorG = SuperByteBuffer.transformColor(g, diffuseMult);
                int colorB = SuperByteBuffer.transformColor(b, diffuseMult);
                builder.func_225586_a_(colorR, colorG, colorB, (int)a);
            }
            float u = this.template.getU(i);
            float v = this.template.getV(i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(builder, u, v);
            } else {
                builder.func_225583_a_(u, v);
            }
            if (this.hasOverlay) {
                builder.func_227891_b_(this.overlay);
            }
            if (this.useWorldLight) {
                this.lightPos.func_195911_a((x - f) * 15.0f / 16.0f + f, (y - f) * 15.0f / 16.0f + f, (z - f) * 15.0f / 16.0f + f, 1.0f);
                this.lightPos.func_229372_a_(localTransforms);
                if (this.lightTransform != null) {
                    this.lightPos.func_229372_a_(this.lightTransform);
                }
                light = SuperByteBuffer.getLight((World)Minecraft.func_71410_x().field_71441_e, this.lightPos);
                if (this.hasCustomLight) {
                    light = SuperByteBuffer.maxLight(light, this.packedLightCoords);
                }
            } else {
                light = this.hasCustomLight ? this.packedLightCoords : this.template.getLight(i);
            }
            if (this.hybridLight) {
                builder.func_227886_a_(SuperByteBuffer.maxLight(light, this.template.getLight(i)));
            } else {
                builder.func_227886_a_(light);
            }
            builder.func_225584_a_(nx, ny, nz);
            builder.func_181675_d();
        }
        this.reset();
    }

    public SuperByteBuffer reset() {
        while (!this.transforms.func_227867_d_()) {
            this.transforms.func_227865_b_();
        }
        this.transforms.func_227860_a_();
        this.shouldColor = false;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.a = 0;
        this.disableDiffuseDiv = false;
        this.disableDiffuseMult = false;
        this.spriteShiftFunc = null;
        this.hasOverlay = false;
        this.overlay = OverlayTexture.field_229196_a_;
        this.useWorldLight = false;
        this.lightTransform = null;
        this.hasCustomLight = false;
        this.packedLightCoords = 0;
        this.hybridLight = false;
        this.fullNormalTransform = false;
        return this;
    }

    public MatrixTransformStack matrixStacker() {
        return this.stacker;
    }

    public SuperByteBuffer translate(Vector3d vec) {
        return this.translate(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public SuperByteBuffer translate(double x, double y, double z) {
        return this.translate((float)x, (float)y, (float)z);
    }

    public SuperByteBuffer translate(float x, float y, float z) {
        this.transforms.func_227861_a_((double)x, (double)y, (double)z);
        return this;
    }

    public SuperByteBuffer transform(MatrixStack stack) {
        this.transforms.func_227866_c_().func_227870_a_().func_226595_a_(stack.func_227866_c_().func_227870_a_());
        this.transforms.func_227866_c_().func_227872_b_().func_226118_b_(stack.func_227866_c_().func_227872_b_());
        return this;
    }

    public SuperByteBuffer rotate(Direction axis, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        this.transforms.func_227863_a_(axis.func_229386_k_().func_229193_c_(radians));
        return this;
    }

    public SuperByteBuffer rotate(Quaternion q) {
        this.transforms.func_227863_a_(q);
        return this;
    }

    public SuperByteBuffer rotateCentered(Direction axis, float radians) {
        return this.translate(0.5f, 0.5f, 0.5f).rotate(axis, radians).translate(-0.5f, -0.5f, -0.5f);
    }

    public SuperByteBuffer rotateCentered(Quaternion q) {
        return this.translate(0.5f, 0.5f, 0.5f).rotate(q).translate(-0.5f, -0.5f, -0.5f);
    }

    public SuperByteBuffer color(int r, int g, int b, int a) {
        this.shouldColor = true;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.shouldColor = true;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255;
        return this;
    }

    public SuperByteBuffer color(Color c) {
        return this.color(c.getRGB());
    }

    public SuperByteBuffer disableDiffuseDiv() {
        this.disableDiffuseDiv = true;
        return this;
    }

    public SuperByteBuffer disableDiffuseMult() {
        this.disableDiffuseMult = true;
        return this;
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = entry.getTarget().func_94214_a((double)SuperByteBuffer.getUnInterpolatedU(entry.getOriginal(), u));
            float targetV = entry.getTarget().func_94207_b((double)SuperByteBuffer.getUnInterpolatedV(entry.getOriginal(), v));
            builder.func_225583_a_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = u - entry.getOriginal().func_94209_e() + entry.getTarget().func_94209_e();
            float targetV = v - entry.getOriginal().func_94206_g() + entry.getTarget().func_94206_g() + scrollV;
            builder.func_225583_a_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = entry.getTarget().func_94214_a((double)(SuperByteBuffer.getUnInterpolatedU(entry.getOriginal(), u) / (float)sheetSize + uTarget * 16.0f));
            float targetV = entry.getTarget().func_94207_b((double)(SuperByteBuffer.getUnInterpolatedV(entry.getOriginal(), v) / (float)sheetSize + vTarget * 16.0f));
            builder.func_225583_a_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer overlay() {
        this.hasOverlay = true;
        return this;
    }

    public SuperByteBuffer overlay(int overlay) {
        this.hasOverlay = true;
        this.overlay = overlay;
        return this;
    }

    public SuperByteBuffer light() {
        this.useWorldLight = true;
        return this;
    }

    public SuperByteBuffer light(Matrix4f lightTransform) {
        this.useWorldLight = true;
        this.lightTransform = lightTransform;
        return this;
    }

    public SuperByteBuffer light(int packedLightCoords) {
        this.hasCustomLight = true;
        this.packedLightCoords = packedLightCoords;
        return this;
    }

    public SuperByteBuffer light(Matrix4f lightTransform, int packedLightCoords) {
        this.light(lightTransform);
        this.light(packedLightCoords);
        return this;
    }

    public SuperByteBuffer hybridLight() {
        this.hybridLight = true;
        return this;
    }

    public SuperByteBuffer fullNormalTransform() {
        this.fullNormalTransform = true;
        return this;
    }

    public SuperByteBuffer forEntityRender() {
        this.disableDiffuseMult();
        this.overlay();
        this.fullNormalTransform();
        return this;
    }

    public boolean isEmpty() {
        return this.template.isEmpty();
    }

    public static int transformColor(byte component, float scale) {
        return MathHelper.func_76125_a((int)((int)((float)Byte.toUnsignedInt(component) * scale)), (int)0, (int)255);
    }

    public static int transformColor(int component, float scale) {
        return MathHelper.func_76125_a((int)((int)((float)component * scale)), (int)0, (int)255);
    }

    public static int maxLight(int packedLight1, int packedLight2) {
        int blockLight1 = LightTexture.func_228450_a_((int)packedLight1);
        int skyLight1 = LightTexture.func_228454_b_((int)packedLight1);
        int blockLight2 = LightTexture.func_228450_a_((int)packedLight2);
        int skyLight2 = LightTexture.func_228454_b_((int)packedLight2);
        return LightTexture.func_228451_a_((int)Math.max(blockLight1, blockLight2), (int)Math.max(skyLight1, skyLight2));
    }

    private static int getLight(World world, Vector4f lightPos) {
        BlockPos pos = new BlockPos((double)lightPos.func_195910_a(), (double)lightPos.func_195913_b(), (double)lightPos.func_195914_c());
        return WORLD_LIGHT_CACHE.computeIfAbsent(pos.func_218275_a(), $ -> WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)pos));
    }

    @FunctionalInterface
    public static interface IVertexLighter {
        public int getPackedLight(float var1, float var2, float var3);
    }

    @FunctionalInterface
    public static interface SpriteShiftFunc {
        public void shift(IVertexBuilder var1, float var2, float var3);
    }
}

