/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.client.adapter.ResourcePackAdapter;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.client.SolarFluxResourcePack;
import org.zeith.solarflux.client.SolarPanelBakedModel;
import org.zeith.solarflux.compat.ISFCompat;
import org.zeith.solarflux.compat.SFCompat;
import org.zeith.solarflux.items.ItemsSF;
import org.zeith.solarflux.net.SFNetwork;
import org.zeith.solarflux.panels.SolarPanels;
import org.zeith.solarflux.proxy.SFRClientProxy;
import org.zeith.solarflux.proxy.SFRCommonProxy;

@Mod(value="solarflux")
public class SolarFlux {
    public static final Logger LOG = LogManager.getLogger((String)"SolarFlux");
    public static final SFRCommonProxy PROXY = (SFRCommonProxy)DistExecutor.unsafeRunForDist(() -> SFRClientProxy::new, () -> SFRCommonProxy::new);
    public static final ItemGroup ITEM_GROUP = new ItemGroup("solarflux"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ItemsSF.PHOTOVOLTAIC_CELL_3);
        }
    };
    public static final String MOD_ID = "solarflux";
    private static final List<ISFCompat> COMPATS = new ArrayList<ISFCompat>();

    public SolarFlux() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        LanguageAdapter.registerMod((String)MOD_ID);
        SolarPanels.init();
        for (ScanDataHelper.ModAwareAnnotationData scan : ScanDataHelper.lookupAnnotatedObjects(SFCompat.class)) {
            String modid = Objects.toString(scan.getProperty("value").orElse(null));
            if (!ModList.get().isLoaded(modid)) continue;
            try {
                ISFCompat compat = scan.getOwnerClass().asSubclass(ISFCompat.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                compat.construct();
                COMPATS.add(compat);
                compat.setupConfigFile(FMLPaths.CONFIGDIR.get().resolve(MOD_ID).resolve("compat").resolve(modid + ".hlc").toFile());
                LOG.info("Added " + ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid) + " compatibility to Solar Flux.");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        SolarFlux.processCompats(ISFCompat::registerPanels);
        ResourcePackAdapter.registerResourcePack((IResourcePack)SolarFluxResourcePack.getPackInstance());
    }

    public static ResourceLocation id(String s) {
        return new ResourceLocation(MOD_ID, s);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent e) {
        PROXY.commonSetup();
        SFNetwork.init();
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent e) {
        SolarPanels.refreshConfigs();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent e) {
        PROXY.clientSetup();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void modelBake(ModelBakeEvent e) {
        SolarPanels.listPanelBlocks().forEach(spb -> {
            IBakedModel cfr_ignored_0 = (IBakedModel)e.getModelRegistry().put(new ModelResourceLocation(spb.getRegistryName(), ""), new SolarPanelBakedModel((SolarPanelBlock)((Object)spb)));
        });
    }

    public static void processCompats(Consumer<ISFCompat> handler) {
        COMPATS.forEach(handler);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Registration {
        @SubscribeEvent
        public static void startServer(FMLServerStartingEvent e) {
            e.getServer().func_195571_aL().func_197054_a().register((LiteralArgumentBuilder)Commands.func_197057_a((String)SolarFlux.MOD_ID).then(Commands.func_197057_a((String)"reload").executes(src -> {
                SolarPanels.refreshConfigs();
                ((CommandSource)src.getSource()).func_197028_i().func_184103_al().func_181057_v().forEach(SFNetwork::sendAllPanels);
                return 1;
            })));
        }
    }
}

