/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.ae2;

import appeng.core.AELog;
import appeng.core.Api;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.zeith.hammerlib.core.adapter.RegistryAdapter;
import org.zeith.hammerlib.core.adapter.recipe.ShapelessRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.solarflux.compat.ISFCompat;
import org.zeith.solarflux.compat.SFCompat;
import org.zeith.solarflux.compat.ae2.ContentsSFAE2;
import org.zeith.solarflux.compat.ae2.tile.IAE2SolarPanelTile;
import org.zeith.solarflux.items.ItemsSF;
import org.zeith.solarflux.panels.SolarPanels;

@SFCompat(value="appliedenergistics2")
public class AE2Compat
implements ISFCompat {
    public final ResourceLocation aeuEnergyUpgrade = new ResourceLocation("solarflux", "ae2/energy_upgrade");
    private static final ServerTileRepo tiles = new ServerTileRepo();

    public AE2Compat() {
        IEventBus mcf = MinecraftForge.EVENT_BUS;
        mcf.addListener(this::onWorldTick);
        mcf.addListener(this::onUnloadChunk);
        mcf.addListener(this::onLoadWorld);
        mcf.addListener(this::onUnloadWorld);
        mcf.addListener(this::shutdown);
        IEventBus mb = FMLJavaModLoadingContext.get().getModEventBus();
        mb.addGenericListener(Item.class, this::registerItems);
    }

    public void registerItems(RegistryEvent.Register<Item> itemRegistry) {
        RegistryAdapter.register((IForgeRegistry)itemRegistry.getRegistry(), ContentsSFAE2.class, (String)"solarflux");
    }

    @Override
    public void registerPanels() {
    }

    @Override
    public void indexRecipes(ISFCompat.IRecipeIndexer indexer) {
        indexer.index(this.aeuEnergyUpgrade);
    }

    @Override
    public void reloadRecipes(RegisterRecipesEvent e) {
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)e.shapeless().id(this.aeuEnergyUpgrade)).add((Object)Api.instance().definitions().blocks().energyAcceptor().func_199767_j()).add((Object)ItemsSF.BLANK_UPGRADE).result((IItemProvider)ContentsSFAE2.ENERGY_UPGRADE)).registerIf(SolarPanels::isRecipeActive);
    }

    public void onWorldTick(TickEvent.WorldTickEvent ev) {
        World world = ev.world;
        if (!world.field_72995_K && ev.side == LogicalSide.SERVER && ev.phase == TickEvent.Phase.END) {
            this.readyTiles((IWorld)world);
        }
    }

    public void shutdown(FMLServerStoppingEvent e) {
        tiles.clear();
    }

    public void onUnloadChunk(ChunkEvent.Unload ev) {
        if (!ev.getWorld().func_201670_d()) {
            tiles.removeWorldChunk(ev.getWorld(), ev.getChunk().func_76632_l().func_201841_a());
        }
    }

    public void onLoadWorld(WorldEvent.Load ev) {
        if (!ev.getWorld().func_201670_d()) {
            tiles.addWorld(ev.getWorld());
        }
    }

    public void onUnloadWorld(WorldEvent.Unload ev) {
        if (!ev.getWorld().func_201670_d()) {
            tiles.removeWorld(ev.getWorld());
        }
    }

    public static void addInit(IAE2SolarPanelTile tile) {
        if (!tile.level().func_201670_d()) {
            Objects.requireNonNull(tile);
            tiles.addTile(tile);
        }
    }

    private void readyTiles(IWorld world) {
        long[] workSet;
        AbstractChunkProvider chunkProvider = world.func_72863_F();
        Long2ObjectMap<List<IAE2SolarPanelTile>> worldQueue = tiles.getTiles(world);
        long[] var5 = workSet = worldQueue.keySet().toLongArray();
        int var6 = workSet.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            long packedChunkPos = var5[var7];
            ChunkPos chunkPos = new ChunkPos(packedChunkPos);
            BlockPos testBlockPos = new BlockPos(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d());
            if (!world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b) || !chunkProvider.func_222866_a(testBlockPos)) continue;
            List chunkQueue = (List)worldQueue.remove(packedChunkPos);
            if (chunkQueue == null) {
                AELog.warn((String)"Chunk %s was unloaded while we were readying tiles", (Object[])new Object[]{chunkPos});
                continue;
            }
            for (IAE2SolarPanelTile bt : chunkQueue) {
                if (((TileEntity)bt).func_145837_r()) continue;
                bt.onReady();
            }
        }
    }

    static class ServerTileRepo {
        private final Map<IWorld, Long2ObjectMap<List<IAE2SolarPanelTile>>> tiles = new Object2ObjectOpenHashMap();

        ServerTileRepo() {
        }

        void clear() {
            this.tiles.clear();
        }

        synchronized void addTile(IAE2SolarPanelTile tile) {
            World world = tile.level();
            int x = tile.pos().func_177958_n() >> 4;
            int z = tile.pos().func_177952_p() >> 4;
            long chunkPos = ChunkPos.func_77272_a((int)x, (int)z);
            Long2ObjectMap<List<IAE2SolarPanelTile>> worldQueue = this.tiles.get(world);
            ((List)worldQueue.computeIfAbsent(chunkPos, key -> new ArrayList())).add(tile);
        }

        synchronized void addWorld(IWorld world) {
            this.tiles.computeIfAbsent(world, key -> new Long2ObjectOpenHashMap());
        }

        synchronized void removeWorld(IWorld world) {
            this.tiles.remove(world);
        }

        synchronized void removeWorldChunk(IWorld world, long chunkPos) {
            Map queue = (Map)this.tiles.get(world);
            if (queue != null) {
                queue.remove(chunkPos);
            }
        }

        public Long2ObjectMap<List<IAE2SolarPanelTile>> getTiles(IWorld world) {
            return this.tiles.get(world);
        }
    }
}

