/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.twilightforest;

import java.io.File;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.zeith.hammerlib.core.adapter.RegistryAdapter;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryCategory;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.compat.ISFCompat;
import org.zeith.solarflux.compat.SFCompat;
import org.zeith.solarflux.compat.twilightforest.ContentsSFTF;
import org.zeith.solarflux.items.ItemEfficiencyUpgrade;
import org.zeith.solarflux.items.ItemsSF;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanels;

@SFCompat(value="twilightforest")
public class TwilightForestCompat
implements ISFCompat {
    public final ResourceLocation fieryRecipe = SolarFlux.id("solar_panels/twilightforest/fiery");
    public final ResourceLocation carminiteRecipe = SolarFlux.id("solar_panels/twilightforest/carminite");
    public final ResourceLocation twiCell1Recipe = SolarFlux.id("twilightforest/twilight_cell_1");
    public final ResourceLocation twiCell2Recipe = SolarFlux.id("twilightforest/twilight_cell_2");
    public final ResourceLocation twiLightUpgradeRecipe = SolarFlux.id("twilightforest/twilight_upgrade");
    private SolarPanel fiery;
    private SolarPanel carminite;
    public boolean enabled = true;
    private long[] fieryCfg = new long[]{2048L, 16348L, 32000000L};
    private long[] carminiteCfg = new long[]{8192L, 65536L, 64000000L};
    private ConfigFile cfg;

    public TwilightForestCompat() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
    }

    public void registerItems(RegistryEvent.Register<Item> itemRegistry) {
        RegistryAdapter.register((IForgeRegistry)itemRegistry.getRegistry(), ContentsSFTF.class, (String)"solarflux");
    }

    @Override
    public void setupConfigFile(File file) {
        this.cfg = new ConfigFile(file);
        ConfigEntryCategory general = this.cfg.getCategory("General");
        this.enabled = general.getBooleanEntry("Enabled", true).getValue();
        ConfigEntryCategory solar_panels = this.cfg.getCategory("Solar Panels");
        this.fieryCfg = SolarPanels.setupPanel(solar_panels, "Fiery", SolarPanels.CORE_PANELS[5]);
        this.carminiteCfg = SolarPanels.setupPanel(solar_panels, "Carminite", SolarPanels.CORE_PANELS[6]);
        if (this.cfg.hasChanged()) {
            this.cfg.save();
        }
    }

    @Override
    public void registerPanels() {
        this.fiery = SolarPanel.builder().name("tf.fiery").generation(this.fieryCfg[0]).transfer(this.fieryCfg[1]).capacity(this.fieryCfg[2]).buildAndRegister();
        this.carminite = SolarPanel.builder().name("tf.carminite").generation(this.carminiteCfg[0]).transfer(this.carminiteCfg[1]).capacity(this.carminiteCfg[2]).buildAndRegister();
    }

    @Override
    public void indexRecipes(ISFCompat.IRecipeIndexer recipes) {
        recipes.index(this.fieryRecipe, this.carminiteRecipe, this.twiCell1Recipe, this.twiCell2Recipe, this.twiLightUpgradeRecipe);
    }

    @Override
    public void reloadRecipes(RegisterRecipesEvent e) {
        Tags.IOptionalNamedTag fieryBlock = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "storage_blocks/fiery"));
        Tags.IOptionalNamedTag carminiteItem = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "gems/carminite"));
        Tags.IOptionalNamedTag ironwoodBlock = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "storage_blocks/ironwood"));
        Tags.IOptionalNamedTag ironwoodIngot = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/ironwood"));
        Tags.IOptionalNamedTag fieryIngot = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/fiery"));
        Tags.IOptionalNamedTag knightmetal = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/knightmetal"));
        Tags.IOptionalNamedTag steeleaf = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/steeleaf"));
        Item torchberries = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("twilightforest", "torchberries"));
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.twiLightUpgradeRecipe)).result((IItemProvider)ContentsSFTF.TWI_LIGHT_UPGRADE)).shape(new String[]{"ici", "tbt", "iti"}).map('i', (Object)ironwoodIngot).map('c', (Object)Items.field_151113_aN).map('t', (Object)torchberries).map('b', (Object)ItemEfficiencyUpgrade.EFFICIENCY_UPGRADE).registerIf(SolarPanels::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.twiCell1Recipe)).result((IItemProvider)ContentsSFTF.TWILIGHT_CELL_1, 2)).shape(new String[]{"bbb", "gdg", "qcq"}).map('b', (Object)ItemsSF.BLAZING_COATING).map('g', (Object)fieryIngot).map('d', (Object)steeleaf).map('q', (Object)ironwoodBlock).map('c', (Object)ItemsSF.PHOTOVOLTAIC_CELL_3).registerIf(SolarPanels::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.twiCell2Recipe)).result((IItemProvider)ContentsSFTF.TWILIGHT_CELL_2, 3)).shape(new String[]{"bbb", "gdg", "cqc"}).map('b', (Object)ItemsSF.EMERALD_GLASS).map('g', (Object)fieryBlock).map('d', (Object)carminiteItem).map('q', (Object)knightmetal).map('c', (Object)ContentsSFTF.TWILIGHT_CELL_1).registerIf(SolarPanels::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.fieryRecipe)).result((IItemProvider)this.fiery, 2)).shape(new String[]{"ppp", "scs", "sbs"}).map('s', (Object)SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[4])).map('p', (Object)ContentsSFTF.TWILIGHT_CELL_1).map('c', (Object)torchberries).map('b', (Object)fieryBlock).registerIf(SolarPanels::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.carminiteRecipe)).result((IItemProvider)this.carminite, 2)).shape(new String[]{"ppp", "scs", "scs"}).map('s', (Object)this.fiery).map('p', (Object)ContentsSFTF.TWILIGHT_CELL_2).map('c', (Object)carminiteItem).registerIf(SolarPanels::isRecipeActive);
    }
}

