/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.twilightforest.items;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.items._base.Ability;
import org.zeith.solarflux.items._base.ISunIntensityMod;
import org.zeith.solarflux.items._base.UpgradeItem;

public class TwiLightUpgrade
extends UpgradeItem
implements ISunIntensityMod {
    private static final ResourceLocation TWILIGHT = new ResourceLocation("twilightforest", "twilightforest");

    public TwiLightUpgrade() {
        super(new Item.Properties().func_200917_a(1).func_208103_a(Rarity.RARE));
    }

    public static boolean isTwilight(World level) {
        return level != null && Objects.equals(level.func_234923_W_().func_240901_a_(), TWILIGHT);
    }

    @Override
    public float applySunIntensityModifier(ISolarPanelTile tile, float value) {
        if (tile.doesSeeSky() && TwiLightUpgrade.isTwilight(tile.level())) {
            return 0.45f;
        }
        return value;
    }

    @Override
    public boolean canInstall(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return TwiLightUpgrade.isTwilight(tile.level()) && super.canInstall(tile, stack, upgradeInv);
    }

    @Override
    public boolean canStayInPanel(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return TwiLightUpgrade.isTwilight(tile.level()) && super.canStayInPanel(tile, stack, upgradeInv);
    }

    @Override
    public <T> Optional<T> findAbility(Ability<T> ability) {
        return Optional.ofNullable(ability.findIn(this).orElseGet(() -> super.findAbility(ability).orElse(null)));
    }
}

