/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.items._base.UpgradeItem;
import org.zeith.solarflux.util.BlockPosFace;

@SimplyRegister
public class ItemTraversalUpgrade
extends UpgradeItem {
    @RegistryName(value="traversal_upgrade")
    public static final Item TRAVERSAL_UPGRADE = new ItemTraversalUpgrade();
    static List<BlockPos> cache = new ArrayList<BlockPos>();

    public ItemTraversalUpgrade() {
        super(1);
    }

    @Override
    public void update(ISolarPanelTile tile, ItemStack stack, int amount) {
        if (tile.level().func_72820_D() % 20L == 0L) {
            cache.clear();
            tile.traversal().clear();
            cache.add(tile.pos());
            ItemTraversalUpgrade.findMachines(tile, cache, tile.traversal());
        }
    }

    public static void findMachines(ISolarPanelTile tile, List<BlockPos> cache, List<BlockPosFace> acceptors) {
        for (int i = 0; i < cache.size(); ++i) {
            BlockPos pos = cache.get(i);
            for (Direction face : Direction.values()) {
                TileEntity t;
                BlockPos p = pos.func_177972_a(face);
                if (p.func_177951_i((Vector3i)cache.get(0)) > 25.0 || (t = tile.level().func_175625_s(p)) == null) continue;
                t.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d()).filter(IEnergyStorage::canReceive).ifPresent(e -> {
                    if (!cache.contains(p)) {
                        cache.add(p);
                        BlockPosFace bpf = new BlockPosFace(p, face.func_176734_d());
                        acceptors.add(bpf);
                    }
                });
            }
        }
    }

    @Override
    protected Object[] hoverTextData(ItemStack stack) {
        return new Object[]{Math.round((float)Math.sqrt(25.0))};
    }
}

