/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.mixins.compat.ae2;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.INetworkToolAgent;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.solarflux.attribute.SimpleAttributeProperty;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.compat.ae2.AE2Compat;
import org.zeith.solarflux.compat.ae2.ContentsSFAE2;
import org.zeith.solarflux.compat.ae2.tile.IAE2SolarPanelTile;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanels;

@Mixin(value={SolarPanelTile.class})
@Implements(value={@Interface(iface=IAEPowerStorage.class, prefix="ae$"), @Interface(iface=IGridProxyable.class, prefix="aegrid$"), @Interface(iface=IActionHost.class, prefix="aeinw$"), @Interface(iface=INetworkToolAgent.class, prefix="aenta$"), @Interface(iface=IAE2SolarPanelTile.class, prefix="sfr$")})
public abstract class SolarPanelTileMixin
extends TileSyncableTickable
implements IAEPowerStorage,
IGridProxyable,
IAE2SolarPanelTile {
    @Shadow
    public long energy;
    @Shadow
    @Final
    public SimpleAttributeProperty capacity;
    @Shadow
    private SolarPanel delegate;
    private AENetworkProxy gridProxy;

    public SolarPanelTileMixin(TileEntityType<?> type) {
        super(type);
    }

    @Override
    @Shadow
    public abstract int getUpgrades(Item var1);

    @Shadow
    public abstract int extractEnergy(int var1, boolean var2);

    @Inject(method={"onConstructed"}, at={@At(value="HEAD")}, remap=false)
    private void constructed(CallbackInfo ci) {
        this.createAe2MainNode();
    }

    private void createAe2MainNode() {
        if (this.gridProxy != null) {
            this.gridProxy.remove();
        }
        ItemStack visual = new ItemStack((IItemProvider)SolarPanels.CORE_PANELS[0]);
        if (this.delegate != null) {
            visual = new ItemStack((IItemProvider)this.delegate);
        }
        this.gridProxy = new AENetworkProxy((IGridProxyable)this, "AEGrid", visual, true);
        this.gridProxy.setValidSides(EnumSet.copyOf(Arrays.stream(Direction.values()).filter(f -> f != Direction.UP).collect(Collectors.toSet())));
    }

    @Inject(method={"setDelegate"}, at={@At(value="HEAD")}, remap=false)
    private void updateAEDelegate(SolarPanel delegate, CallbackInfo ci) {
        if (this.gridProxy != null) {
            this.gridProxy.setVisualRepresentation(new ItemStack((IItemProvider)delegate));
        }
    }

    @Inject(method={"onChunkUnloadedSFR"}, at={@At(value="HEAD")}, remap=false)
    public void onChunkUnloadedAE(CallbackInfo ci) {
        if (this.gridProxy != null) {
            this.gridProxy.onChunkUnloaded();
        }
    }

    @Inject(method={"setRemovedSFR"}, at={@At(value="HEAD")}, remap=false)
    public void setRemovedAE(CallbackInfo ci) {
        if (this.gridProxy != null) {
            this.gridProxy.remove();
        }
    }

    @Inject(method={"clearRemovedSFR"}, at={@At(value="HEAD")}, remap=false)
    public void clearRemovedAE(CallbackInfo ci) {
        if (this.gridProxy != null) {
            this.validate();
        }
    }

    public void validate() {
        if (this.gridProxy != null) {
            AE2Compat.addInit(this);
        }
    }

    public void sfr$onReady() {
        if (this.gridProxy != null) {
            this.gridProxy.onReady();
        }
    }

    @Inject(method={"writeNBT"}, at={@At(value="HEAD")}, remap=false)
    public void writeNBT_AE(CompoundNBT nbt, CallbackInfoReturnable<CompoundNBT> cir) {
        this.gridProxy.writeToNBT(nbt);
    }

    @Inject(method={"readNBT"}, at={@At(value="TAIL")}, remap=false)
    public void readNBT_AE(CompoundNBT nbt, CallbackInfo ci) {
        if (this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) > 0) {
            this.createAe2MainNode();
            this.gridProxy.readFromNBT(nbt);
        }
    }

    public double ae$extractAEPower(double toExtract, Actionable action, PowerMultiplier mult) {
        if (this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) <= 0) {
            return 0.0;
        }
        int fe = (int)Math.min(Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, toExtract)), 2.147483646E9);
        fe = this.extractEnergy(fe, action == Actionable.SIMULATE);
        return mult.multiply(PowerUnits.RF.convertTo(PowerUnits.AE, (double)fe));
    }

    public void aegrid$securityBreak() {
    }

    public double ae$getAECurrentPower() {
        return PowerUnits.RF.convertTo(PowerUnits.AE, (double)this.energy);
    }

    public double ae$getAEMaxPower() {
        return PowerUnits.RF.convertTo(PowerUnits.AE, this.capacity.getValue());
    }

    public AccessRestriction ae$getPowerFlow() {
        return this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) > 0 ? AccessRestriction.READ_WRITE : AccessRestriction.NO_ACCESS;
    }

    public double ae$injectAEPower(double amt, Actionable mode) {
        return 0.0;
    }

    public boolean ae$isAEPublicPowerStorage() {
        return true;
    }

    public int ae$getPriority() {
        return 0;
    }

    public void aegrid$saveChanges() {
    }

    public boolean aenta$showNetworkInfo(RayTraceResult context) {
        return this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) > 0;
    }

    @Nullable
    public IGridNode aeinw$getActionableNode() {
        if (this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) <= 0) {
            return null;
        }
        return this.getProxy().getNode();
    }

    public void sfr$setConnectedToAENetwork(boolean connected) {
        boolean isAe2NodeConnected;
        boolean bl = isAe2NodeConnected = this.gridProxy != null && this.gridProxy.getNode() != null;
        if (isAe2NodeConnected != connected) {
            if (connected) {
                this.createAe2MainNode();
                this.validate();
            } else if (this.gridProxy != null) {
                this.gridProxy.remove();
                this.gridProxy = null;
            }
        }
    }

    @Nullable
    public IGridNode aegrid$getGridNode(@Nonnull AEPartLocation aePartLocation) {
        if (aePartLocation == AEPartLocation.UP || this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) <= 0) {
            return null;
        }
        return this.getProxy().getNode();
    }

    public void aegrid$gridChanged() {
    }

    public DimensionalCoord aegrid$getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Nonnull
    public AECableType aegrid$getCableConnectionType(@Nonnull AEPartLocation aePartLocation) {
        return AECableType.GLASS;
    }

    public AENetworkProxy aegrid$getProxy() {
        return this.gridProxy;
    }
}

