/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.tree;

import fr.raksrinana.fallingtree.fabric.tree.TreePart;
import fr.raksrinana.fallingtree.fabric.utils.TreePartType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class Tree {
    private final class_1937 world;
    private final Set<TreePart> parts;
    private final Map<TreePartType, Integer> partCounts;
    private final class_2338 hitPos;

    public Tree(class_1937 world, class_2338 blockPos) {
        this.world = world;
        this.hitPos = blockPos;
        this.parts = new LinkedHashSet<TreePart>();
        this.partCounts = new HashMap<TreePartType, Integer>();
    }

    public void addPart(TreePart treePart) {
        this.parts.add(treePart);
        this.partCounts.compute(treePart.getTreePartType(), (key, value) -> {
            if (Objects.isNull(value)) {
                return 1;
            }
            return value + 1;
        });
    }

    public int getBreakableCount() {
        return Arrays.stream(TreePartType.values()).filter(TreePartType::isBreakable).mapToInt(this::getPartCount).sum();
    }

    private int getPartCount(TreePartType treePartType) {
        return this.partCounts.computeIfAbsent(treePartType, key -> 0);
    }

    public Optional<TreePart> getLastSequencePart() {
        return this.getParts().stream().max(Comparator.comparingInt(TreePart::getSequence));
    }

    public Collection<TreePart> getLogs() {
        return this.getParts().stream().filter(part -> part.getTreePartType() == TreePartType.LOG).collect(Collectors.toSet());
    }

    public Collection<TreePart> getBreakableParts() {
        return this.getParts().stream().filter(part -> part.getTreePartType().isBreakable()).collect(Collectors.toSet());
    }

    public int getLogCount() {
        return this.getPartCount(TreePartType.LOG);
    }

    public Optional<class_2338> getTopMostLog() {
        return this.getLogs().stream().map(TreePart::getBlockPos).max(Comparator.comparingInt(class_2382::method_10264));
    }

    private Optional<class_2338> getTopMostPart() {
        return this.getParts().stream().map(TreePart::getBlockPos).max(Comparator.comparingInt(class_2382::method_10264));
    }

    public Collection<TreePart> getWarts() {
        return this.getParts().stream().filter(part -> part.getTreePartType() == TreePartType.NETHER_WART).collect(Collectors.toSet());
    }

    public class_2338 getHitPos() {
        return this.hitPos;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public Collection<TreePart> getParts() {
        return this.parts;
    }
}

