/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.config;

import fr.raksrinana.fallingtree.forge.config.ToolConfiguration;
import fr.raksrinana.fallingtree.forge.config.TreeConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private static final String[] DESC_REVERSE_SNEAKING = new String[]{"When set to true, a tree will, only be chopped down if the player is sneaking."};
    private static final String[] DESC_BREAK_IN_CREATIVE = new String[]{"When set to true, the mod will, cut down trees in creative too."};
    private final TreeConfiguration trees;
    private final ToolConfiguration tools;
    private final ForgeConfigSpec.BooleanValue reverseSneaking;
    private final ForgeConfigSpec.BooleanValue breakInCreative;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Falling Tree configuration");
        builder.push("trees");
        this.trees = new TreeConfiguration(builder);
        builder.pop();
        builder.push("tools");
        this.tools = new ToolConfiguration(builder);
        builder.pop();
        this.reverseSneaking = builder.comment(DESC_REVERSE_SNEAKING).define("reverse_sneaking", false);
        this.breakInCreative = builder.comment(DESC_BREAK_IN_CREATIVE).define("break_in_creative", false);
    }

    public void setBreakInCreative(Boolean value) {
        this.breakInCreative.set((Object)value);
    }

    public void setReverseSneaking(Boolean value) {
        this.reverseSneaking.set((Object)value);
    }

    public ToolConfiguration getToolsConfiguration() {
        return this.tools;
    }

    public TreeConfiguration getTreesConfiguration() {
        return this.trees;
    }

    public boolean isReverseSneaking() {
        return (Boolean)this.reverseSneaking.get();
    }

    public boolean isBreakInCreative() {
        return (Boolean)this.breakInCreative.get();
    }
}

