/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.breaking;

import fr.raksrinana.fallingtree.forge.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.tree.Tree;
import fr.raksrinana.fallingtree.forge.tree.TreePart;
import fr.raksrinana.fallingtree.forge.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class InstantaneousTreeBreakingHandler
implements ITreeBreakingHandler {
    private static InstantaneousTreeBreakingHandler INSTANCE;

    @Override
    public void breakTree(BlockEvent.BreakEvent event, Tree tree) {
        if (!this.destroy(tree, event.getPlayer(), event.getPlayer().func_184586_b(Hand.MAIN_HAND)) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    private boolean destroy(@Nonnull Tree tree, @Nonnull PlayerEntity player, @Nonnull ItemStack tool) {
        int brokenCount;
        int toolDamage;
        double rawWeightedUsesLeft;
        World world = tree.getWorld();
        int breakableCount = tree.getBreakableCount();
        int damageMultiplicand = Config.COMMON.getToolsConfiguration().getDamageMultiplicand();
        int toolUsesLeft = tool.func_77984_f() ? tool.func_77958_k() - tool.func_77952_i() : Integer.MAX_VALUE;
        double d = rawWeightedUsesLeft = damageMultiplicand == 0 ? (double)(toolUsesLeft - 1) : 1.0 * (double)toolUsesLeft / (double)damageMultiplicand;
        if (Config.COMMON.getToolsConfiguration().isPreserve()) {
            if (rawWeightedUsesLeft <= 1.0) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.fallingtree.prevented_break_tool"), Util.field_240973_b_);
                return false;
            }
            if ((double)breakableCount >= rawWeightedUsesLeft) {
                rawWeightedUsesLeft = Math.ceil(rawWeightedUsesLeft) - 1.0;
            }
        }
        if ((toolDamage = damageMultiplicand * (brokenCount = tree.getBreakableParts().stream().sorted(Comparator.comparingInt(TreePart::getSequence).reversed()).limit((int)rawWeightedUsesLeft).map(TreePart::getBlockPos).mapToInt(logBlockPos -> {
            boolean cancelled;
            BlockState logState = world.func_180495_p(logBlockPos);
            if (!tree.getHitPos().equals(logBlockPos) && (cancelled = MinecraftForge.EVENT_BUS.post((Event)new FallingTreeBlockBreakEvent(world, (BlockPos)logBlockPos, logState, player)))) {
                return 0;
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)logState.func_177230_c().func_199767_j()));
            logState.func_177230_c().func_180657_a(world, player, logBlockPos, logState, world.func_175625_s(logBlockPos), tool);
            world.func_217377_a(logBlockPos, false);
            return 1;
        }).sum()) - 1) > 0) {
            tool.func_222118_a(toolDamage, (LivingEntity)player, entity -> {});
        }
        if (brokenCount >= breakableCount) {
            InstantaneousTreeBreakingHandler.forceBreakDecayLeaves(tree, world);
        }
        return true;
    }

    private static void forceBreakDecayLeaves(@Nonnull Tree tree, World world) {
        int radius = Config.COMMON.getTreesConfiguration().getLeavesBreakingForceRadius();
        if (radius > 0) {
            tree.getTopMostLog().ifPresent(topLog -> {
                BlockPos.Mutable checkPos = new BlockPos.Mutable();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.func_181079_c(topLog.func_177958_n() + dx, topLog.func_177956_o() + dy, topLog.func_177952_p() + dz);
                            BlockState checkState = world.func_180495_p((BlockPos)checkPos);
                            Block checkBlock = checkState.func_177230_c();
                            if (!FallingTreeUtils.isLeafBlock(checkBlock)) continue;
                            Block.func_220075_c((BlockState)checkState, (World)world, (BlockPos)checkPos);
                            world.func_217377_a((BlockPos)checkPos, false);
                        }
                    }
                }
            });
        }
    }

    public static InstantaneousTreeBreakingHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstantaneousTreeBreakingHandler();
        }
        return INSTANCE;
    }
}

