/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.breaking;

import fr.raksrinana.fallingtree.forge.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.tree.Tree;
import fr.raksrinana.fallingtree.forge.tree.TreePart;
import fr.raksrinana.fallingtree.forge.tree.breaking.ITreeBreakingHandler;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class ShiftDownTreeBreakingHandler
implements ITreeBreakingHandler {
    private static ShiftDownTreeBreakingHandler INSTANCE;

    @Override
    public void breakTree(BlockEvent.BreakEvent event, Tree tree) {
        this.destroy(tree, event.getPlayer(), event.getPlayer().func_184586_b(Hand.MAIN_HAND));
        if (event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    private void destroy(@Nonnull Tree tree, @Nonnull PlayerEntity player, @Nonnull ItemStack tool) {
        BlockState logState;
        TreePart treePart;
        BlockPos blockPos;
        boolean cancelled;
        int toolUsesLeft;
        World world = tree.getWorld();
        int damageMultiplicand = Config.COMMON.getToolsConfiguration().getDamageMultiplicand();
        int n = toolUsesLeft = tool.func_77984_f() ? tool.func_77958_k() - tool.func_77952_i() : Integer.MAX_VALUE;
        if (Config.COMMON.getToolsConfiguration().isPreserve() && toolUsesLeft <= damageMultiplicand) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.fallingtree.prevented_break_tool"), Util.field_240973_b_);
            return;
        }
        Optional<TreePart> lastSequencePartOptional = tree.getLastSequencePart();
        if (lastSequencePartOptional.isPresent() && !(cancelled = MinecraftForge.EVENT_BUS.post((Event)new FallingTreeBlockBreakEvent(world, blockPos = (treePart = lastSequencePartOptional.get()).getBlockPos(), logState = world.func_180495_p(blockPos), player)))) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)logState.func_177230_c().func_199767_j()));
            logState.func_177230_c().func_180657_a(world, player, tree.getHitPos(), logState, world.func_175625_s(blockPos), tool);
            world.func_217377_a(blockPos, false);
            if (damageMultiplicand > 0) {
                tool.func_222118_a(damageMultiplicand, (LivingEntity)player, entity -> {});
            }
        }
    }

    public static ShiftDownTreeBreakingHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShiftDownTreeBreakingHandler();
        }
        return INSTANCE;
    }
}

