/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.builder.position;

import fr.raksrinana.fallingtree.forge.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.forge.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.forge.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AbovePositionFetcher
implements IPositionFetcher {
    private static AbovePositionFetcher INSTANCE;
    private final Function<BlockPos, BlockPos> lowerPosProvider;
    private final Supplier<IPositionFetcher> positionFetcherSupplier;
    private static AbovePositionFetcher SECOND_STEP_INSTANCE;

    private AbovePositionFetcher(Function<BlockPos, BlockPos> lowerPosProvider, Supplier<IPositionFetcher> positionFetcherSupplier) {
        this.lowerPosProvider = lowerPosProvider;
        this.positionFetcherSupplier = positionFetcherSupplier;
    }

    @Override
    public Collection<ToAnalyzePos> getPositions(World world, BlockPos originPos, ToAnalyzePos parent) {
        BlockPos parentPos = parent.getCheckPos();
        Block parentBlock = world.func_180495_p(parentPos).func_177230_c();
        return BlockPos.func_218281_b((BlockPos)parentPos.func_177984_a().func_177978_c().func_177974_f(), (BlockPos)this.lowerPosProvider.apply(parentPos).func_177968_d().func_177976_e()).map(checkPos -> {
            Block checkBlock = world.func_180495_p(checkPos).func_177230_c();
            return new ToAnalyzePos(this.positionFetcherSupplier.get(), parentPos, parentBlock, checkPos.func_185334_h(), checkBlock, FallingTreeUtils.getTreePart(checkBlock), parent.getSequence() + 1);
        }).collect(Collectors.toList());
    }

    public static AbovePositionFetcher getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new AbovePositionFetcher(BlockPos::func_177984_a, AbovePositionFetcher::getSecondStepInstance);
        }
        return INSTANCE;
    }

    private static AbovePositionFetcher getSecondStepInstance() {
        if (Objects.isNull(SECOND_STEP_INSTANCE)) {
            SECOND_STEP_INSTANCE = new AbovePositionFetcher(Function.identity(), BasicPositionFetcher::getInstance);
        }
        return SECOND_STEP_INSTANCE;
    }
}

