/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.utils;

import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.utils.TreePartType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FallingTreeUtils {
    public static Set<Item> getAsItems(Collection<? extends String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(FallingTreeUtils::getItem).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nonnull
    public static Stream<Item> getItem(String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                return Optional.ofNullable(ItemTags.func_199903_a().func_199910_a(resourceLocation)).map(ITag::func_230236_b_).map(Collection::stream).orElse(Stream.empty());
            }
            return Stream.of(ForgeRegistries.ITEMS.getValue(resourceLocation));
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static Set<Block> getAsBlocks(Collection<? extends String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(FallingTreeUtils::getBlock).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nonnull
    public static Stream<Block> getBlock(String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                return Optional.ofNullable(BlockTags.func_199896_a().func_199910_a(resourceLocation)).map(ITag::func_230236_b_).map(Collection::stream).orElse(Stream.empty());
            }
            return Stream.of(ForgeRegistries.BLOCKS.getValue(resourceLocation));
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static boolean isLeafBlock(@Nonnull Block block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = block.func_203417_a((ITag)BlockTags.field_206952_E) || Config.COMMON.getTreesConfiguration().getWhitelistedLeaves().stream().anyMatch(leaf -> leaf.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = Config.COMMON.getTreesConfiguration().getBlacklistedLeaves().stream().anyMatch(leaf -> leaf.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static TreePartType getTreePart(Block checkBlock) {
        if (FallingTreeUtils.isLogBlock(checkBlock)) {
            return TreePartType.LOG;
        }
        if (FallingTreeUtils.isNetherWartOrShroomlight(checkBlock)) {
            return TreePartType.NETHER_WART;
        }
        if (FallingTreeUtils.isLeafNeedBreakBlock(checkBlock)) {
            return TreePartType.LEAF_NEED_BREAK;
        }
        return TreePartType.OTHER;
    }

    public static boolean isLeafNeedBreakBlock(Block block) {
        return Config.COMMON.getTreesConfiguration().getWhitelistedNonDecayLeaves().stream().anyMatch(log -> log.equals(block));
    }

    public static boolean isLogBlock(Block block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = block.func_203417_a((ITag)BlockTags.field_200031_h) || Config.COMMON.getTreesConfiguration().getWhitelistedLogs().stream().anyMatch(log -> log.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = Config.COMMON.getTreesConfiguration().getBlacklistedLogs().stream().anyMatch(log -> log.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean isNetherWartOrShroomlight(Block block) {
        return block.func_203417_a((ITag)BlockTags.field_232874_ao_) || block.equals(Blocks.field_235383_mw_);
    }
}

