/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import xaero.map.WorldMap;
import xaero.map.message.PacketConsumerForge;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapMessageHandler;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;

public class WorldMapMessageHandlerForge
extends WorldMapMessageHandler {
    @Override
    public <T extends WorldMapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<PacketBuffer, T> decoder, BiConsumer<T, PacketBuffer> encoder) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (clientHandler == null != (serverHandler == null)) {
            WorldMap.network.registerMessage(index, type, encoder, decoder, consumer, Optional.of(clientHandler == null ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT));
            return;
        }
        WorldMap.network.registerMessage(index, type, encoder, decoder, consumer);
    }

    @Override
    public <T extends WorldMapMessage<T>> void sendToPlayer(ServerPlayerEntity player, T message) {
        WorldMap.network.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    @Override
    public <T extends WorldMapMessage<T>> void sendToServer(T message) {
        WorldMap.network.sendToServer(message);
    }
}

