/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.annotation.Validator;
import com.mrcrayfish.guns.common.CustomGun;
import com.mrcrayfish.guns.common.GripType;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.common.JsonDeserializers;
import com.mrcrayfish.guns.item.GunItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="cgm")
public class NetworkGunManager
extends ReloadListener<Map<GunItem, Gun>> {
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON_INSTANCE = (Gson)Util.func_199748_a(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        builder.registerTypeAdapter(GripType.class, JsonDeserializers.GRIP_TYPE);
        return builder.create();
    });
    private static List<GunItem> clientRegisteredGuns = new ArrayList<GunItem>();
    private static NetworkGunManager instance;
    private Map<ResourceLocation, Gun> registeredGuns = new HashMap<ResourceLocation, Gun>();

    protected Map<GunItem, Gun> prepare(IResourceManager manager, IProfiler profiler) {
        HashMap<GunItem, Gun> map = new HashMap<GunItem, Gun>();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof GunItem).forEach(item -> {
            ResourceLocation id = item.getRegistryName();
            if (id != null) {
                ArrayList resources = new ArrayList(manager.func_199003_a("guns", fileName -> fileName.endsWith(id.func_110623_a() + ".json")));
                resources.sort((r1, r2) -> {
                    if (r1.func_110624_b().equals(r2.func_110624_b())) {
                        return 0;
                    }
                    return r2.func_110624_b().equals("cgm") ? 1 : -1;
                });
                resources.forEach(resource -> {
                    String path = resource.func_110623_a().substring(0, resource.func_110623_a().length() - FILE_TYPE_LENGTH_VALUE);
                    String[] splitPath = path.split("/");
                    if (!id.func_110623_a().equals(splitPath[splitPath.length - 1])) {
                        return;
                    }
                    try (InputStream inputstream = manager.func_199002_a(resource).func_199027_b();
                         BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        Gun gun = (Gun)JSONUtils.func_193839_a((Gson)GSON_INSTANCE, (Reader)reader, Gun.class);
                        if (gun != null && Validator.isValidObject(gun)) {
                            map.put((GunItem)item, gun);
                        } else {
                            GunMod.LOGGER.error("Couldn't load data file {} as it is missing or malformed. Using default gun data", resource);
                            map.putIfAbsent((GunItem)item, new Gun());
                        }
                    }
                    catch (InvalidObjectException e) {
                        GunMod.LOGGER.error("Missing required properties for {}", resource);
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        GunMod.LOGGER.error("Couldn't parse data file {}", resource);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                });
            }
        });
        return map;
    }

    protected void apply(Map<GunItem, Gun> objects, IResourceManager resourceManager, IProfiler profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, gun) -> {
            Validate.notNull((Object)item.getRegistryName());
            builder.put((Object)item.getRegistryName(), gun);
            item.setGun(new Supplier((Gun)gun));
        });
        this.registeredGuns = builder.build();
    }

    public void writeRegisteredGuns(PacketBuffer buffer) {
        buffer.func_150787_b(this.registeredGuns.size());
        this.registeredGuns.forEach((id, gun) -> {
            buffer.func_192572_a(id);
            buffer.func_150786_a(gun.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Gun> readRegisteredGuns(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.func_192575_l();
                Gun gun = Gun.create(buffer.func_150793_b());
                builder.put((Object)id, (Object)gun);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateRegisteredGuns(IGunProvider message) {
        clientRegisteredGuns.clear();
        ImmutableMap<ResourceLocation, Gun> registeredGuns = message.getRegisteredGuns();
        if (registeredGuns != null) {
            for (Map.Entry entry : registeredGuns.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)entry.getKey());
                if (!(item instanceof GunItem)) {
                    return false;
                }
                ((GunItem)item).setGun(new Supplier((Gun)entry.getValue()));
                clientRegisteredGuns.add((GunItem)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, Gun> getRegisteredGuns() {
        return this.registeredGuns;
    }

    public static List<GunItem> getClientRegisteredGuns() {
        return ImmutableList.copyOf(clientRegisteredGuns);
    }

    @SubscribeEvent
    public static void onServerStopped(FMLServerStoppedEvent event) {
        instance = null;
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkGunManager networkGunManager = new NetworkGunManager();
        event.addListener((IFutureReloadListener)networkGunManager);
        instance = networkGunManager;
    }

    @Nullable
    public static NetworkGunManager get() {
        return instance;
    }

    public static class Supplier {
        private Gun gun;

        private Supplier(Gun gun) {
            this.gun = gun;
        }

        public Gun getGun() {
            return this.gun;
        }
    }

    public static interface IGunProvider {
        public ImmutableMap<ResourceLocation, Gun> getRegisteredGuns();

        public ImmutableMap<ResourceLocation, CustomGun> getCustomGuns();
    }
}

