/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class WorkbenchIngredient
extends Ingredient {
    private final Ingredient.IItemList itemList;
    private final int count;

    protected WorkbenchIngredient(Stream<? extends Ingredient.IItemList> itemList, int count) {
        super(itemList);
        this.itemList = null;
        this.count = count;
    }

    private WorkbenchIngredient(Ingredient.IItemList itemList, int count) {
        super(Stream.of(itemList));
        this.itemList = itemList;
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static WorkbenchIngredient fromJson(JsonObject object) {
        Ingredient.IItemList value = WorkbenchIngredient.func_199803_a((JsonObject)object);
        int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return new WorkbenchIngredient(Stream.of(value), count);
    }

    public JsonElement func_200304_c() {
        JsonObject object = this.itemList.func_200303_b();
        object.addProperty("count", (Number)this.count);
        return object;
    }

    public static WorkbenchIngredient of(IItemProvider provider, int count) {
        return new WorkbenchIngredient((Ingredient.IItemList)new Ingredient.SingleItemList(new ItemStack(provider)), count);
    }

    public static WorkbenchIngredient of(ItemStack stack, int count) {
        return new WorkbenchIngredient((Ingredient.IItemList)new Ingredient.SingleItemList(stack), count);
    }

    public static WorkbenchIngredient of(ITag<Item> tag, int count) {
        return new WorkbenchIngredient((Ingredient.IItemList)new Ingredient.TagList(tag), count);
    }

    public static WorkbenchIngredient of(ResourceLocation id, int count) {
        return new WorkbenchIngredient(new MissingSingleItemList(id), count);
    }

    public static class MissingSingleItemList
    implements Ingredient.IItemList {
        private final ResourceLocation id;

        public MissingSingleItemList(ResourceLocation id) {
            this.id = id;
        }

        public Collection<ItemStack> func_199799_a() {
            return Collections.emptyList();
        }

        public JsonObject func_200303_b() {
            JsonObject object = new JsonObject();
            object.addProperty("item", this.id.toString());
            return object;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<WorkbenchIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public WorkbenchIngredient parse(PacketBuffer buffer) {
            int itemCount = buffer.func_150792_a();
            int count = buffer.func_150792_a();
            Stream<Ingredient.SingleItemList> values = Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(itemCount);
            return new WorkbenchIngredient(values, count);
        }

        public WorkbenchIngredient parse(JsonObject object) {
            return WorkbenchIngredient.fromJson(object);
        }

        public void write(PacketBuffer buffer, WorkbenchIngredient ingredient) {
            buffer.func_150787_b(ingredient.func_193365_a().length);
            buffer.func_150787_b(ingredient.count);
            for (ItemStack stack : ingredient.func_193365_a()) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

