/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.util;

import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModEnchantments;
import com.mrcrayfish.guns.particles.TrailData;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;

public class GunEnchantmentHelper {
    public static IParticleData getParticle(ItemStack weapon) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)weapon);
        if (enchantments.containsKey(ModEnchantments.FIRE_STARTER.get())) {
            return ParticleTypes.field_197595_F;
        }
        if (enchantments.containsKey(ModEnchantments.PUNCTURING.get())) {
            return ParticleTypes.field_197622_o;
        }
        return new TrailData(weapon.func_77948_v());
    }

    public static int getReloadInterval(ItemStack weapon) {
        int interval = 10;
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)weapon);
        if (level > 0) {
            interval -= 3 * level;
        }
        return Math.max(interval, 1);
    }

    public static int getRate(ItemStack weapon, Gun modifiedGun) {
        int rate = modifiedGun.getGeneral().getRate();
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.TRIGGER_FINGER.get()), (ItemStack)weapon);
        if (level > 0) {
            float newRate = (float)rate * (0.25f * (float)level);
            rate = (int)((float)rate - MathHelper.func_76131_a((float)newRate, (float)0.0f, (float)rate));
        }
        return rate;
    }

    public static double getAimDownSightSpeed(ItemStack weapon) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.LIGHTWEIGHT.get()), (ItemStack)weapon);
        return level > 0 ? 1.5 : 1.0;
    }

    public static int getAmmoCapacity(ItemStack weapon, Gun modifiedGun) {
        int capacity = modifiedGun.getGeneral().getMaxAmmo();
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.OVER_CAPACITY.get()), (ItemStack)weapon);
        if (level > 0) {
            capacity += capacity / 2 * level;
        }
        return capacity;
    }

    public static double getProjectileSpeedModifier(ItemStack weapon) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        if (level > 0) {
            return 1.0 + 0.15 * (double)level;
        }
        return 1.0;
    }

    public static float getAcceleratorDamage(ItemStack weapon, float damage) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        if (level > 0) {
            return damage + damage * (0.1f * (float)level);
        }
        return damage;
    }

    public static float getPuncturingChance(ItemStack weapon) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.PUNCTURING.get()), (ItemStack)weapon);
        return (float)level * 0.05f;
    }
}

