/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public enum CapabilityManager {
    INSTANCE;

    private static final Logger LOGGER;
    private static final Type CAP_INJECT;
    private final IdentityHashMap<String, Capability<?>> providers = new IdentityHashMap();
    private volatile IdentityHashMap<String, List<Function<Capability<?>, Object>>> callbacks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(Class<T> type, Capability.IStorage<T> storage, Callable<? extends T> factory) {
        Capability cap;
        Objects.requireNonNull(type, "Attempted to register a capability with invalid type");
        Objects.requireNonNull(storage, "Attempted to register a capability with no storage implementation");
        Objects.requireNonNull(factory, "Attempted to register a capability with no default implementation factory");
        String realName = type.getName().intern();
        IdentityHashMap<String, Capability<?>> identityHashMap = this.providers;
        synchronized (identityHashMap) {
            if (this.providers.containsKey(realName)) {
                LOGGER.error(Logging.CAPABILITIES, "Cannot register capability implementation multiple times : {}", (Object)realName);
                throw new IllegalArgumentException("Cannot register a capability implementation multiple times : " + realName);
            }
            cap = new Capability(realName, storage, factory);
            this.providers.put(realName, cap);
        }
        this.callbacks.getOrDefault(realName, Collections.emptyList()).forEach(func -> func.apply(cap));
    }

    public void injectCapabilities(List<ModFileScanData> data) {
        List<ModFileScanData.AnnotationData> capabilities = data.stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> CAP_INJECT.equals((Object)a.getAnnotationType())).collect(Collectors.toList());
        IdentityHashMap m = new IdentityHashMap();
        capabilities.forEach(entry -> CapabilityManager.attachCapabilityToMethod(m, entry));
        this.callbacks = m;
    }

    private static void attachCapabilityToMethod(Map<String, List<Function<Capability<?>, Object>>> cbs, ModFileScanData.AnnotationData entry) {
        String targetClass = entry.getClassType().getClassName();
        String targetName = entry.getMemberName();
        Type type = (Type)entry.getAnnotationData().get("value");
        if (type == null) {
            LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability at {}.{} (Invalid Annotation)", (Object)targetClass, (Object)targetName);
            return;
        }
        String capabilityName = type.getInternalName().replace('/', '.').intern();
        List list = cbs.computeIfAbsent(capabilityName, k -> new ArrayList());
        if (entry.getMemberName().indexOf(40) > 0) {
            list.add(input -> {
                try {
                    for (Method mtd : Class.forName(targetClass).getDeclaredMethods()) {
                        if (!targetName.equals(mtd.getName() + Type.getMethodDescriptor((Method)mtd))) continue;
                        if ((mtd.getModifiers() & 8) != 8) {
                            LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{} (Non-Static)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                            return null;
                        }
                        mtd.setAccessible(true);
                        mtd.invoke(null, input);
                        return null;
                    }
                    LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{} (Method Not Found)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                }
                catch (Exception e) {
                    LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{}", (Object)capabilityName, (Object)targetClass, (Object)targetName, (Object)e);
                }
                return null;
            });
        } else {
            list.add(input -> {
                try {
                    Field field = Class.forName(targetClass).getDeclaredField(targetName);
                    if ((field.getModifiers() & 8) != 8) {
                        LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{} (Non-Static)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                        return null;
                    }
                    field.setAccessible(true);
                    field.set(null, input);
                }
                catch (Exception e) {
                    LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{}", (Object)capabilityName, (Object)targetClass, (Object)targetName, (Object)e);
                }
                return null;
            });
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        CAP_INJECT = Type.getType(CapabilityInject.class);
    }
}

