/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandler;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.play.server.SAdvancementInfoPacket;
import net.minecraft.network.play.server.STagsListPacket;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraftforge.network.VanillaPacketFilter;
import net.minecraftforge.network.VanillaPacketSplitter;

@ChannelHandler.Sharable
public class ForgeConnectionNetworkFilter
extends VanillaPacketFilter {
    @Deprecated
    public ForgeConnectionNetworkFilter() {
        this((NetworkManager)null);
    }

    public ForgeConnectionNetworkFilter(@Nullable NetworkManager manager) {
        super(ForgeConnectionNetworkFilter.buildHandlers(manager));
    }

    private static Map<Class<? extends IPacket<?>>, BiConsumer<IPacket<?>, List<? super IPacket<?>>>> buildHandlers(@Nullable NetworkManager manager) {
        VanillaPacketSplitter.RemoteCompatibility compatibility;
        VanillaPacketSplitter.RemoteCompatibility remoteCompatibility = compatibility = manager == null ? VanillaPacketSplitter.RemoteCompatibility.ABSENT : VanillaPacketSplitter.getRemoteCompatibility(manager);
        if (compatibility == VanillaPacketSplitter.RemoteCompatibility.ABSENT) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().put(SUpdateRecipesPacket.class, ForgeConnectionNetworkFilter::splitPacket).put(STagsListPacket.class, ForgeConnectionNetworkFilter::splitPacket);
        if (compatibility == VanillaPacketSplitter.RemoteCompatibility.V11) {
            builder.put(SAdvancementInfoPacket.class, ForgeConnectionNetworkFilter::splitPacket);
        }
        return builder.build();
    }

    @Override
    protected boolean isNecessary(NetworkManager manager) {
        return !manager.func_150731_c() && VanillaPacketSplitter.isRemoteCompatible(manager);
    }

    private static void splitPacket(IPacket<?> packet, List<? super IPacket<?>> out) {
        VanillaPacketSplitter.appendPackets(ProtocolType.PLAY, PacketDirection.CLIENTBOUND, packet, out);
    }
}

